/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateHttp2SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.SolrCmdDistributor;
import org.eclipse.jetty.client.api.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorReportingConcurrentUpdateSolrClient
extends ConcurrentUpdateHttp2SolrClient {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrCmdDistributor.Req req;
    private final List<SolrCmdDistributor.Error> errors;

    public ErrorReportingConcurrentUpdateSolrClient(Builder builder) {
        super((ConcurrentUpdateHttp2SolrClient.Builder)builder);
        this.req = builder.req;
        this.errors = builder.errors;
    }

    public void handleError(Throwable ex) {
        log.error("Error when calling {} to {}", new Object[]{this.req.toString(), this.req.node.getUrl(), ex});
        SolrCmdDistributor.Error error = new SolrCmdDistributor.Error();
        error.e = (Exception)ex;
        if (ex instanceof SolrException) {
            error.statusCode = ((SolrException)ex).code();
        }
        error.req = this.req;
        this.errors.add(error);
        if (!this.req.shouldRetry(error)) {
            this.req.trackRequestResult(null, null, false);
        }
    }

    public void onSuccess(Response resp, InputStream respBody) {
        this.req.trackRequestResult(resp, respBody, true);
    }

    static class Builder
    extends ConcurrentUpdateHttp2SolrClient.Builder {
        protected SolrCmdDistributor.Req req;
        protected List<SolrCmdDistributor.Error> errors;

        public Builder(String baseSolrUrl, Http2SolrClient client, SolrCmdDistributor.Req req, List<SolrCmdDistributor.Error> errors) {
            super(baseSolrUrl, client);
            this.req = req;
            this.errors = errors;
        }

        public ErrorReportingConcurrentUpdateSolrClient build() {
            return new ErrorReportingConcurrentUpdateSolrClient(this);
        }
    }
}

