/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.AttributeOnlyServletContext;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.HadoopAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopAuthPlugin
extends AuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String HADOOP_AUTH_TYPE = "type";
    private static final String SYSPROP_PREFIX_PROPERTY = "sysPropPrefix";
    private static final String AUTH_CONFIG_NAMES_PROPERTY = "authConfigs";
    private static final String DEFAULT_AUTH_CONFIGS_PROPERTY = "defaultConfigs";
    private static final String DELEGATION_TOKEN_ENABLED_PROPERTY = "enableDelegationToken";
    private static final String INIT_KERBEROS_ZK = "initKerberosZk";
    public static final String PROXY_USER_CONFIGS = "proxyUserConfigs";
    private static final boolean TRACE_HTTP = Boolean.getBoolean("hadoopauth.tracehttp");
    private AuthenticationFilter authFilter;
    private final Locale defaultLocale = Locale.getDefault();
    protected final CoreContainer coreContainer;

    public HadoopAuthPlugin(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        try {
            String delegationTokenEnabled = (String)pluginConfig.getOrDefault(DELEGATION_TOKEN_ENABLED_PROPERTY, "false");
            this.authFilter = Boolean.parseBoolean(delegationTokenEnabled) ? new HadoopAuthFilter() : new AuthenticationFilter(){

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                    Locale.setDefault(Locale.US);
                    super.doFilter(request, response, filterChain);
                }

                protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    Locale.setDefault(HadoopAuthPlugin.this.defaultLocale);
                    super.doFilter(filterChain, request, response);
                }
            };
            boolean initKerberosZk = Boolean.parseBoolean((String)pluginConfig.getOrDefault(INIT_KERBEROS_ZK, "false"));
            if (initKerberosZk) {
                new Krb5HttpClientBuilder().getBuilder();
            }
            FilterConfig conf = this.getInitFilterConfig(pluginConfig);
            this.authFilter.init(conf);
        }
        catch (ServletException e) {
            log.error("Error initializing " + this.getClass().getSimpleName(), (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing " + this.getClass().getName() + ": " + (Object)((Object)e));
        }
    }

    protected FilterConfig getInitFilterConfig(Map<String, Object> pluginConfig) {
        final HashMap<String, String> params = new HashMap<String, String>();
        String type = (String)Objects.requireNonNull(pluginConfig.get(HADOOP_AUTH_TYPE));
        params.put(HADOOP_AUTH_TYPE, type);
        String sysPropPrefix = (String)pluginConfig.getOrDefault(SYSPROP_PREFIX_PROPERTY, "solr.");
        Collection authConfigNames = pluginConfig.getOrDefault(AUTH_CONFIG_NAMES_PROPERTY, Collections.emptyList());
        Map authConfigDefaults = pluginConfig.getOrDefault(DEFAULT_AUTH_CONFIGS_PROPERTY, Collections.emptyMap());
        Map proxyUserConfigs = pluginConfig.getOrDefault(PROXY_USER_CONFIGS, Collections.emptyMap());
        for (String configName : authConfigNames) {
            String defaultConfigVal;
            String systemProperty = sysPropPrefix + configName;
            String configVal = System.getProperty(systemProperty, defaultConfigVal = (String)authConfigDefaults.get(configName));
            if (configVal == null) continue;
            params.put(configName, configVal);
        }
        params.putAll(proxyUserConfigs);
        params.put("delegation-token.json-mapper." + JsonGenerator.Feature.AUTO_CLOSE_TARGET, "false");
        final AttributeOnlyServletContext servletContext = new AttributeOnlyServletContext();
        log.info("Params: " + params);
        ZkController controller = this.coreContainer.getZkController();
        if (controller != null) {
            servletContext.setAttribute("solr.kerberos.delegation.token.zk.client", controller.getZkClient());
        }
        FilterConfig conf = new FilterConfig(){

            public ServletContext getServletContext() {
                return servletContext;
            }

            public Enumeration<String> getInitParameterNames() {
                return new IteratorEnumeration(params.keySet().iterator());
            }

            public String getInitParameter(String param) {
                return (String)params.get(param);
            }

            public String getFilterName() {
                return "HadoopAuthFilter";
            }
        };
        return conf;
    }

    @Override
    public boolean doAuthenticate(ServletRequest request, ServletResponse response, FilterChain filterChain) throws Exception {
        HttpServletResponse frsp = (HttpServletResponse)response;
        if (TRACE_HTTP) {
            HttpServletRequest req = (HttpServletRequest)request;
            log.info("----------HTTP Request---------");
            log.info("{} : {}", (Object)req.getMethod(), (Object)req.getRequestURI());
            log.info("Query : {}", (Object)req.getQueryString());
            log.info("Headers :");
            Enumeration headers = req.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                Enumeration hvals = req.getHeaders(name);
                while (hvals.hasMoreElements()) {
                    log.info("{} : {}", (Object)name, hvals.nextElement());
                }
            }
            log.info("-------------------------------");
        }
        this.authFilter.doFilter(request, (ServletResponse)frsp, filterChain);
        switch (frsp.getStatus()) {
            case 401: {
                this.numWrongCredentials.inc();
                break;
            }
            case 403: {
                this.numErrors.mark();
                break;
            }
            default: {
                if (frsp.getStatus() >= 200 && frsp.getStatus() <= 299) {
                    this.numAuthenticated.inc();
                    break;
                }
                this.numErrors.mark();
            }
        }
        if (TRACE_HTTP) {
            log.info("----------HTTP Response---------");
            log.info("Status : {}", (Object)frsp.getStatus());
            log.info("Headers :");
            for (String name : frsp.getHeaderNames()) {
                for (String value : frsp.getHeaders(name)) {
                    log.info("{} : {}", (Object)name, (Object)value);
                }
            }
            log.info("-------------------------------");
        }
        if (this.authFilter instanceof HadoopAuthFilter) {
            String requestContinuesAttr = (String)request.getAttribute("org.apache.solr.security.authentication.requestcontinues");
            if (requestContinuesAttr == null) {
                log.warn("Could not find org.apache.solr.security.authentication.requestcontinues");
                return false;
            }
            return Boolean.parseBoolean(requestContinuesAttr);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.authFilter != null) {
            this.authFilter.destroy();
        }
    }
}

