/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int MIN_NUM_SUB_SHARDS = 2;
    private static final int MAX_NUM_SUB_SHARDS = 8;
    private static final int DEFAULT_NUM_SUB_SHARDS = 2;
    private final OverseerCollectionMessageHandler ocmh;

    public SplitShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.split(state, message, (NamedList<Object>)results);
    }

    public boolean split(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
        Replica parentShardLeader;
        String asyncId = message.getStr("async");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        String methodStr = message.getStr("splitMethod", SolrIndexSplitter.SplitMethod.REWRITE.toLower());
        SolrIndexSplitter.SplitMethod splitMethod = SolrIndexSplitter.SplitMethod.get(methodStr);
        if (splitMethod == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown value 'splitMethod: " + methodStr);
        }
        boolean withTiming = message.getBool("timing", false);
        String extCollectionName = message.getStr("collection");
        boolean followAliases = message.getBool("followAliases", false);
        String collectionName = followAliases ? this.ocmh.cloudManager.getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
        log.debug("Split shard invoked: {}", (Object)message);
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        zkStateReader.forceUpdateCollection(collectionName);
        AtomicReference<String> slice = new AtomicReference<String>();
        slice.set(message.getStr("shard"));
        HashSet<String> offlineSlices = new HashSet<String>();
        RTimerTree timings = new RTimerTree();
        String splitKey = message.getStr("split.key");
        DocCollection collection = clusterState.getCollection(collectionName);
        PolicyHelper.SessionWrapper sessionWrapper = null;
        Slice parentSlice = SplitShardCmd.getParentSlice(clusterState, collectionName, slice, splitKey);
        if (parentSlice.getState() != Slice.State.ACTIVE) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Parent slice is not active: " + collectionName + "/ " + parentSlice.getName() + ", state=" + parentSlice.getState());
        }
        try {
            parentShardLeader = zkStateReader.getLeaderRetry(collectionName, slice.get(), 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted.");
        }
        RTimerTree t = timings.sub("checkDiskSpace");
        this.checkDiskSpace(collectionName, slice.get(), parentShardLeader);
        t.stop();
        Stat leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
        if (leaderZnodeStat == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
        }
        ArrayList<DocRouter.Range> subRanges = new ArrayList<DocRouter.Range>();
        ArrayList<String> subSlices = new ArrayList<String>();
        ArrayList<String> subShardNames = new ArrayList<String>();
        AtomicInteger numNrt = new AtomicInteger();
        AtomicInteger numTlog = new AtomicInteger();
        AtomicInteger numPull = new AtomicInteger();
        parentSlice.getReplicas().forEach(r -> {
            switch (r.getType()) {
                case NRT: {
                    numNrt.incrementAndGet();
                    break;
                }
                case TLOG: {
                    numTlog.incrementAndGet();
                    break;
                }
                case PULL: {
                    numPull.incrementAndGet();
                }
            }
        });
        int repFactor = numNrt.get() + numTlog.get() + numPull.get();
        boolean success = false;
        try {
            Object propMap;
            boolean firstNrtReplica;
            boolean bl = firstNrtReplica = parentShardLeader.getType() == Replica.Type.NRT;
            if (firstNrtReplica && numNrt.get() < 1 || !firstNrtReplica && numTlog.get() < 1) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "aborting split - inconsistent replica types in collection " + collectionName + ": nrt=" + numNrt.get() + ", tlog=" + numTlog.get() + ", pull=" + numPull.get() + ", shard leader type is " + parentShardLeader.getType());
            }
            if (!SplitShardCmd.lockForSplit(this.ocmh.cloudManager, collectionName, parentSlice.getName())) {
                success = true;
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Can't lock parent slice for splitting (another split operation running?): " + collectionName + "/" + parentSlice.getName());
            }
            ArrayList replicas = new ArrayList((repFactor - 1) * 2);
            ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler(this.ocmh.overseer.getCoreContainer().getUpdateShardHandler().getDefaultHttpClient());
            if (message.getBool("splitByPrefix", false)) {
                NamedList shardRsp;
                String splits;
                t = timings.sub("getRanges");
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
                params.set("getRanges", new String[]{"true"});
                params.set("splitMethod", new String[]{splitMethod.toLower()});
                params.set("core", new String[]{parentShardLeader.getStr("core")});
                OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(asyncId);
                shardRequestTracker.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler);
                SimpleOrderedMap getRangesResults = new SimpleOrderedMap();
                String msgOnError = "SPLITSHARD failed to invoke SPLIT.getRanges core admin command";
                shardRequestTracker.processResponses((NamedList<Object>)getRangesResults, shardHandler, true, msgOnError);
                this.handleFailureOnAsyncRequest(results, msgOnError);
                NamedList successes = (NamedList)getRangesResults.get("success");
                if (successes != null && successes.size() > 0 && (splits = (String)(shardRsp = (NamedList)successes.getVal(0)).get("ranges")) != null) {
                    log.info("Resulting split ranges to be used: " + splits + " slice=" + slice + " leader=" + parentShardLeader);
                    message = message.plus("ranges", (Object)splits);
                }
                t.stop();
            }
            t = timings.sub("fillRanges");
            String rangesStr = SplitShardCmd.fillRanges(this.ocmh.cloudManager, message, collection, parentSlice, subRanges, subSlices, subShardNames, firstNrtReplica);
            t.stop();
            boolean oldShardsDeleted = false;
            for (String subSlice : subSlices) {
                Slice oSlice = collection.getSlice(subSlice);
                if (oSlice == null) continue;
                Slice.State state = oSlice.getState();
                if (state == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)subSlice);
                HashMap<String, String> propMap2 = new HashMap<String, String>();
                propMap2.put("operation", "deleteshard");
                propMap2.put("collection", collectionName);
                propMap2.put("shard", subSlice);
                ZkNodeProps m2 = new ZkNodeProps(propMap2);
                try {
                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETESHARD).call(clusterState, m2, new NamedList());
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + subSlice, (Throwable)e);
                }
                oldShardsDeleted = true;
            }
            if (oldShardsDeleted) {
                clusterState = zkStateReader.getClusterState();
                collection = clusterState.getCollection(collectionName);
            }
            String nodeName = parentShardLeader.getNodeName();
            t = timings.sub("createSubSlicesAndLeadersInState");
            for (int i = 0; i < subRanges.size(); ++i) {
                String subSlice = (String)subSlices.get(i);
                String subShardName2 = (String)subShardNames.get(i);
                DocRouter.Range subRange = (DocRouter.Range)subRanges.get(i);
                log.debug("Creating slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                HashMap<String, Object> propMap3 = new HashMap<String, Object>();
                propMap3.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
                propMap3.put("shard", subSlice);
                propMap3.put("collection", collectionName);
                propMap3.put("shard_range", subRange.toString());
                propMap3.put("shard_state", Slice.State.CONSTRUCTION.toString());
                propMap3.put("shard_parent", parentSlice.getName());
                propMap3.put("shard_parent_node", nodeName);
                propMap3.put("shard_parent_zk_session", leaderZnodeStat.getEphemeralOwner());
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)new ZkNodeProps(propMap3)));
                clusterState = this.ocmh.waitForNewShard(collectionName, subSlice);
                log.debug("Adding first replica " + subShardName2 + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap3 = new HashMap();
                propMap3.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap3.put("collection", collectionName);
                propMap3.put("shard", subSlice);
                propMap3.put("type", firstNrtReplica ? Replica.Type.NRT.toString() : Replica.Type.TLOG.toString());
                propMap3.put("node", nodeName);
                propMap3.put("name", subShardName2);
                propMap3.put("waitForFinalState", Boolean.toString(waitForFinalState));
                for (String key : message.keySet()) {
                    if (!key.startsWith("property.")) continue;
                    propMap3.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap3.put("async", asyncId);
                }
                this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap3), results, null);
            }
            OverseerCollectionMessageHandler.ShardRequestTracker syncRequestTracker = this.ocmh.syncRequestTracker();
            Object msgOnError = "SPLITSHARD failed to create subshard leaders";
            syncRequestTracker.processResponses(results, shardHandler, true, (String)msgOnError);
            this.handleFailureOnAsyncRequest(results, (String)msgOnError);
            t.stop();
            t = timings.sub("waitForSubSliceLeadersAlive");
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker = this.ocmh.asyncRequestTracker(asyncId);
            for (String subShardName : subShardNames) {
                log.debug("Asking parent leader to wait for: " + subShardName + " to be alive on: " + nodeName);
                String coreNodeName = this.ocmh.waitForCoreNodeName(collectionName, nodeName, subShardName);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState(Replica.State.ACTIVE);
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                shardRequestTracker.sendShardRequest(nodeName, p, shardHandler);
            }
            msgOnError = "SPLITSHARD timed out waiting for subshard leaders to come up";
            shardRequestTracker.processResponses(results, shardHandler, true, (String)msgOnError);
            this.handleFailureOnAsyncRequest(results, (String)msgOnError);
            t.stop();
            log.debug("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("splitMethod", new String[]{splitMethod.toLower()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (int i = 0; i < subShardNames.size(); ++i) {
                String subShardName;
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            params.set("ranges", new String[]{rangesStr});
            t = timings.sub("splitParentCore");
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker2 = this.ocmh.asyncRequestTracker(asyncId);
            shardRequestTracker2.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler);
            String msgOnError2 = "SPLITSHARD failed to invoke SPLIT core admin command";
            shardRequestTracker2.processResponses(results, shardHandler, true, msgOnError2);
            this.handleFailureOnAsyncRequest(results, msgOnError2);
            t.stop();
            log.debug("Index on shard: {} split into {} successfully", (Object)nodeName, (Object)subShardNames.size());
            t = timings.sub("applyBufferedUpdates");
            OverseerCollectionMessageHandler.ShardRequestTracker shardRequestTracker3 = this.ocmh.asyncRequestTracker(asyncId);
            for (int i = 0; i < subShardNames.size(); ++i) {
                String subShardName3 = (String)subShardNames.get(i);
                log.debug("Applying buffered updates on : " + subShardName3);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName3});
                shardRequestTracker3.sendShardRequest(nodeName, params, shardHandler);
            }
            String msgOnError3 = "SPLITSHARD failed while asking sub shard leaders to apply buffered updates";
            shardRequestTracker3.processResponses(results, shardHandler, true, msgOnError3);
            this.handleFailureOnAsyncRequest(results, msgOnError3);
            t.stop();
            log.debug("Successfully applied buffered updates on : " + subShardNames);
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            nodeList.remove(nodeName);
            if (firstNrtReplica) {
                numNrt.decrementAndGet();
            } else {
                numTlog.decrementAndGet();
            }
            t = timings.sub("identifyNodesForReplicas");
            Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(collectionName).forShard(subSlices).assignNrtReplicas(numNrt.get()).assignTlogReplicas(numTlog.get()).assignPullReplicas(numPull.get()).onNodes(new ArrayList<String>(clusterState.getLiveNodes())).build();
            Assign.AssignStrategyFactory assignStrategyFactory = new Assign.AssignStrategyFactory(this.ocmh.cloudManager);
            Assign.AssignStrategy assignStrategy = assignStrategyFactory.create(clusterState, collection);
            List<ReplicaPosition> replicaPositions = assignStrategy.assign(this.ocmh.cloudManager, assignRequest);
            sessionWrapper = PolicyHelper.getLastSessionWrapper((boolean)true);
            t.stop();
            t = timings.sub("createReplicaPlaceholders");
            for (ReplicaPosition replicaPosition : replicaPositions) {
                String sliceName = replicaPosition.shard;
                String string = replicaPosition.node;
                String solrCoreName = Assign.buildSolrCoreName(collectionName, sliceName, replicaPosition.type, replicaPosition.index);
                log.debug("Creating replica shard " + solrCoreName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + string);
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", sliceName, "core", solrCoreName, "type", replicaPosition.type.name(), "state", Replica.State.DOWN.toString(), "base_url", zkStateReader.getBaseUrlForNodeName(string), "node_name", string, "waitForFinalState", Boolean.toString(waitForFinalState)});
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)props));
                HashMap<String, String> propMap4 = new HashMap<String, String>();
                propMap4.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap4.put("collection", collectionName);
                propMap4.put("shard", sliceName);
                propMap4.put("type", replicaPosition.type.name());
                propMap4.put("node", string);
                propMap4.put("name", solrCoreName);
                for (String key : message.keySet()) {
                    if (!key.startsWith("property.")) continue;
                    propMap4.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap4.put("async", asyncId);
                }
                propMap4.put("skipCreateReplicaInClusterState", "true");
                propMap4.put("waitForFinalState", Boolean.toString(waitForFinalState));
                replicas.add(propMap4);
            }
            t.stop();
            assert (TestInjection.injectSplitFailureBeforeReplicaCreation());
            long ephemeralOwner = leaderZnodeStat.getEphemeralOwner();
            leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
            if (leaderZnodeStat == null || ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                propMap = new HashMap<String, String>();
                propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    propMap.put(subSlice, Slice.State.RECOVERY_FAILED.toString());
                }
                propMap.put("collection", collectionName);
                ZkNodeProps zkNodeProps = new ZkNodeProps(propMap);
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)zkNodeProps));
                if (leaderZnodeStat == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
                }
                if (ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The zk session id for the shard leader node: " + parentShardLeader.getNodeName() + " has changed from " + ephemeralOwner + " to " + leaderZnodeStat.getEphemeralOwner() + ". This can cause data loss so we must abort the split");
                }
            }
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                propMap = new HashMap();
                propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                propMap.put(slice.get(), Slice.State.INACTIVE.toString());
                for (String subSlice : subSlices) {
                    propMap.put(subSlice, Slice.State.ACTIVE.toString());
                }
                propMap.put("collection", collectionName);
                ZkNodeProps zkNodeProps = new ZkNodeProps(propMap);
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)zkNodeProps));
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                propMap = new HashMap();
                propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    propMap.put(subSlice, Slice.State.RECOVERY.toString());
                }
                propMap.put("collection", collectionName);
                ZkNodeProps zkNodeProps = new ZkNodeProps(propMap);
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)zkNodeProps));
            }
            t = timings.sub("createCoresForReplicas");
            for (Map map : replicas) {
                this.ocmh.addReplica(clusterState, new ZkNodeProps(map), results, null);
            }
            assert (TestInjection.injectSplitFailureAfterReplicaCreation());
            OverseerCollectionMessageHandler.ShardRequestTracker syncRequestTracker2 = this.ocmh.syncRequestTracker();
            String string = "SPLITSHARD failed to create subshard replicas";
            syncRequestTracker2.processResponses(results, shardHandler, true, string);
            this.handleFailureOnAsyncRequest(results, string);
            t.stop();
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            t = timings.sub("finalCommit");
            this.ocmh.commit(results, slice.get(), parentShardLeader);
            t.stop();
            if (withTiming) {
                results.add("timing", (Object)timings.asNamedList());
            }
            success = true;
            boolean bl2 = true;
            return bl2;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
        finally {
            if (sessionWrapper != null) {
                sessionWrapper.release();
            }
            if (!success) {
                this.cleanupAfterFailure(zkStateReader, collectionName, parentSlice.getName(), subSlices, offlineSlices);
                SplitShardCmd.unlockForSplit(this.ocmh.cloudManager, collectionName, parentSlice.getName());
            }
        }
    }

    private void handleFailureOnAsyncRequest(NamedList results, String msgOnError) {
        Object splitResultFailure = results.get("failure");
        if (splitResultFailure != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError);
        }
    }

    private void checkDiskSpace(String collection, String shard, Replica parentShardLeader) throws SolrException {
        NodeStateProvider nodeStateProvider = this.ocmh.cloudManager.getNodeStateProvider();
        Map nodeValues = nodeStateProvider.getNodeValues(parentShardLeader.getNodeName(), Collections.singletonList("freedisk"));
        Map infos = nodeStateProvider.getReplicaInfo(parentShardLeader.getNodeName(), Collections.singletonList(Variable.Type.CORE_IDX.metricsAttribute));
        if (infos.get(collection) == null || ((Map)infos.get(collection)).get(shard) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "missing replica information for parent shard leader");
        }
        List lst = (List)((Map)infos.get(collection)).get(shard);
        Double indexSize = null;
        for (ReplicaInfo info : lst) {
            if (!info.getCore().equals(parentShardLeader.getCoreName())) continue;
            Number size = (Number)info.getVariable(Variable.Type.CORE_IDX.metricsAttribute);
            if (size == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "missing index size information for parent shard leader");
            }
            indexSize = (Double)Variable.Type.CORE_IDX.convertVal((Object)size);
            break;
        }
        if (indexSize == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "missing replica information for parent shard leader");
        }
        Number freeSize = (Number)nodeValues.get("freedisk");
        if (freeSize == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "missing node disk space information for parent shard leader");
        }
        if (freeSize.doubleValue() < 2.0 * indexSize) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "not enough free disk space to perform index split on node " + parentShardLeader.getNodeName() + ", required: " + 2.0 * indexSize + ", available: " + freeSize);
        }
    }

    private void cleanupAfterFailure(ZkStateReader zkStateReader, String collectionName, String parentShard, List<String> subSlices, Set<String> offlineSlices) {
        log.info("Cleaning up after a failed split of " + collectionName + "/" + parentShard);
        try {
            zkStateReader.forceUpdateCollection(collectionName);
        }
        catch (InterruptedException | KeeperException e) {
            log.warn("Cleanup failed after failed split of " + collectionName + "/" + parentShard + ": (force update collection)", e);
            return;
        }
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollectionOrNull(collectionName);
        if (coll == null) {
            return;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        boolean sendUpdateState = false;
        propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        propMap.put("collection", collectionName);
        for (Object s : coll.getSlices()) {
            if (!subSlices.contains(s.getName())) continue;
            propMap.put(s.getName(), Slice.State.CONSTRUCTION.toString());
            sendUpdateState = true;
        }
        Slice parentSlice = coll.getSlice(parentShard);
        if (parentSlice.getState() == Slice.State.INACTIVE) {
            sendUpdateState = true;
            propMap.put(parentShard, Slice.State.ACTIVE.toString());
        }
        for (String sliceName : offlineSlices) {
            propMap.put(sliceName, Slice.State.ACTIVE.toString());
            sendUpdateState = true;
        }
        if (sendUpdateState) {
            try {
                ZkNodeProps m = new ZkNodeProps(propMap);
                this.ocmh.overseer.offerStateUpdate(Utils.toJSON((Object)m));
            }
            catch (Exception e) {
                log.warn("Cleanup failed after failed split of " + collectionName + "/" + parentShard + ": (slice state changes)", (Throwable)e);
            }
        }
        for (String subSlice : subSlices) {
            Slice s = coll.getSlice(subSlice);
            if (s == null) continue;
            log.debug("- sub-shard: {} exists therefore requesting its deletion", (Object)subSlice);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("operation", "deleteshard");
            props.put("collection", collectionName);
            props.put("shard", subSlice);
            ZkNodeProps m = new ZkNodeProps(props);
            try {
                this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETESHARD).call(clusterState, m, new NamedList());
            }
            catch (Exception e) {
                log.warn("Cleanup failed after failed split of " + collectionName + "/" + parentShard + ": (deleting existing sub shard " + subSlice + ")", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Slice getParentSlice(ClusterState clusterState, String collectionName, AtomicReference<String> slice, String splitKey) {
        Slice parentSlice;
        DocRouter router;
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        if (slice.get() == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection searchSlices = router.getSearchSlicesSingle(splitKey, (SolrParams)new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = (Slice)searchSlices.iterator().next();
            slice.set(parentSlice.getName());
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, slice);
        } else {
            parentSlice = collection.getSlice(slice.get());
        }
        if (parentSlice != null) return parentSlice;
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
    }

    public static String fillRanges(SolrCloudManager cloudManager, ZkNodeProps message, DocCollection collection, Slice parentSlice, List<DocRouter.Range> subRanges, List<String> subSlices, List<String> subShardNames, boolean firstReplicaNrt) {
        int i;
        DocRouter router;
        String splitKey = message.getStr("split.key");
        String rangesStr = message.getStr("ranges");
        String fuzzStr = message.getStr("splitFuzz", "0");
        float fuzz = 0.0f;
        try {
            fuzz = Float.parseFloat(fuzzStr);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid numeric value of 'fuzz': " + fuzzStr);
        }
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            for (int i2 = 0; i2 < ranges.length; ++i2) {
                String r = ranges[i2];
                try {
                    subRanges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (subRanges.get(i2).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList<DocRouter.Range> temp = new ArrayList<DocRouter.Range>(subRanges);
            Collections.sort(temp);
            if (!range.equals((Object)new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                List tmpSubRanges = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (tmpSubRanges.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + parentSlice.getName());
                }
                for (DocRouter.Range subRange : tmpSubRanges) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                subRanges.addAll(tmpSubRanges);
                log.info("Partitioning parent shard " + parentSlice.getName() + " range: " + parentSlice.getRange() + " yields: " + subRanges);
                rangesStr = "";
                for (i = 0; i < subRanges.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = subRanges.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= subRanges.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            int numSubShards = message.getInt("numSubShards", Integer.valueOf(2));
            log.info("{} set at: {}", (Object)"numSubShards", (Object)numSubShards);
            if (numSubShards < 2 || numSubShards > 8) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A shard can only be split into 2 to 8 subshards in one split request. Provided numSubShards=" + numSubShards);
            }
            subRanges.addAll(router.partitionRange(numSubShards, range, fuzz));
        }
        for (int i3 = 0; i3 < subRanges.size(); ++i3) {
            String subSlice = parentSlice.getName() + "_" + i3;
            subSlices.add(subSlice);
            String subShardName = Assign.buildSolrCoreName(cloudManager.getDistribStateManager(), collection, subSlice, firstReplicaNrt ? Replica.Type.NRT : Replica.Type.TLOG);
            subShardNames.add(subShardName);
        }
        return rangesStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lockForSplit(SolrCloudManager cloudManager, String collection, String shard) throws Exception {
        DistribStateManager stateManager;
        String path = "/collections/" + collection + "/" + shard + "-splitting";
        DistribStateManager distribStateManager = stateManager = cloudManager.getDistribStateManager();
        synchronized (distribStateManager) {
            if (stateManager.hasData(path)) {
                VersionedData vd = stateManager.getData(path);
                return false;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("stateTimestamp", String.valueOf(cloudManager.getTimeSource().getEpochTimeNs()));
            byte[] data = Utils.toJSON(map);
            try {
                cloudManager.getDistribStateManager().makePath(path, data, CreateMode.EPHEMERAL, true);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Can't lock parent slice for splitting (another split operation running?): " + collection + "/" + shard, (Throwable)e);
            }
            return true;
        }
    }

    public static void unlockForSplit(SolrCloudManager cloudManager, String collection, String shard) throws Exception {
        if (shard != null) {
            String path = "/collections/" + collection + "/" + shard + "-splitting";
            cloudManager.getDistribStateManager().removeRecursively(path, true, true);
        } else {
            String path = "/collections/" + collection;
            try {
                List names = cloudManager.getDistribStateManager().listData(path);
                for (String name : cloudManager.getDistribStateManager().listData(path)) {
                    if (!name.endsWith("-splitting")) continue;
                    try {
                        cloudManager.getDistribStateManager().removeData(path + "/" + name, -1);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }
}

