/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FSTStore;
import org.apache.lucene.util.fst.OnHeapFSTStore;
import org.apache.lucene.util.fst.Outputs;

public final class FST<T>
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FST.class);
    private static final long ARC_SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Arc.class);
    static final int BIT_FINAL_ARC = 1;
    static final int BIT_LAST_ARC = 2;
    static final int BIT_TARGET_NEXT = 4;
    static final int BIT_STOP_NODE = 8;
    public static final int BIT_ARC_HAS_OUTPUT = 16;
    static final int BIT_ARC_HAS_FINAL_OUTPUT = 32;
    private static final byte ARCS_AS_ARRAY_PACKED = 32;
    private static final byte BIT_MISSING_ARC = 64;
    static final int FIXED_ARRAY_SHALLOW_DISTANCE = 3;
    static final int FIXED_ARRAY_NUM_ARCS_SHALLOW = 5;
    static final int FIXED_ARRAY_NUM_ARCS_DEEP = 10;
    private static final String FILE_FORMAT_NAME = "FST";
    private static final int VERSION_START = 6;
    private static final int VERSION_CURRENT = 6;
    private static final long FINAL_END_NODE = -1L;
    private static final long NON_FINAL_END_NODE = 0L;
    public static final int END_LABEL = -1;
    public final INPUT_TYPE inputType;
    T emptyOutput;
    final BytesStore bytes;
    private final FSTStore fstStore;
    private long startNode = -1L;
    public final Outputs<T> outputs;
    private Arc<T>[] cachedRootArcs;
    private final int version;
    public static final int DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;
    private int cachedArcsBytesUsed;

    private static boolean flag(int flags, int bit) {
        return (flags & bit) != 0;
    }

    FST(INPUT_TYPE inputType, Outputs<T> outputs, int bytesPageBits) {
        this.inputType = inputType;
        this.outputs = outputs;
        this.version = 6;
        this.fstStore = null;
        this.bytes = new BytesStore(bytesPageBits);
        this.bytes.writeByte((byte)0);
        this.emptyOutput = null;
    }

    public FST(DataInput in, Outputs<T> outputs) throws IOException {
        this(in, outputs, new OnHeapFSTStore(DEFAULT_MAX_BLOCK_BITS));
    }

    public FST(DataInput in, Outputs<T> outputs, FSTStore fstStore) throws IOException {
        this.bytes = null;
        this.fstStore = fstStore;
        this.outputs = outputs;
        this.version = CodecUtil.checkHeader(in, FILE_FORMAT_NAME, 6, 6);
        if (in.readByte() == 1) {
            BytesStore emptyBytes = new BytesStore(10);
            int numBytes = in.readVInt();
            emptyBytes.copyBytes(in, numBytes);
            BytesReader reader = emptyBytes.getReverseReader();
            if (numBytes > 0) {
                reader.setPosition(numBytes - 1);
            }
            this.emptyOutput = outputs.readFinalOutput(reader);
        } else {
            this.emptyOutput = null;
        }
        byte t = in.readByte();
        switch (t) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new IllegalStateException("invalid input type " + t);
            }
        }
        this.startNode = in.readVLong();
        long numBytes = in.readVLong();
        this.fstStore.init(in, numBytes);
        this.cacheRootArcs();
    }

    public INPUT_TYPE getInputType() {
        return this.inputType;
    }

    private long ramBytesUsed(Arc<T>[] arcs) {
        long size = 0L;
        if (arcs != null) {
            size += RamUsageEstimator.shallowSizeOf(arcs);
            for (Arc<T> arc : arcs) {
                if (arc == null) continue;
                size += ARC_SHALLOW_RAM_BYTES_USED;
                if (arc.output != null && arc.output != this.outputs.getNoOutput()) {
                    size += this.outputs.ramBytesUsed(arc.output);
                }
                if (arc.nextFinalOutput == null || arc.nextFinalOutput == this.outputs.getNoOutput()) continue;
                size += this.outputs.ramBytesUsed(arc.nextFinalOutput);
            }
        }
        return size;
    }

    @Override
    public long ramBytesUsed() {
        long size = BASE_RAM_BYTES_USED;
        size = this.fstStore != null ? (size += this.fstStore.ramBytesUsed()) : (size += this.bytes.ramBytesUsed());
        return size += (long)this.cachedArcsBytesUsed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(input=" + (Object)((Object)this.inputType) + ",output=" + this.outputs;
    }

    void finish(long newStartNode) throws IOException {
        assert (newStartNode <= this.bytes.getPosition());
        if (this.startNode != -1L) {
            throw new IllegalStateException("already finished");
        }
        if (newStartNode == -1L && this.emptyOutput != null) {
            newStartNode = 0L;
        }
        this.startNode = newStartNode;
        this.bytes.finish();
        this.cacheRootArcs();
    }

    private void cacheRootArcs() throws IOException {
        assert (this.cachedArcsBytesUsed == 0);
        Arc arc = new Arc();
        this.getFirstArc(arc);
        if (FST.targetHasArcs(arc)) {
            BytesReader in = this.getBytesReader();
            Arc[] arcs = new Arc[128];
            this.readFirstRealTargetArc(arc.target, arc, in);
            int count = 0;
            while (true) {
                assert (arc.label != -1);
                if (arc.label >= arcs.length) break;
                arcs[arc.label] = new Arc().copyFrom(arc);
                if (arc.isLast()) break;
                this.readNextRealArc(arc, in);
                ++count;
            }
            int cacheRAM = (int)this.ramBytesUsed(arcs);
            if (count >= 5 && (long)cacheRAM < this.ramBytesUsed() / 5L) {
                this.cachedRootArcs = arcs;
                this.cachedArcsBytesUsed = cacheRAM;
            }
        }
    }

    public T getEmptyOutput() {
        return this.emptyOutput;
    }

    void setEmptyOutput(T v) throws IOException {
        this.emptyOutput = this.emptyOutput != null ? this.outputs.merge(this.emptyOutput, v) : v;
    }

    public void save(DataOutput out) throws IOException {
        if (this.startNode == -1L) {
            throw new IllegalStateException("call finish first");
        }
        CodecUtil.writeHeader(out, FILE_FORMAT_NAME, 6);
        if (this.emptyOutput != null) {
            out.writeByte((byte)1);
            RAMOutputStream ros = new RAMOutputStream();
            this.outputs.writeFinalOutput(this.emptyOutput, ros);
            byte[] emptyOutputBytes = new byte[(int)ros.getFilePointer()];
            ros.writeTo(emptyOutputBytes, 0);
            int stopAt = emptyOutputBytes.length / 2;
            for (int upto = 0; upto < stopAt; ++upto) {
                byte b = emptyOutputBytes[upto];
                emptyOutputBytes[upto] = emptyOutputBytes[emptyOutputBytes.length - upto - 1];
                emptyOutputBytes[emptyOutputBytes.length - upto - 1] = b;
            }
            out.writeVInt(emptyOutputBytes.length);
            out.writeBytes(emptyOutputBytes, 0, emptyOutputBytes.length);
        } else {
            out.writeByte((byte)0);
        }
        int t = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
        out.writeByte((byte)t);
        out.writeVLong(this.startNode);
        if (this.bytes != null) {
            long numBytes = this.bytes.getPosition();
            out.writeVLong(numBytes);
            this.bytes.writeTo(out);
        } else {
            assert (this.fstStore != null);
            this.fstStore.writeTo(out);
        }
    }

    public void save(Path path) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.save(new OutputStreamDataOutput(os));
        }
    }

    public static <T> FST<T> read(Path path, Outputs<T> outputs) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            FST<T> fST = new FST<T>(new InputStreamDataInput(new BufferedInputStream(is)), outputs);
            return fST;
        }
    }

    private void writeLabel(DataOutput out, int v) throws IOException {
        assert (v >= 0) : "v=" + v;
        if (this.inputType == INPUT_TYPE.BYTE1) {
            assert (v <= 255) : "v=" + v;
            out.writeByte((byte)v);
        } else if (this.inputType == INPUT_TYPE.BYTE2) {
            assert (v <= 65535) : "v=" + v;
            out.writeShort((short)v);
        } else {
            out.writeVInt(v);
        }
    }

    public int readLabel(DataInput in) throws IOException {
        int v = this.inputType == INPUT_TYPE.BYTE1 ? in.readByte() & 0xFF : (this.inputType == INPUT_TYPE.BYTE2 ? in.readShort() & 0xFFFF : in.readVInt());
        return v;
    }

    public static <T> boolean targetHasArcs(Arc<T> arc) {
        return arc.target > 0L;
    }

    long addNode(Builder<T> builder, Builder.UnCompiledNode<T> nodeIn) throws IOException {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (nodeIn.numArcs == 0) {
            if (nodeIn.isFinal) {
                return -1L;
            }
            return 0L;
        }
        long startAddress = builder.bytes.getPosition();
        boolean doFixedArray = this.shouldExpand(builder, nodeIn);
        if (doFixedArray && builder.reusedBytesPerArc.length < nodeIn.numArcs) {
            builder.reusedBytesPerArc = new int[ArrayUtil.oversize(nodeIn.numArcs, 1)];
        }
        builder.arcCount += (long)nodeIn.numArcs;
        int lastArc = nodeIn.numArcs - 1;
        long lastArcStart = builder.bytes.getPosition();
        int maxBytesPerArc = 0;
        for (int arcIdx = 0; arcIdx < nodeIn.numArcs; ++arcIdx) {
            boolean targetHasArcs;
            Builder.Arc arc = nodeIn.arcs[arcIdx];
            Builder.CompiledNode target = (Builder.CompiledNode)arc.target;
            int flags = 0;
            if (arcIdx == lastArc) {
                flags += 2;
            }
            if (builder.lastFrozenNode == target.node && !doFixedArray) {
                flags += 4;
            }
            if (arc.isFinal) {
                ++flags;
                if (arc.nextFinalOutput != NO_OUTPUT) {
                    flags += 32;
                }
            } else assert (arc.nextFinalOutput == NO_OUTPUT);
            boolean bl = targetHasArcs = target.node > 0L;
            if (!targetHasArcs) {
                flags += 8;
            }
            if (arc.output != NO_OUTPUT) {
                flags += 16;
            }
            builder.bytes.writeByte((byte)flags);
            this.writeLabel(builder.bytes, arc.label);
            if (arc.output != NO_OUTPUT) {
                this.outputs.write(arc.output, builder.bytes);
            }
            if (arc.nextFinalOutput != NO_OUTPUT) {
                this.outputs.writeFinalOutput(arc.nextFinalOutput, builder.bytes);
            }
            if (targetHasArcs && (flags & 4) == 0) {
                assert (target.node > 0L);
                builder.bytes.writeVLong(target.node);
            }
            if (!doFixedArray) continue;
            builder.reusedBytesPerArc[arcIdx] = (int)(builder.bytes.getPosition() - lastArcStart);
            lastArcStart = builder.bytes.getPosition();
            maxBytesPerArc = Math.max(maxBytesPerArc, builder.reusedBytesPerArc[arcIdx]);
        }
        if (doFixedArray) {
            int MAX_HEADER_SIZE = 11;
            assert (maxBytesPerArc > 0);
            byte[] header = new byte[11];
            ByteArrayDataOutput bad = new ByteArrayDataOutput(header);
            bad.writeByte((byte)32);
            bad.writeVInt(nodeIn.numArcs);
            bad.writeVInt(maxBytesPerArc);
            int headerLen = bad.getPosition();
            long fixedArrayStart = startAddress + (long)headerLen;
            this.writeArrayPacked(builder, nodeIn, fixedArrayStart, maxBytesPerArc);
            builder.bytes.writeBytes(startAddress, header, 0, headerLen);
        }
        long thisNodeAddress = builder.bytes.getPosition() - 1L;
        builder.bytes.reverse(startAddress, thisNodeAddress);
        ++builder.nodeCount;
        return thisNodeAddress;
    }

    private void writeArrayPacked(Builder<T> builder, Builder.UnCompiledNode<T> nodeIn, long fixedArrayStart, int maxBytesPerArc) {
        long srcPos = builder.bytes.getPosition();
        long destPos = fixedArrayStart + (long)(nodeIn.numArcs * maxBytesPerArc);
        assert (destPos >= srcPos);
        if (destPos > srcPos) {
            builder.bytes.skipBytes((int)(destPos - srcPos));
            for (int arcIdx = nodeIn.numArcs - 1; arcIdx >= 0; --arcIdx) {
                if ((srcPos -= (long)builder.reusedBytesPerArc[arcIdx]) == (destPos -= (long)maxBytesPerArc)) continue;
                assert (destPos > srcPos) : "destPos=" + destPos + " srcPos=" + srcPos + " arcIdx=" + arcIdx + " maxBytesPerArc=" + maxBytesPerArc + " reusedBytesPerArc[arcIdx]=" + builder.reusedBytesPerArc[arcIdx] + " nodeIn.numArcs=" + nodeIn.numArcs;
                builder.bytes.copyBytes(srcPos, destPos, builder.reusedBytesPerArc[arcIdx]);
            }
        }
    }

    public Arc<T> getFirstArc(Arc<T> arc) {
        T NO_OUTPUT = this.outputs.getNoOutput();
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
            if (this.emptyOutput != NO_OUTPUT) {
                arc.flags = (byte)(arc.flags | 0x20);
            }
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = NO_OUTPUT;
        }
        arc.output = NO_OUTPUT;
        arc.target = this.startNode;
        return arc;
    }

    public Arc<T> readLastTargetArc(Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (!FST.targetHasArcs(follow)) {
            assert (follow.isFinal());
            arc.label = -1;
            arc.target = -1L;
            arc.output = follow.nextFinalOutput;
            arc.flags = (byte)2;
            return arc;
        }
        in.setPosition(follow.target);
        byte b = in.readByte();
        if (b == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.posArcsStart = in.getPosition();
            arc.arcIdx = arc.numArcs - 2;
        } else {
            arc.flags = b;
            arc.bytesPerArc = 0;
            while (!arc.isLast()) {
                this.readLabel(in);
                if (arc.flag(16)) {
                    this.outputs.skipOutput(in);
                }
                if (arc.flag(32)) {
                    this.outputs.skipFinalOutput(in);
                }
                if (!arc.flag(8) && !arc.flag(4)) {
                    this.readUnpackedNodeTarget(in);
                }
                arc.flags = in.readByte();
            }
            in.skipBytes(-1L);
            arc.nextArc = in.getPosition();
        }
        this.readNextRealArc(arc, in);
        assert (arc.isLast());
        return arc;
    }

    private long readUnpackedNodeTarget(BytesReader in) throws IOException {
        return in.readVLong();
    }

    public Arc<T> readFirstTargetArc(Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        if (follow.isFinal()) {
            arc.label = -1;
            arc.output = follow.nextFinalOutput;
            arc.flags = 1;
            if (follow.target <= 0L) {
                arc.flags = (byte)(arc.flags | 2);
            } else {
                arc.nextArc = follow.target;
            }
            arc.target = -1L;
            return arc;
        }
        return this.readFirstRealTargetArc(follow.target, arc, in);
    }

    public Arc<T> readFirstRealTargetArc(long node, Arc<T> arc, BytesReader in) throws IOException {
        long address = node;
        in.setPosition(address);
        byte flags = in.readByte();
        if (flags == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.arcIdx = flags == 32 ? -1 : Integer.MIN_VALUE;
            arc.nextArc = arc.posArcsStart = in.getPosition();
        } else {
            arc.nextArc = address;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc, in);
    }

    boolean isExpandedTarget(Arc<T> follow, BytesReader in) throws IOException {
        if (!FST.targetHasArcs(follow)) {
            return false;
        }
        in.setPosition(follow.target);
        byte flags = in.readByte();
        return flags == 32;
    }

    public Arc<T> readNextArc(Arc<T> arc, BytesReader in) throws IOException {
        if (arc.label == -1) {
            if (arc.nextArc <= 0L) {
                throw new IllegalArgumentException("cannot readNextArc when arc.isLast()=true");
            }
            return this.readFirstRealTargetArc(arc.nextArc, arc, in);
        }
        return this.readNextRealArc(arc, in);
    }

    public int readNextArcLabel(Arc<T> arc, BytesReader in) throws IOException {
        assert (!arc.isLast());
        if (arc.label == -1) {
            long pos = arc.nextArc;
            in.setPosition(pos);
            byte flags = in.readByte();
            if (flags == 32) {
                in.readVInt();
                in.readVInt();
            } else {
                in.setPosition(pos);
            }
            in.readByte();
        } else if (arc.bytesPerArc != 0) {
            if (arc.arcIdx >= 0) {
                in.setPosition(arc.posArcsStart);
                in.skipBytes((1 + arc.arcIdx) * arc.bytesPerArc + 1);
            } else {
                in.setPosition(arc.nextArc);
                byte flags = in.readByte();
                while (FST.flag(flags, 64)) {
                    in.skipBytes(arc.bytesPerArc - 1);
                    flags = in.readByte();
                }
            }
        } else {
            in.setPosition(arc.nextArc - 1L);
        }
        return this.readLabel(in);
    }

    public Arc<T> readNextRealArc(Arc<T> arc, BytesReader in) throws IOException {
        if (arc.bytesPerArc != 0) {
            if (arc.arcIdx > Integer.MIN_VALUE) {
                ++arc.arcIdx;
                assert (arc.arcIdx < arc.numArcs);
                in.setPosition(arc.posArcsStart - (long)(arc.arcIdx * arc.bytesPerArc));
                arc.flags = in.readByte();
            } else {
                assert (arc.nextArc <= arc.posArcsStart && arc.nextArc > arc.posArcsStart - (long)(arc.numArcs * arc.bytesPerArc));
                in.setPosition(arc.nextArc);
                arc.flags = in.readByte();
                while (FST.flag(arc.flags, 64)) {
                    arc.nextArc -= (long)arc.bytesPerArc;
                    in.skipBytes(arc.bytesPerArc - 1);
                    arc.flags = in.readByte();
                }
            }
        } else {
            in.setPosition(arc.nextArc);
            arc.flags = in.readByte();
        }
        arc.label = this.readLabel(in);
        arc.output = arc.flag(16) ? this.outputs.read(in) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.readFinalOutput(in) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1L : 0L;
            arc.nextArc = arc.bytesPerArc == 0 ? in.getPosition() : (arc.nextArc -= (long)arc.bytesPerArc);
        } else if (arc.flag(4)) {
            arc.nextArc = in.getPosition();
            if (!arc.flag(2)) {
                if (arc.bytesPerArc == 0) {
                    this.seekToNextNode(in);
                } else {
                    in.setPosition(arc.posArcsStart);
                    in.skipBytes(arc.bytesPerArc * arc.numArcs);
                }
            }
            arc.target = in.getPosition();
        } else {
            arc.target = this.readUnpackedNodeTarget(in);
            arc.nextArc = arc.bytesPerArc > 0 && arc.arcIdx == Integer.MIN_VALUE ? (arc.nextArc -= (long)arc.bytesPerArc) : in.getPosition();
        }
        return arc;
    }

    private boolean assertRootCachedArc(int label, Arc<T> cachedArc) throws IOException {
        Arc arc = new Arc();
        this.getFirstArc(arc);
        BytesReader in = this.getBytesReader();
        Arc result = this.findTargetArc(label, arc, arc, in, false);
        if (result == null) {
            assert (cachedArc == null);
        } else {
            assert (cachedArc != null);
            assert (cachedArc.arcIdx == result.arcIdx);
            assert (cachedArc.bytesPerArc == result.bytesPerArc);
            assert (cachedArc.flags == result.flags);
            assert (cachedArc.label == result.label);
            if (cachedArc.bytesPerArc == 0 || cachedArc.arcIdx == Integer.MIN_VALUE) assert (cachedArc.nextArc == result.nextArc);
            assert (cachedArc.nextFinalOutput.equals(result.nextFinalOutput));
            assert (cachedArc.numArcs == result.numArcs);
            assert (cachedArc.output.equals(result.output));
            assert (cachedArc.posArcsStart == result.posArcsStart);
            assert (cachedArc.target == result.target);
        }
        return true;
    }

    public Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in) throws IOException {
        return this.findTargetArc(labelToMatch, follow, arc, in, true);
    }

    private Arc<T> findTargetArc(int labelToMatch, Arc<T> follow, Arc<T> arc, BytesReader in, boolean useRootArcCache) throws IOException {
        if (labelToMatch == -1) {
            if (follow.isFinal()) {
                if (follow.target <= 0L) {
                    arc.flags = (byte)2;
                } else {
                    arc.flags = 0;
                    arc.nextArc = follow.target;
                }
                arc.output = follow.nextFinalOutput;
                arc.label = -1;
                return arc;
            }
            return null;
        }
        if (useRootArcCache && this.cachedRootArcs != null && follow.target == this.startNode && labelToMatch < this.cachedRootArcs.length) {
            Arc<T> result = this.cachedRootArcs[labelToMatch];
            assert (this.assertRootCachedArc(labelToMatch, result));
            if (result == null) {
                return null;
            }
            arc.copyFrom(result);
            return arc;
        }
        if (!FST.targetHasArcs(follow)) {
            return null;
        }
        in.setPosition(follow.target);
        byte flags = in.readByte();
        if (flags == 32) {
            arc.numArcs = in.readVInt();
            arc.bytesPerArc = in.readVInt();
            arc.posArcsStart = in.getPosition();
            int low = 0;
            int high = arc.numArcs - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                in.setPosition(arc.posArcsStart - (long)(arc.bytesPerArc * mid + 1));
                int midLabel = this.readLabel(in);
                int cmp = midLabel - labelToMatch;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                arc.arcIdx = mid - 1;
                return this.readNextRealArc(arc, in);
            }
            return null;
        }
        this.readFirstRealTargetArc(follow.target, arc, in);
        while (arc.label != labelToMatch) {
            if (arc.label > labelToMatch) {
                return null;
            }
            if (arc.isLast()) {
                return null;
            }
            this.readNextRealArc(arc, in);
        }
        return arc;
    }

    private void seekToNextNode(BytesReader in) throws IOException {
        byte flags;
        do {
            flags = in.readByte();
            this.readLabel(in);
            if (FST.flag(flags, 16)) {
                this.outputs.skipOutput(in);
            }
            if (FST.flag(flags, 32)) {
                this.outputs.skipFinalOutput(in);
            }
            if (FST.flag(flags, 8) || FST.flag(flags, 4)) continue;
            this.readUnpackedNodeTarget(in);
        } while (!FST.flag(flags, 2));
    }

    private boolean shouldExpand(Builder<T> builder, Builder.UnCompiledNode<T> node) {
        return builder.allowArrayArcs && (node.depth <= 3 && node.numArcs >= 5 || node.numArcs >= 10);
    }

    public BytesReader getBytesReader() {
        if (this.fstStore != null) {
            return this.fstStore.getReverseBytesReader();
        }
        return this.bytes.getReverseReader();
    }

    public static abstract class BytesReader
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);

        public abstract boolean reversed();
    }

    public static final class Arc<T> {
        public int label;
        public T output;
        public long target;
        byte flags;
        public T nextFinalOutput;
        long nextArc;
        public long posArcsStart;
        public int bytesPerArc;
        public int arcIdx;
        public int numArcs;

        public Arc<T> copyFrom(Arc<T> other) {
            this.label = other.label;
            this.target = other.target;
            this.flags = other.flags;
            this.output = other.output;
            this.nextFinalOutput = other.nextFinalOutput;
            this.nextArc = other.nextArc;
            this.bytesPerArc = other.bytesPerArc;
            if (this.bytesPerArc != 0) {
                this.posArcsStart = other.posArcsStart;
                this.arcIdx = other.arcIdx;
                this.numArcs = other.numArcs;
            }
            return this;
        }

        boolean flag(int flag) {
            return FST.flag(this.flags, flag);
        }

        public boolean isLast() {
            return this.flag(2);
        }

        public boolean isFinal() {
            return this.flag(1);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(" target=").append(this.target);
            b.append(" label=0x").append(Integer.toHexString(this.label));
            if (this.flag(1)) {
                b.append(" final");
            }
            if (this.flag(2)) {
                b.append(" last");
            }
            if (this.flag(4)) {
                b.append(" targetNext");
            }
            if (this.flag(8)) {
                b.append(" stop");
            }
            if (this.flag(16)) {
                b.append(" output=").append(this.output);
            }
            if (this.flag(32)) {
                b.append(" nextFinalOutput=").append(this.nextFinalOutput);
            }
            if (this.bytesPerArc != 0) {
                b.append(" arcArray(idx=").append(this.arcIdx).append(" of ").append(this.numArcs).append(")");
            }
            return b.toString();
        }
    }

    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }
}

