/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.uniformsplit;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockReader;
import org.apache.lucene.codecs.uniformsplit.DictionaryBrowserSupplier;
import org.apache.lucene.codecs.uniformsplit.FieldMetadata;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.TermBytes;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public class IntersectBlockReader
extends BlockReader {
    protected final AutomatonNextTermCalculator nextStringCalculator;
    protected final ByteRunAutomaton runAutomaton;
    protected final BytesRef commonSuffixRef;
    protected final BytesRef commonPrefixRef;
    protected final BytesRef startTerm;
    protected BytesRef seekTerm;
    protected int blockPrefixRunAutomatonState;
    protected int blockPrefixLen;
    protected int numBytesAccepted;
    protected boolean beyondCommonPrefix;

    public IntersectBlockReader(CompiledAutomaton compiled, BytesRef startTerm, DictionaryBrowserSupplier dictionaryBrowserSupplier, IndexInput blockInput, PostingsReaderBase postingsReader, FieldMetadata fieldMetadata, BlockDecoder blockDecoder) throws IOException {
        super(dictionaryBrowserSupplier, blockInput, postingsReader, fieldMetadata, blockDecoder);
        this.nextStringCalculator = new AutomatonNextTermCalculator(compiled);
        Automaton automaton = Objects.requireNonNull(compiled.automaton);
        this.runAutomaton = Objects.requireNonNull(compiled.runAutomaton);
        this.commonSuffixRef = compiled.commonSuffixRef;
        this.commonPrefixRef = Operations.getCommonPrefixBytesRef((Automaton)automaton);
        this.startTerm = startTerm;
        assert (startTerm == null || StringHelper.startsWith((BytesRef)startTerm, (BytesRef)this.commonPrefixRef));
        this.seekTerm = startTerm != null ? startTerm : this.commonPrefixRef;
    }

    @Override
    public BytesRef next() throws IOException {
        this.clearTermState();
        if (this.blockHeader == null) {
            long blockStartFP = this.getOrCreateDictionaryBrowser().seekBlock(this.seekTerm);
            if (this.isBeyondLastTerm(this.seekTerm, blockStartFP)) {
                return null;
            }
            if (!this.nextBlockMatchingPrefix()) {
                return null;
            }
        }
        do {
            BytesRef term;
            if ((term = this.nextTermInBlockMatching()) == null) continue;
            return term;
        } while (this.nextBlockMatchingPrefix());
        return null;
    }

    protected boolean nextBlockMatchingPrefix() throws IOException {
        if (this.beyondCommonPrefix) {
            return false;
        }
        IndexDictionary.Browser browser = this.getOrCreateDictionaryBrowser();
        while (true) {
            BytesRef blockKey;
            if ((blockKey = browser.nextKey()) == null) {
                return false;
            }
            this.blockPrefixLen = browser.getBlockPrefixLen();
            this.blockPrefixRunAutomatonState = this.runAutomatonForState(blockKey.bytes, blockKey.offset, this.blockPrefixLen, 0);
            if (this.isBeyondCommonPrefix(blockKey)) {
                return false;
            }
            if (this.blockPrefixRunAutomatonState >= 0) break;
            this.seekTerm = null;
            if (this.nextStringCalculator.isLinearState(blockKey)) continue;
            BytesRef peekKey = browser.peekKey();
            if (peekKey == null) {
                return false;
            }
            if (this.runAutomatonForState(peekKey.bytes, peekKey.offset, peekKey.length, 0) >= 0) continue;
            this.seekTerm = this.nextStringCalculator.nextSeekTerm(browser.peekKey());
            if (this.seekTerm == null) {
                return false;
            }
            browser.seekBlock(this.seekTerm);
        }
        this.initializeHeader(null, browser.getBlockFilePointer());
        return true;
    }

    protected BytesRef nextTermInBlockMatching() throws IOException {
        while (true) {
            if (this.seekTerm != null) {
                assert (this.blockLine == null);
                boolean moveBeyondIfFound = this.seekTerm == this.startTerm;
                TermsEnum.SeekStatus seekStatus = this.seekInBlock(this.seekTerm);
                this.seekTerm = null;
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    return null;
                }
                if (seekStatus == TermsEnum.SeekStatus.FOUND && moveBeyondIfFound && this.readLineInBlock() == null) {
                    return null;
                }
                assert (this.blockLine != null);
            } else if (this.readLineInBlock() == null) {
                return null;
            }
            TermBytes lineTermBytes = this.blockLine.getTermBytes();
            BytesRef lineTerm = lineTermBytes.getTerm();
            if (this.commonSuffixRef != null && !StringHelper.endsWith((BytesRef)lineTerm, (BytesRef)this.commonSuffixRef)) continue;
            if (this.runAutomatonFromPrefix(lineTerm)) {
                return lineTerm;
            }
            if (this.beyondCommonPrefix) break;
        }
        return null;
    }

    protected boolean runAutomatonFromPrefix(BytesRef term) {
        int state = this.runAutomatonForState(term.bytes, term.offset + this.blockPrefixLen, term.length - this.blockPrefixLen, this.blockPrefixRunAutomatonState);
        if (state >= 0 && this.runAutomaton.isAccept(state)) {
            return true;
        }
        if (this.isBeyondCommonPrefix(term)) {
            this.beyondCommonPrefix = true;
        }
        return false;
    }

    protected int runAutomatonForState(byte[] s, int offset, int length, int initialState) {
        int index;
        int state = initialState;
        for (index = 0; index < length && (state = this.runAutomaton.step(state, s[index + offset] & 0xFF)) != -1; ++index) {
        }
        this.numBytesAccepted = index;
        return state;
    }

    protected boolean isBeyondCommonPrefix(BytesRef bytesRef) {
        return this.numBytesAccepted < this.commonPrefixRef.length && this.numBytesAccepted < bytesRef.length && (bytesRef.bytes[this.numBytesAccepted + bytesRef.offset] & 0xFF) > (this.commonPrefixRef.bytes[this.numBytesAccepted + this.commonPrefixRef.offset] & 0xFF);
    }

    @Override
    public boolean seekExact(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seekExact(BytesRef term, TermState state) {
        throw new UnsupportedOperationException();
    }

    protected static class AutomatonNextTermCalculator {
        protected final ByteRunAutomaton runAutomaton;
        protected final BytesRef commonSuffixRef;
        protected final boolean finite;
        protected final Automaton automaton;
        protected final long[] visited;
        protected long curGen;
        protected final BytesRefBuilder seekBytesRef = new BytesRefBuilder();
        protected boolean linear = false;
        protected final BytesRef linearUpperBound = new BytesRef(10);
        protected Transition transition = new Transition();
        protected final IntsRefBuilder savedStates = new IntsRefBuilder();

        protected AutomatonNextTermCalculator(CompiledAutomaton compiled) {
            if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
                throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
            }
            this.finite = compiled.finite;
            this.runAutomaton = compiled.runAutomaton;
            assert (this.runAutomaton != null);
            this.commonSuffixRef = compiled.commonSuffixRef;
            this.automaton = compiled.automaton;
            this.visited = new long[this.runAutomaton.getSize()];
        }

        protected boolean isLinearState(BytesRef term) {
            return this.linear && term.compareTo(this.linearUpperBound) < 0;
        }

        protected BytesRef nextSeekTerm(BytesRef term) throws IOException {
            if (term == null) {
                assert (this.seekBytesRef.length() == 0);
                if (this.runAutomaton.isAccept(0)) {
                    return this.seekBytesRef.get();
                }
            } else {
                this.seekBytesRef.copyBytes(term);
            }
            if (this.nextString()) {
                return this.seekBytesRef.get();
            }
            return null;
        }

        protected void setLinear(int position) {
            int length;
            assert (!this.linear);
            int state = 0;
            assert (state == 0);
            int maxInterval = 255;
            for (int i = 0; i < position; ++i) {
                state = this.runAutomaton.step(state, this.seekBytesRef.byteAt(i) & 0xFF);
                assert (state >= 0) : "state=" + state;
            }
            int numTransitions = this.automaton.getNumTransitions(state);
            this.automaton.initTransition(state, this.transition);
            for (int i = 0; i < numTransitions; ++i) {
                this.automaton.getNextTransition(this.transition);
                if (this.transition.min > (this.seekBytesRef.byteAt(position) & 0xFF) || (this.seekBytesRef.byteAt(position) & 0xFF) > this.transition.max) continue;
                maxInterval = this.transition.max;
                break;
            }
            if (maxInterval != 255) {
                ++maxInterval;
            }
            if (this.linearUpperBound.bytes.length < (length = position + 1)) {
                this.linearUpperBound.bytes = new byte[length];
            }
            System.arraycopy(this.seekBytesRef.bytes(), 0, this.linearUpperBound.bytes, 0, position);
            this.linearUpperBound.bytes[position] = (byte)maxInterval;
            this.linearUpperBound.length = length;
            this.linear = true;
        }

        protected boolean nextString() {
            int pos = 0;
            this.savedStates.grow(this.seekBytesRef.length() + 1);
            this.savedStates.setIntAt(0, 0);
            while (true) {
                ++this.curGen;
                this.linear = false;
                int state = this.savedStates.intAt(pos);
                while (pos < this.seekBytesRef.length()) {
                    this.visited[state] = this.curGen;
                    int nextState = this.runAutomaton.step(state, this.seekBytesRef.byteAt(pos) & 0xFF);
                    if (nextState == -1) break;
                    this.savedStates.setIntAt(pos + 1, nextState);
                    if (!this.finite && !this.linear && this.visited[nextState] == this.curGen) {
                        this.setLinear(pos);
                    }
                    state = nextState;
                    ++pos;
                }
                if (this.nextString(state, pos)) {
                    return true;
                }
                if ((pos = this.backtrack(pos)) < 0) {
                    return false;
                }
                int newState = this.runAutomaton.step(this.savedStates.intAt(pos), this.seekBytesRef.byteAt(pos) & 0xFF);
                if (newState >= 0 && this.runAutomaton.isAccept(newState)) {
                    return true;
                }
                if (this.finite) continue;
                pos = 0;
            }
        }

        protected boolean nextString(int state, int position) {
            int c = 0;
            if (position < this.seekBytesRef.length()) {
                c = this.seekBytesRef.byteAt(position) & 0xFF;
                if (c++ == 255) {
                    return false;
                }
            }
            this.seekBytesRef.setLength(position);
            this.visited[state] = this.curGen;
            int numTransitions = this.automaton.getNumTransitions(state);
            this.automaton.initTransition(state, this.transition);
            for (int i = 0; i < numTransitions; ++i) {
                this.automaton.getNextTransition(this.transition);
                if (this.transition.max < c) continue;
                int nextChar = Math.max(c, this.transition.min);
                this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
                this.seekBytesRef.append((byte)nextChar);
                state = this.transition.dest;
                while (this.visited[state] != this.curGen && !this.runAutomaton.isAccept(state)) {
                    this.visited[state] = this.curGen;
                    this.automaton.initTransition(state, this.transition);
                    this.automaton.getNextTransition(this.transition);
                    state = this.transition.dest;
                    this.seekBytesRef.grow(this.seekBytesRef.length() + 1);
                    this.seekBytesRef.append((byte)this.transition.min);
                    if (this.finite || this.linear || this.visited[state] != this.curGen) continue;
                    this.setLinear(this.seekBytesRef.length() - 1);
                }
                return true;
            }
            return false;
        }

        protected int backtrack(int position) {
            while (position-- > 0) {
                int nextChar = this.seekBytesRef.byteAt(position) & 0xFF;
                if (nextChar++ == 255) continue;
                this.seekBytesRef.setByteAt(position, (byte)nextChar);
                this.seekBytesRef.setLength(position + 1);
                return position;
            }
            return -1;
        }
    }
}

