/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.LiveNodesPredicate;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.SSLTestConfig;
import org.junit.AfterClass;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCloudTestCase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int DEFAULT_TIMEOUT = 45;
    protected static volatile MiniSolrCloudCluster cluster;

    protected static SolrZkClient zkClient() {
        ZkStateReader reader = cluster.getSolrClient().getZkStateReader();
        if (reader == null) {
            cluster.getSolrClient().connect();
        }
        return cluster.getSolrClient().getZkStateReader().getZkClient();
    }

    protected static Builder configureCluster(int nodeCount) {
        return new Builder(nodeCount, SolrCloudTestCase.createTempDir());
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        cluster = null;
    }

    @Before
    public void checkClusterConfiguration() {
    }

    protected static DocCollection getCollectionState(String collectionName) {
        return cluster.getSolrClient().getZkStateReader().getClusterState().getCollection(collectionName);
    }

    protected static void waitForState(String message, String collection, CollectionStatePredicate predicate) {
        SolrCloudTestCase.waitForState(message, collection, predicate, 45, TimeUnit.SECONDS);
    }

    protected static void waitForState(String message, String collection, CollectionStatePredicate predicate, int timeout, TimeUnit timeUnit) {
        log.info("waitForState ({}): {}", (Object)collection, (Object)message);
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            cluster.getSolrClient().waitForState(collection, (long)timeout, timeUnit, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (Exception e) {
            SolrCloudTestCase.fail((String)(message + "\n" + e.getMessage() + "\nLive Nodes: " + Arrays.toString(((Set)liveNodesLastSeen.get()).toArray()) + "\nLast available state: " + state.get()));
        }
    }

    public static CollectionStatePredicate clusterShape(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (collectionState.getSlices().size() != expectedShards) {
                return false;
            }
            return SolrCloudTestCase.compareActiveReplicaCountsForShards(expectedReplicas, liveNodes, collectionState);
        };
    }

    public static CollectionStatePredicate activeClusterShape(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            log.info("active slice count: " + collectionState.getActiveSlices().size() + " expected:" + expectedShards);
            if (collectionState.getActiveSlices().size() != expectedShards) {
                return false;
            }
            return SolrCloudTestCase.compareActiveReplicaCountsForShards(expectedReplicas, liveNodes, collectionState);
        };
    }

    public static LiveNodesPredicate containsLiveNode(String node) {
        return (oldNodes, newNodes) -> newNodes.contains(node);
    }

    public static LiveNodesPredicate missingLiveNode(String node) {
        return (oldNodes, newNodes) -> !newNodes.contains(node);
    }

    public static LiveNodesPredicate missingLiveNodes(List<String> nodes) {
        return (oldNodes, newNodes) -> {
            boolean success = true;
            for (String lostNodeName : nodes) {
                if (!newNodes.contains(lostNodeName)) continue;
                success = false;
                break;
            }
            return success;
        };
    }

    private static boolean compareActiveReplicaCountsForShards(int expectedReplicas, Set<String> liveNodes, DocCollection collectionState) {
        int activeReplicas = 0;
        for (Slice slice : collectionState) {
            for (Replica replica : slice) {
                if (!replica.isActive(liveNodes)) continue;
                ++activeReplicas;
            }
        }
        log.info("active replica count: " + activeReplicas + " expected replica count: " + expectedReplicas);
        return activeReplicas == expectedReplicas;
    }

    protected static Slice getRandomShard(DocCollection collection) {
        ArrayList shards = new ArrayList(collection.getActiveSlices());
        if (shards.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random shard for collection as it has no shards!\n" + collection.toString()));
        }
        Collections.shuffle(shards, SolrCloudTestCase.random());
        return (Slice)shards.get(0);
    }

    protected static Replica getRandomReplica(Slice slice) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        return (Replica)replicas.get(0);
    }

    protected static Replica getRandomReplica(Slice slice, Predicate<Replica> matchPredicate) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        for (Replica replica : replicas) {
            if (!matchPredicate.test(replica)) continue;
            return replica;
        }
        SolrCloudTestCase.fail((String)("Couldn't get random replica that matched conditions\n" + slice.toString()));
        return null;
    }

    protected static CoreStatus getCoreStatus(Replica replica) throws IOException, SolrServerException {
        JettySolrRunner jetty = cluster.getReplicaJetty(replica);
        try (HttpSolrClient client = SolrCloudTestCase.getHttpSolrClient(jetty.getBaseUrl().toString(), cluster.getSolrClient().getHttpClient());){
            CoreStatus coreStatus = CoreAdminRequest.getCoreStatus((String)replica.getCoreName(), (SolrClient)client);
            return coreStatus;
        }
    }

    protected NamedList waitForResponse(Predicate<NamedList> predicate, SolrRequest request, int intervalInMillis, int numRetries, String messageOnFail) {
        int i;
        log.info("waitForResponse: {}", (Object)request);
        for (i = 0; i < numRetries; ++i) {
            try {
                NamedList response = cluster.getSolrClient().request(request);
                if (predicate.test(response)) {
                    return response;
                }
                Thread.sleep(intervalInMillis);
                continue;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new RuntimeException("error executing request", e);
            }
        }
        SolrCloudTestCase.fail((String)("Tried " + i + " times , could not succeed. " + messageOnFail));
        return null;
    }

    public static void ensureRunningJettys(int nodeCount, int timeoutSeconds) throws Exception {
        int i;
        List<JettySolrRunner> jettys = cluster.getJettySolrRunners();
        ArrayList<JettySolrRunner> copyOfJettys = new ArrayList<JettySolrRunner>(jettys);
        int numJetties = copyOfJettys.size();
        for (i = nodeCount; i < numJetties; ++i) {
            cluster.stopJettySolrRunner((JettySolrRunner)copyOfJettys.get(i));
        }
        for (i = copyOfJettys.size(); i < nodeCount; ++i) {
            cluster.startJettySolrRunner();
        }
        jettys = cluster.getJettySolrRunners();
        numJetties = jettys.size();
        for (i = 0; i < numJetties; ++i) {
            if (jettys.get(i).isRunning()) continue;
            cluster.startJettySolrRunner(jettys.get(i));
        }
        cluster.waitForAllNodes(timeoutSeconds);
    }

    static /* synthetic */ SSLTestConfig access$000() {
        return sslConfig;
    }

    public static class Builder {
        private final int nodeCount;
        private final Path baseDir;
        private String solrxml = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n  <str name=\"collectionsHandler\">${collectionsHandler:solr.CollectionsHandler}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n    <str name=\"shardsWhitelist\">${solr.tests.shardsWhitelist:}</str>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">${leaderVoteWait:10000}</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n    <str name=\"zkCredentialsProvider\">${zkCredentialsProvider:org.apache.solr.common.cloud.DefaultZkCredentialsProvider}</str> \n    <str name=\"zkACLProvider\">${zkACLProvider:org.apache.solr.common.cloud.DefaultZkACLProvider}</str> \n  </solrcloud>\n  <metrics>\n    <reporter name=\"default\" class=\"org.apache.solr.metrics.reporters.SolrJmxReporter\">\n      <str name=\"rootName\">solr_${hostPort:8983}</str>\n    </reporter>\n  </metrics>\n  \n</solr>\n";
        private JettyConfig.Builder jettyConfigBuilder = JettyConfig.builder().setContext("/solr").withSSLConfig(SolrCloudTestCase.access$000().buildServerSSLConfig());
        private Optional<String> securityJson = Optional.empty();
        private List<Config> configs = new ArrayList<Config>();
        private Map<String, Object> clusterProperties = new HashMap<String, Object>();
        private boolean trackJettyMetrics;

        public Builder(int nodeCount, Path baseDir) {
            this.nodeCount = nodeCount;
            this.baseDir = baseDir;
        }

        public Builder withJettyConfig(Consumer<JettyConfig.Builder> fun) {
            fun.accept(this.jettyConfigBuilder);
            return this;
        }

        public Builder withSolrXml(String solrXml) {
            this.solrxml = solrXml;
            return this;
        }

        public Builder withSolrXml(Path solrXml) {
            try {
                this.solrxml = new String(Files.readAllBytes(solrXml), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSecurityJson(Path securityJson) {
            try {
                this.securityJson = Optional.of(new String(Files.readAllBytes(securityJson), Charset.defaultCharset()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSecurityJson(String securityJson) {
            this.securityJson = Optional.of(securityJson);
            return this;
        }

        public Builder addConfig(String configName, Path configPath) {
            this.configs.add(new Config(configName, configPath));
            return this;
        }

        public Builder withProperty(String propertyName, String propertyValue) {
            this.clusterProperties.put(propertyName, propertyValue);
            return this;
        }

        public Builder withMetrics(boolean trackJettyMetrics) {
            this.trackJettyMetrics = trackJettyMetrics;
            return this;
        }

        public void configure() throws Exception {
            cluster = this.build();
        }

        public MiniSolrCloudCluster build() throws Exception {
            JettyConfig jettyConfig = this.jettyConfigBuilder.build();
            MiniSolrCloudCluster cluster = new MiniSolrCloudCluster(this.nodeCount, this.baseDir, this.solrxml, jettyConfig, null, this.securityJson, this.trackJettyMetrics);
            CloudSolrClient client = cluster.getSolrClient();
            for (Config config : this.configs) {
                ((ZkClientClusterStateProvider)client.getClusterStateProvider()).uploadConfig(config.path, config.name);
            }
            if (this.clusterProperties.size() > 0) {
                ClusterProperties props = new ClusterProperties(cluster.getSolrClient().getZkStateReader().getZkClient());
                for (Map.Entry<String, Object> entry : this.clusterProperties.entrySet()) {
                    props.setClusterProperty(entry.getKey(), entry.getValue());
                }
            }
            return cluster;
        }

        public Builder withDefaultClusterProperty(String key, String value) {
            HashMap<String, String> cluster;
            HashMap<String, HashMap<String, String>> defaults = (HashMap<String, HashMap<String, String>>)this.clusterProperties.get("defaults");
            if (defaults == null) {
                defaults = new HashMap<String, HashMap<String, String>>();
                this.clusterProperties.put("defaults", defaults);
            }
            if ((cluster = (HashMap<String, String>)defaults.get("cluster")) == null) {
                cluster = new HashMap<String, String>();
                defaults.put("cluster", cluster);
            }
            cluster.put(key, value);
            return this;
        }
    }

    private static class Config {
        final String name;
        final Path path;

        private Config(String name, Path path) {
            this.name = name;
            this.path = path;
        }
    }
}

