/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Utils;

class ReplicaCount
implements MapWriter {
    long nrt;
    long tlog;
    long pull;

    public ReplicaCount() {
        this.pull = 0L;
        this.tlog = 0L;
        this.nrt = 0L;
    }

    public ReplicaCount(long nrt, long tlog, long pull) {
        this.nrt = nrt;
        this.tlog = tlog;
        this.pull = pull;
    }

    public long total() {
        return this.nrt + this.tlog + this.pull;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.nrt > 0L) {
            ew.put((CharSequence)Replica.Type.NRT.name(), this.nrt);
        }
        if (this.pull > 0L) {
            ew.put((CharSequence)Replica.Type.PULL.name(), this.pull);
        }
        if (this.tlog > 0L) {
            ew.put((CharSequence)Replica.Type.TLOG.name(), this.tlog);
        }
        ew.put((CharSequence)"count", this.total());
    }

    public Long getVal(Replica.Type type) {
        if (type == null) {
            return this.total();
        }
        switch (type) {
            case NRT: {
                return this.nrt;
            }
            case PULL: {
                return this.pull;
            }
            case TLOG: {
                return this.tlog;
            }
        }
        return this.total();
    }

    public void increment(List<ReplicaInfo> infos) {
        if (infos == null) {
            return;
        }
        for (ReplicaInfo info : infos) {
            this.increment(info);
        }
    }

    void increment(ReplicaInfo info) {
        this.increment(info.getType());
    }

    void increment(ReplicaCount count) {
        this.nrt += count.nrt;
        this.pull += count.pull;
        this.tlog += count.tlog;
    }

    public void increment(Replica.Type type) {
        switch (type) {
            case NRT: {
                ++this.nrt;
                break;
            }
            case PULL: {
                ++this.pull;
                break;
            }
            case TLOG: {
                ++this.tlog;
                break;
            }
            default: {
                ++this.nrt;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReplicaCount) {
            ReplicaCount that = (ReplicaCount)obj;
            return that.nrt == this.nrt && that.tlog == this.tlog && that.pull == this.pull;
        }
        return false;
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public ReplicaCount copy() {
        return new ReplicaCount(this.nrt, this.tlog, this.pull);
    }

    public void reset() {
        this.pull = 0L;
        this.tlog = 0L;
        this.nrt = 0L;
    }

    public int delta(int expectedReplicaCount, Replica.Type type) {
        if (type == Replica.Type.NRT) {
            return (int)(this.nrt - (long)expectedReplicaCount);
        }
        if (type == Replica.Type.PULL) {
            return (int)(this.pull - (long)expectedReplicaCount);
        }
        if (type == Replica.Type.TLOG) {
            return (int)(this.tlog - (long)expectedReplicaCount);
        }
        throw new RuntimeException("NO type");
    }
}

