/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.update.CdcrUpdateLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CdcrReplicatorState {
    private final String targetCollection;
    private final String zkHost;
    private final CloudSolrClient targetClient;
    private CdcrUpdateLog.CdcrLogReader logReader;
    private long consecutiveErrors = 0L;
    private final Map<ErrorType, Long> errorCounters = new HashMap<ErrorType, Long>();
    private final FixedQueue<ErrorQueueEntry> errorsQueue = new FixedQueue(100);
    private BenchmarkTimer benchmarkTimer;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AtomicBoolean bootstrapInProgress = new AtomicBoolean(false);
    private final AtomicInteger numBootstraps = new AtomicInteger();

    CdcrReplicatorState(String targetCollection, String zkHost, CloudSolrClient targetClient) {
        this.targetCollection = targetCollection;
        this.targetClient = targetClient;
        this.zkHost = zkHost;
        this.benchmarkTimer = new BenchmarkTimer();
    }

    void init(CdcrUpdateLog.CdcrLogReader logReader) {
        this.logReader = logReader;
    }

    void closeLogReader() {
        if (this.logReader != null) {
            this.logReader.close();
            this.logReader = null;
        }
    }

    CdcrUpdateLog.CdcrLogReader getLogReader() {
        return this.logReader;
    }

    String getTargetCollection() {
        return this.targetCollection;
    }

    String getZkHost() {
        return this.zkHost;
    }

    CloudSolrClient getClient() {
        return this.targetClient;
    }

    void shutdown() {
        try {
            this.targetClient.close();
        }
        catch (IOException ioe) {
            log.warn("Caught exception trying to close server: ", (Object)ioe.getMessage());
        }
        this.closeLogReader();
    }

    void reportError(ErrorType error) {
        if (!this.errorCounters.containsKey((Object)error)) {
            this.errorCounters.put(error, 0L);
        }
        this.errorCounters.put(error, this.errorCounters.get((Object)error) + 1L);
        this.errorsQueue.add(new ErrorQueueEntry(error, new Date()));
        ++this.consecutiveErrors;
    }

    void resetConsecutiveErrors() {
        this.consecutiveErrors = 0L;
    }

    long getConsecutiveErrors() {
        return this.consecutiveErrors;
    }

    long getErrorCount(ErrorType type) {
        if (this.errorCounters.containsKey((Object)type)) {
            return this.errorCounters.get((Object)type);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String[]> getLastErrors() {
        ArrayList<String[]> lastErrors = new ArrayList<String[]>();
        FixedQueue<ErrorQueueEntry> fixedQueue = this.errorsQueue;
        synchronized (fixedQueue) {
            for (ErrorQueueEntry entry : this.errorsQueue) {
                lastErrors.add(new String[]{entry.timestamp.toInstant().toString(), entry.type.toLower()});
            }
        }
        return lastErrors;
    }

    String getTimestampOfLastProcessedOperation() {
        if (this.logReader != null && this.logReader.getLastVersion() != -1L) {
            return Instant.ofEpochMilli(this.logReader.getLastVersion() >> 20).toString();
        }
        return "";
    }

    BenchmarkTimer getBenchmarkTimer() {
        return this.benchmarkTimer;
    }

    boolean isBootstrapInProgress() {
        return this.bootstrapInProgress.get();
    }

    void setBootstrapInProgress(boolean inProgress) {
        if (this.bootstrapInProgress.compareAndSet(true, false)) {
            this.numBootstraps.incrementAndGet();
        }
        this.bootstrapInProgress.set(inProgress);
    }

    public int getNumBootstraps() {
        return this.numBootstraps.get();
    }

    private static class FixedQueue<E>
    extends LinkedList<E> {
        private int maxSize;

        public FixedQueue(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public synchronized boolean add(E e) {
            super.addFirst(e);
            if (this.size() > this.maxSize) {
                this.removeLast();
            }
            return true;
        }
    }

    private static class ErrorQueueEntry {
        private ErrorType type;
        private Date timestamp;

        private ErrorQueueEntry(ErrorType type, Date timestamp) {
            this.type = type;
            this.timestamp = timestamp;
        }
    }

    static class BenchmarkTimer {
        private long startTime;
        private long runTime = 0L;
        private Map<Integer, Long> opCounters = new HashMap<Integer, Long>();

        BenchmarkTimer() {
        }

        void start() {
            this.startTime = System.nanoTime();
        }

        void stop() {
            this.runTime += System.nanoTime() - this.startTime;
            this.startTime = -1L;
        }

        void incrementCounter(int operationType) {
            switch (operationType) {
                case 1: 
                case 2: 
                case 3: {
                    if (!this.opCounters.containsKey(operationType)) {
                        this.opCounters.put(operationType, 0L);
                    }
                    this.opCounters.put(operationType, this.opCounters.get(operationType) + 1L);
                    return;
                }
            }
        }

        long getRunTime() {
            long totalRunTime = this.runTime;
            if (this.startTime != -1L) {
                totalRunTime += System.nanoTime() - this.startTime;
            }
            return totalRunTime;
        }

        double getOperationsPerSecond() {
            long total = 0L;
            for (long counter : this.opCounters.values()) {
                total += counter;
            }
            double elapsedTimeInSeconds = (double)this.getRunTime() / 1.0E9;
            return (double)total / elapsedTimeInSeconds;
        }

        double getAddsPerSecond() {
            long total = this.opCounters.get(1) != null ? this.opCounters.get(1) : 0L;
            double elapsedTimeInSeconds = (double)this.getRunTime() / 1.0E9;
            return (double)total / elapsedTimeInSeconds;
        }

        double getDeletesPerSecond() {
            long total = this.opCounters.get(2) != null ? this.opCounters.get(2) : 0L;
            long l = this.opCounters.get(3) != null ? this.opCounters.get(3) : 0L;
            double elapsedTimeInSeconds = (double)this.getRunTime() / 1.0E9;
            return (double)(total += l) / elapsedTimeInSeconds;
        }
    }

    static enum ErrorType {
        INTERNAL,
        BAD_REQUEST;


        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

