/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.DocumentReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.EventReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Provider;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DocumentProvider
implements Provider {
    private final DocumentBuilderFactory factory;

    public DocumentProvider() {
        this(DocumentProvider.safeDocumentBuilderFactory());
    }

    public DocumentProvider(DocumentBuilderFactory documentBuilderFactory) {
        this.factory = documentBuilderFactory;
    }

    @Override
    public EventReader provide(InputStream inputStream) {
        return this.provide(new InputSource(inputStream));
    }

    @Override
    public EventReader provide(Reader reader) {
        return this.provide(new InputSource(reader));
    }

    private EventReader provide(InputSource inputSource) {
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        return new DocumentReader(document);
    }

    private static void setFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        try {
            documentBuilderFactory.setFeature(string, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("The required security feature is not supported by your XML parser: " + string, parserConfigurationException);
        }
    }

    public static DocumentBuilderFactory safeDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentProvider.setFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentProvider.setFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
        DocumentProvider.setFeature(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        DocumentProvider.setFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }
}

