/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlSubstringFunction
extends SqlFunction {
    private static final SqlSingleOperandTypeChecker CHECKER3 = OperandTypes.STRING_INTEGER_INTEGER.or(OperandTypes.STRING_STRING_STRING);

    SqlSubstringFunction() {
        super("SUBSTRING", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 2: {
                return "{0}({1} FROM {2})";
            }
            case 3: {
                return "{0}({1} FROM {2} FOR {3})";
            }
        }
        throw new AssertionError((Object)("Incorrect " + this.getName() + " signature, operands count = " + operandsCount));
    }

    @Override
    public String getAllowedSignatures(String opName) {
        StringBuilder ret = new StringBuilder();
        for (Ord typeName : Ord.zip(SqlTypeName.STRING_TYPES)) {
            if (typeName.i > 0) {
                ret.append(NL);
            }
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of((Object)typeName.e, (Object)((Object)SqlTypeName.INTEGER))));
            ret.append(NL);
            ret.append(SqlUtil.getAliasedSignature(this, opName, ImmutableList.of((Object)typeName.e, (Object)((Object)SqlTypeName.INTEGER), (Object)((Object)SqlTypeName.INTEGER))));
        }
        return ret.toString();
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        switch (callBinding.operands().size()) {
            default: {
                throw new AssertionError();
            }
            case 2: {
                return OperandTypes.STRING_NUMERIC.checkOperandTypes(callBinding, throwOnFailure);
            }
            case 3: 
        }
        if (!CHECKER3.checkOperandTypes(callBinding, throwOnFailure)) {
            return false;
        }
        List<SqlNode> operands = callBinding.getCall().getOperandList();
        RelDataType t1 = callBinding.getOperandType(1);
        RelDataType t2 = callBinding.getOperandType(2);
        if (SqlTypeUtil.inCharFamily(t1) && !SqlTypeUtil.isCharTypeComparable(callBinding, operands, throwOnFailure)) {
            return false;
        }
        if (!SqlTypeUtil.inSameFamilyOrNull(t1, t2)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        SqlMonotonicity mono0;
        if (call.getOperandCount() == 3 && (mono0 = call.getOperandMonotonicity(0)) != null && mono0 != SqlMonotonicity.NOT_MONOTONIC && call.getOperandMonotonicity(1) == SqlMonotonicity.CONSTANT && Objects.equals(call.getOperandLiteralValue(1, BigDecimal.class), BigDecimal.ZERO) && call.getOperandMonotonicity(2) == SqlMonotonicity.CONSTANT) {
            return mono0.unstrict();
        }
        return super.getMonotonicity(call);
    }
}

