/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface RelDataTypeSystem {
    public static final RelDataTypeSystem DEFAULT;

    public int getMaxScale(SqlTypeName var1);

    public int getDefaultPrecision(SqlTypeName var1);

    public int getMaxPrecision(SqlTypeName var1);

    public int getMaxNumericScale();

    public int getMaxNumericPrecision();

    public @Nullable String getLiteral(SqlTypeName var1, boolean var2);

    public boolean isCaseSensitive(SqlTypeName var1);

    public boolean isAutoincrement(SqlTypeName var1);

    public int getNumTypeRadix(SqlTypeName var1);

    public RelDataType deriveSumType(RelDataTypeFactory var1, RelDataType var2);

    public RelDataType deriveAvgAggType(RelDataTypeFactory var1, RelDataType var2);

    public RelDataType deriveCovarType(RelDataTypeFactory var1, RelDataType var2, RelDataType var3);

    public RelDataType deriveFractionalRankType(RelDataTypeFactory var1);

    public RelDataType deriveRankType(RelDataTypeFactory var1);

    public boolean isSchemaCaseSensitive();

    public boolean shouldConvertRaggedUnionTypesToVarying();

    default public boolean shouldUseDoubleMultiplication(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (!2.$assertionsDisabled && this.deriveDecimalMultiplyType(typeFactory, type1, type2) == null) {
            throw new AssertionError();
        }
        return false;
    }

    default public @Nullable RelDataType deriveDecimalPlusType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType(type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType(type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int scale = Math.max(s1, s2);
            if (!2.$assertionsDisabled && scale > this.getMaxNumericScale()) {
                throw new AssertionError();
            }
            int precision = Math.max(p1 - s1, p2 - s2) + scale + 1;
            precision = Math.min(precision, this.getMaxNumericPrecision());
            if (!2.$assertionsDisabled && precision <= 0) {
                throw new AssertionError();
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
        }
        return null;
    }

    default public @Nullable RelDataType deriveDecimalMultiplyType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType(type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType(type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int scale = s1 + s2;
            scale = Math.min(scale, this.getMaxNumericScale());
            int precision = p1 + p2;
            precision = Math.min(precision, this.getMaxNumericPrecision());
            RelDataType ret = typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    default public @Nullable RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType(type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType(type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int maxNumericPrecision = this.getMaxNumericPrecision();
            int dout = Math.min(p1 - s1 + s2, maxNumericPrecision);
            int scale = Math.max(6, s1 + p2 + 1);
            scale = Math.min(scale, maxNumericPrecision - dout);
            scale = Math.min(scale, this.getMaxNumericScale());
            int precision = dout + scale;
            if (!2.$assertionsDisabled && precision > maxNumericPrecision) {
                throw new AssertionError();
            }
            if (!2.$assertionsDisabled && precision <= 0) {
                throw new AssertionError();
            }
            RelDataType ret = typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }

    default public @Nullable RelDataType deriveDecimalModType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType(type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType(type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            if (s1 == 0 && s2 == 0) {
                return type2;
            }
            int scale = Math.max(s1, s2);
            if (!2.$assertionsDisabled && scale > this.getMaxNumericScale()) {
                throw new AssertionError();
            }
            int precision = Math.min(p1 - s1, p2 - s2) + Math.max(s1, s2);
            precision = Math.min(precision, this.getMaxNumericPrecision());
            if (!2.$assertionsDisabled && precision <= 0) {
                throw new AssertionError();
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
        }
        return null;
    }

    default public TimeFrameSet deriveTimeFrameSet(TimeFrameSet frameSet) {
        return frameSet;
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        DEFAULT = new RelDataTypeSystemImpl(){};
    }
}

