/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.tika.decompress;

import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.mime.MediaType;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;
import org.kitesdk.morphline.tika.decompress.EmbeddedExtractor;

public final class DecompressBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("decompress");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Decompress(this, config, parent, child, context);
    }

    private static final class Decompress
    extends AbstractParser {
        private boolean decompressConcatenated = false;
        private static final MediaType BZIP = MediaType.application((String)"x-bzip");
        private static final MediaType BZIP2 = MediaType.application((String)"x-bzip2");
        private static final MediaType GZIP = MediaType.application((String)"x-gzip");
        private static final MediaType XZ = MediaType.application((String)"x-xz");
        private static final MediaType PACK = MediaType.application((String)"application/x-java-pack200");
        private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set((MediaType[])new MediaType[]{BZIP, BZIP2, GZIP, XZ, PACK});

        public Decompress(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            if (!config.hasPath("supportedMimeTypes")) {
                for (MediaType mediaType : SUPPORTED_TYPES) {
                    this.addSupportedMimeType(mediaType.toString());
                }
            }
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record record, InputStream stream) {
            CompressorInputStream cis;
            EmbeddedExtractor extractor = new EmbeddedExtractor();
            String name = (String)record.getFirstValue("_attachment_name");
            if (name != null) {
                if (name.endsWith(".tbz")) {
                    name = name.substring(0, name.length() - 4) + ".tar";
                } else if (name.endsWith(".tbz2")) {
                    name = name.substring(0, name.length() - 5) + ".tar";
                } else if (name.endsWith(".bz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".bz2")) {
                    name = name.substring(0, name.length() - 4);
                } else if (name.endsWith(".xz")) {
                    name = name.substring(0, name.length() - 3);
                } else if (name.endsWith(".pack")) {
                    name = name.substring(0, name.length() - 5);
                } else if (name.length() > 0) {
                    name = GzipUtils.getUncompressedFilename((String)name);
                }
            }
            stream = new CloseShieldInputStream(stream);
            stream = new BufferedInputStream(stream);
            try {
                CompressorStreamFactory factory = new CompressorStreamFactory();
                cis = factory.createCompressorInputStream(stream);
            }
            catch (CompressorException e) {
                throw new MorphlineRuntimeException("Unable to uncompress document stream", (Throwable)e);
            }
            try {
                boolean bl = extractor.parseEmbedded((InputStream)cis, record, name, this.getChild());
                return bl;
            }
            finally {
                Closeables.closeQuietly((Closeable)cis);
            }
        }
    }
}

