/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.MultiLevelSkipListWriter;
import org.apache.lucene.store.IndexOutput;

@Deprecated
public class Lucene40SkipListWriter
extends MultiLevelSkipListWriter {
    private int[] lastSkipDoc;
    private int[] lastSkipPayloadLength;
    private int[] lastSkipOffsetLength;
    private long[] lastSkipFreqPointer;
    private long[] lastSkipProxPointer;
    private IndexOutput freqOutput;
    private IndexOutput proxOutput;
    private int curDoc;
    private boolean curStorePayloads;
    private boolean curStoreOffsets;
    private int curPayloadLength;
    private int curOffsetLength;
    private long curFreqPointer;
    private long curProxPointer;

    public Lucene40SkipListWriter(int skipInterval, int numberOfSkipLevels, int docCount, IndexOutput freqOutput, IndexOutput proxOutput) {
        super(skipInterval, numberOfSkipLevels, docCount);
        this.freqOutput = freqOutput;
        this.proxOutput = proxOutput;
        this.lastSkipDoc = new int[numberOfSkipLevels];
        this.lastSkipPayloadLength = new int[numberOfSkipLevels];
        this.lastSkipOffsetLength = new int[numberOfSkipLevels];
        this.lastSkipFreqPointer = new long[numberOfSkipLevels];
        this.lastSkipProxPointer = new long[numberOfSkipLevels];
    }

    public void setSkipData(int doc, boolean storePayloads, int payloadLength, boolean storeOffsets, int offsetLength) {
        assert (storePayloads || payloadLength == -1);
        assert (storeOffsets || offsetLength == -1);
        this.curDoc = doc;
        this.curStorePayloads = storePayloads;
        this.curPayloadLength = payloadLength;
        this.curStoreOffsets = storeOffsets;
        this.curOffsetLength = offsetLength;
        this.curFreqPointer = this.freqOutput.getFilePointer();
        if (this.proxOutput != null) {
            this.curProxPointer = this.proxOutput.getFilePointer();
        }
    }

    public void resetSkip() {
        super.resetSkip();
        Arrays.fill(this.lastSkipDoc, 0);
        Arrays.fill(this.lastSkipPayloadLength, -1);
        Arrays.fill(this.lastSkipOffsetLength, -1);
        Arrays.fill(this.lastSkipFreqPointer, this.freqOutput.getFilePointer());
        if (this.proxOutput != null) {
            Arrays.fill(this.lastSkipProxPointer, this.proxOutput.getFilePointer());
        }
    }

    protected void writeSkipData(int level, IndexOutput skipBuffer) throws IOException {
        int delta = this.curDoc - this.lastSkipDoc[level];
        if (this.curStorePayloads || this.curStoreOffsets) {
            assert (this.curStorePayloads || this.curPayloadLength == this.lastSkipPayloadLength[level]);
            assert (this.curStoreOffsets || this.curOffsetLength == this.lastSkipOffsetLength[level]);
            if (this.curPayloadLength == this.lastSkipPayloadLength[level] && this.curOffsetLength == this.lastSkipOffsetLength[level]) {
                skipBuffer.writeVInt(delta << 1);
            } else {
                skipBuffer.writeVInt(delta << 1 | 1);
                if (this.curStorePayloads) {
                    skipBuffer.writeVInt(this.curPayloadLength);
                    this.lastSkipPayloadLength[level] = this.curPayloadLength;
                }
                if (this.curStoreOffsets) {
                    skipBuffer.writeVInt(this.curOffsetLength);
                    this.lastSkipOffsetLength[level] = this.curOffsetLength;
                }
            }
        } else {
            skipBuffer.writeVInt(delta);
        }
        skipBuffer.writeVLong(this.curFreqPointer - this.lastSkipFreqPointer[level]);
        skipBuffer.writeVLong(this.curProxPointer - this.lastSkipProxPointer[level]);
        this.lastSkipDoc[level] = this.curDoc;
        this.lastSkipFreqPointer[level] = this.curFreqPointer;
        this.lastSkipProxPointer[level] = this.curProxPointer;
    }
}

