/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing;

import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.carrotsearch.hppc.IntStack;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.util.Arrays;

public final class SparseArray {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static int[] toSparseEncoding(IntStack documents) {
        if (documents.size() == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (documents.size() < 1000) {
            return SparseArray.toSparseEncodingBySort(documents);
        }
        return SparseArray.toSparseEncodingByHash(documents);
    }

    public static int[] toSparseEncodingByHash(IntStack documents) {
        IntIntOpenHashMap map = new IntIntOpenHashMap();
        int toIndex = documents.size();
        int[] buffer = documents.buffer;
        for (int i = 0; i < toIndex; ++i) {
            map.putOrAdd(buffer[i], 1, 1);
        }
        return SparseArray.hashToKeyValuePairs(map);
    }

    private static int[] hashToKeyValuePairs(IntIntOpenHashMap map) {
        int[] result = new int[map.size() * 2];
        int k = 0;
        for (IntIntCursor c : map) {
            result[k++] = c.key;
            result[k++] = c.value;
        }
        return result;
    }

    public static int[] toSparseEncodingBySort(IntStack documents) {
        Arrays.sort(documents.buffer, 0, documents.size());
        int[] result = new int[2 * SparseArray.countUnique(documents.buffer, 0, documents.size())];
        boolean fromIndex = false;
        int toIndex = documents.size();
        int[] buffer = documents.buffer;
        int doc = buffer[0];
        int count = 1;
        int k = 0;
        for (int i = 1; i < toIndex; ++i) {
            int newDoc = buffer[i];
            if (newDoc != doc) {
                result[k++] = doc;
                result[k++] = count;
                count = 0;
                doc = newDoc;
            }
            ++count;
        }
        if (k < result.length) {
            result[k++] = doc;
            result[k++] = count;
        }
        assert (k == result.length);
        return result;
    }

    public static int countUnique(int[] buffer, int fromIndex, int toIndex) {
        int unique = 0;
        if (fromIndex < toIndex) {
            int val = buffer[fromIndex];
            ++unique;
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                int j = buffer[i];
                assert (j >= val) : "Not sorted as expected.";
                if (val == j) continue;
                ++unique;
                val = j;
            }
        }
        return unique;
    }

    public static int[] mergeSparseArrays(Iterable<int[]> source) {
        IntIntOpenHashMap m = new IntIntOpenHashMap();
        for (int[] list : source) {
            int max = list.length;
            for (int i = 0; i < max; i += 2) {
                int v = list[i + 1];
                m.putOrAdd(list[i], v, v);
            }
        }
        return SparseArray.hashToKeyValuePairs(m);
    }

    public static String sparseToString(int[] intIntArray) {
        StringBuilder b = new StringBuilder();
        int windowSize = 10;
        int max = Math.min(windowSize, intIntArray.length);
        for (int j = 0; j < max; j += 2) {
            b.append(intIntArray[j]).append("=>").append(intIntArray[j + 1]);
            b.append(",");
        }
        if (intIntArray.length > windowSize) {
            b.append("...");
        }
        return b.toString();
    }
}

