/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.helper.ASCIITextWidthCounter;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.helper.TextWidthCounter;
import org.apache.hadoop.util.ToolRunner;

class ToolRunnerHelpFormatter {
    ToolRunnerHelpFormatter() {
    }

    public static String getGenericCommandUsage() {
        String msg;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ToolRunner.printGenericCommandUsage((PrintStream)new PrintStream((OutputStream)bout, true, "UTF-8"));
            msg = new String(bout.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        BufferedReader reader = new BufferedReader(new StringReader(msg));
        StringBuilder result = new StringBuilder();
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (line == null) {
                return result.toString();
            }
            if (!line.startsWith("-")) {
                result.append(line + "\n");
                continue;
            }
            int i = (line = line.trim()).indexOf("  ");
            if (i < 0) {
                i = line.indexOf(9);
            }
            if (i < 0) {
                result.append(line + "\n");
                continue;
            }
            String title = line.substring(0, i).trim();
            if (title.length() >= 3 && Character.isLetterOrDigit(title.charAt(1)) && Character.isLetterOrDigit(title.charAt(2))) {
                title = "-" + title;
            }
            String help = line.substring(i, line.length()).trim();
            StringWriter strWriter = new StringWriter();
            PrintWriter writer = new PrintWriter((Writer)strWriter, true);
            TextHelper.printHelp((PrintWriter)writer, (String)title, (String)help, (TextWidthCounter)new ASCIITextWidthCounter(), (int)ArgumentParsers.getFormatWidth());
            result.append(strWriter.toString());
        }
    }
}

