/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.impl.action.HelpArgumentAction;
import net.sourceforge.argparse4j.impl.choice.RangeArgumentChoice;
import net.sourceforge.argparse4j.impl.type.FileArgumentType;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentChoice;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.FeatureControl;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.PropertyConfigurator;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.hadoop.AlphaNumericComparator;
import org.apache.solr.hadoop.DryRunDocumentLoader;
import org.apache.solr.hadoop.GoLive;
import org.apache.solr.hadoop.LineRandomizerMapper;
import org.apache.solr.hadoop.LineRandomizerReducer;
import org.apache.solr.hadoop.PathArgumentType;
import org.apache.solr.hadoop.SolrCloudPartitioner;
import org.apache.solr.hadoop.SolrInputDocumentWritable;
import org.apache.solr.hadoop.SolrOutputFormat;
import org.apache.solr.hadoop.SolrReducer;
import org.apache.solr.hadoop.ToolRunnerHelpFormatter;
import org.apache.solr.hadoop.TreeMergeMapper;
import org.apache.solr.hadoop.TreeMergeOutputFormat;
import org.apache.solr.hadoop.Utils;
import org.apache.solr.hadoop.ZooKeeperInspector;
import org.apache.solr.hadoop.dedup.RetainMostRecentUpdateConflictResolver;
import org.apache.solr.hadoop.morphline.MorphlineMapRunner;
import org.apache.solr.hadoop.morphline.MorphlineMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexerTool
extends Configured
implements Tool {
    Job job;
    public static final String RESULTS_DIR = "results";
    static final String MAIN_MEMORY_RANDOMIZATION_THRESHOLD = MapReduceIndexerTool.class.getName() + ".mainMemoryRandomizationThreshold";
    private static final String FULL_INPUT_LIST = "full-input-list.txt";
    private static final Logger LOG = LoggerFactory.getLogger(MapReduceIndexerTool.class);

    static List<List<String>> buildShardUrls(List<Object> urls, Integer numShards) {
        if (urls == null) {
            return null;
        }
        ArrayList<List<String>> shardUrls = new ArrayList<List<String>>(urls.size());
        ArrayList<String> list = null;
        if (numShards == null) {
            numShards = urls.size();
        }
        int sz = (int)Math.ceil((float)urls.size() / (float)numShards.intValue());
        for (int i = 0; i < urls.size(); ++i) {
            if (i % sz == 0) {
                list = new ArrayList<String>();
                shardUrls.add(list);
            }
            list.add((String)urls.get(i));
        }
        return shardUrls;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new MapReduceIndexerTool(), (String[])args);
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        Integer exitCode = new MyArgumentParser().parseArgs(args, this.getConf(), opts);
        if (exitCode != null) {
            return exitCode;
        }
        return this.run(opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(Options options) throws Exception {
        if (this.getConf().getBoolean("isMR1", false) && "local".equals(this.getConf().get("mapred.job.tracker"))) {
            throw new IllegalStateException("Running with LocalJobRunner (i.e. all of Hadoop inside a single JVM) is not supported because LocalJobRunner does not (yet) implement the Hadoop Distributed Cache feature, which is required for passing files via --files and --libjars");
        }
        long programStartTime = System.nanoTime();
        if (options.fairSchedulerPool != null) {
            this.getConf().set("mapred.fairscheduler.pool", options.fairSchedulerPool);
        }
        this.getConf().setInt("solr.record.writer.maxSegments", options.maxSegments);
        this.getConf().setBoolean("mapred.used.genericoptionsparser", true);
        if (options.log4jConfigFile != null) {
            Utils.setLogConfigFile(options.log4jConfigFile, this.getConf());
            this.addDistributedCacheFile(options.log4jConfigFile, this.getConf());
        }
        this.job = Job.getInstance((Configuration)this.getConf());
        this.job.setJarByClass(((Object)((Object)this)).getClass());
        if (options.morphlineFile == null) {
            throw new ArgumentParserException("Argument --morphline-file is required", null);
        }
        MapReduceIndexerTool.verifyGoLiveArgs(options, null);
        MapReduceIndexerTool.verifyZKStructure(options, null);
        int mappers = new JobClient(this.job.getConfiguration()).getClusterStatus().getMaxMapTasks();
        LOG.info("Cluster reports {} mapper slots", (Object)mappers);
        mappers = options.mappers == -1 ? 8 * mappers : options.mappers;
        if (mappers <= 0) {
            throw new IllegalStateException("Illegal number of mappers: " + mappers);
        }
        options.mappers = mappers;
        FileSystem fs = options.outputDir.getFileSystem(this.job.getConfiguration());
        if (fs.exists(options.outputDir) && !this.delete(options.outputDir, true, fs)) {
            return -1;
        }
        Path outputResultsDir = new Path(options.outputDir, RESULTS_DIR);
        Path outputReduceDir = new Path(options.outputDir, "reducers");
        Path outputStep1Dir = new Path(options.outputDir, "tmp1");
        Path outputStep2Dir = new Path(options.outputDir, "tmp2");
        Path outputTreeMergeStep = new Path(options.outputDir, "mtree-merge-output");
        Path fullInputList = new Path(outputStep1Dir, FULL_INPUT_LIST);
        LOG.debug("Creating list of input files for mappers: {}", (Object)fullInputList);
        long numFiles = this.addInputFiles(options.inputFiles, options.inputLists, fullInputList, this.job.getConfiguration());
        if (numFiles == 0L) {
            LOG.info("No input files found - nothing to process");
            return 0;
        }
        int numLinesPerSplit = (int)this.ceilDivide(numFiles, mappers);
        if (numLinesPerSplit < 0) {
            numLinesPerSplit = Integer.MAX_VALUE;
        }
        numLinesPerSplit = Math.max(1, numLinesPerSplit);
        int realMappers = Math.min(mappers, (int)this.ceilDivide(numFiles, numLinesPerSplit));
        this.calculateNumReducers(options, realMappers);
        int reducers = options.reducers;
        LOG.info("Using these parameters: numFiles: {}, mappers: {}, realMappers: {}, reducers: {}, shards: {}, fanout: {}, maxSegments: {}", new Object[]{numFiles, mappers, realMappers, reducers, options.shards, options.fanout, options.maxSegments});
        LOG.info("Randomizing list of {} input files to spread indexing load more evenly among mappers", (Object)numFiles);
        long startTime = System.nanoTime();
        if (numFiles < (long)this.job.getConfiguration().getInt(MAIN_MEMORY_RANDOMIZATION_THRESHOLD, 100001)) {
            this.randomizeFewInputFiles(fs, outputStep2Dir, fullInputList);
        } else {
            int numLinesPerRandomizerSplit = Math.max(10000000, numLinesPerSplit);
            Job randomizerJob = this.randomizeManyInputFiles(this.getConf(), fullInputList, outputStep2Dir, numLinesPerRandomizerSplit);
            if (!this.waitForCompletion(randomizerJob, options.isVerbose)) {
                return -1;
            }
        }
        float secs = (float)(System.nanoTime() - startTime) / 3.0f;
        LOG.info("Done. Randomizing list of {} input files took {} secs", (Object)numFiles, (Object)Float.valueOf(secs));
        this.job.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.addInputPath((Job)this.job, (Path)outputStep2Dir);
        NLineInputFormat.setNumLinesPerSplit((Job)this.job, (int)numLinesPerSplit);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outputReduceDir);
        String mapperClass = this.job.getConfiguration().get("mapreduce.job.map.class");
        if (mapperClass == null) {
            Class<MorphlineMapper> clazz = MorphlineMapper.class;
            mapperClass = clazz.getName();
            this.job.setMapperClass(clazz);
        }
        this.job.setJobName(((Object)((Object)this)).getClass().getName() + "/" + Utils.getShortClassName(mapperClass));
        if (this.job.getConfiguration().get("mapreduce.job.reduce.class") == null) {
            this.job.setReducerClass(SolrReducer.class);
        }
        if (options.updateConflictResolver == null) {
            throw new IllegalArgumentException("updateConflictResolver must not be null");
        }
        this.job.getConfiguration().set(SolrReducer.UPDATE_CONFLICT_RESOLVER, options.updateConflictResolver);
        if (options.zkHost != null) {
            assert (options.collection != null);
            if (this.job.getConfiguration().get("mapreduce.job.partitioner.class") == null) {
                this.job.setPartitionerClass(SolrCloudPartitioner.class);
            }
            this.job.getConfiguration().set(SolrCloudPartitioner.ZKHOST, options.zkHost);
            this.job.getConfiguration().set(SolrCloudPartitioner.COLLECTION, options.collection);
        }
        this.job.getConfiguration().setInt(SolrCloudPartitioner.SHARDS, options.shards.intValue());
        this.job.setOutputFormatClass(SolrOutputFormat.class);
        if (options.solrHomeDir != null) {
            SolrOutputFormat.setupSolrHomeCache(options.solrHomeDir, this.job);
        } else {
            assert (options.zkHost != null);
            ZooKeeperInspector zki = new ZooKeeperInspector();
            try (SolrZkClient zkClient = zki.getZkClient(options.zkHost);){
                String configName = zki.readConfigName(zkClient, options.collection);
                File tmpSolrHomeDir = zki.downloadConfigDir(zkClient, configName);
                SolrOutputFormat.setupSolrHomeCache(tmpSolrHomeDir, this.job);
                options.solrHomeDir = tmpSolrHomeDir;
            }
        }
        MorphlineMapRunner runner = this.setupMorphline(options);
        if (options.isDryRun && runner != null) {
            LOG.info("Indexing {} files in dryrun mode", (Object)numFiles);
            startTime = System.nanoTime();
            this.dryRun(runner, fs, fullInputList);
            secs = (float)(System.nanoTime() - startTime) / 3.0f;
            LOG.info("Done. Indexing {} files in dryrun mode took {} secs", (Object)numFiles, (Object)Float.valueOf(secs));
            this.goodbye(null, programStartTime);
            return 0;
        }
        this.job.getConfiguration().set("morphlineFile", options.morphlineFile.getName());
        this.job.setNumReduceTasks(reducers);
        this.job.setOutputKeyClass(Text.class);
        this.job.setOutputValueClass(SolrInputDocumentWritable.class);
        LOG.info("Indexing {} files using {} real mappers into {} reducers", new Object[]{numFiles, realMappers, reducers});
        startTime = System.nanoTime();
        if (!this.waitForCompletion(this.job, options.isVerbose)) {
            return -1;
        }
        secs = (float)(System.nanoTime() - startTime) / 3.0f;
        LOG.info("Done. Indexing {} files using {} real mappers into {} reducers took {} secs", new Object[]{numFiles, realMappers, reducers, Float.valueOf(secs)});
        int mtreeMergeIterations = 0;
        if (reducers > options.shards) {
            mtreeMergeIterations = (int)Math.round(this.log(options.fanout, reducers / options.shards));
        }
        LOG.debug("MTree merge iterations to do: {}", (Object)mtreeMergeIterations);
        int mtreeMergeIteration = 1;
        while (reducers > options.shards) {
            this.job = Job.getInstance((Configuration)this.getConf());
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            this.job.setJobName(((Object)((Object)this)).getClass().getName() + "/" + Utils.getShortClassName(TreeMergeMapper.class));
            this.job.setMapperClass(TreeMergeMapper.class);
            this.job.setOutputFormatClass(TreeMergeOutputFormat.class);
            this.job.setNumReduceTasks(0);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(NullWritable.class);
            this.job.setInputFormatClass(NLineInputFormat.class);
            Path inputStepDir = new Path(options.outputDir, "mtree-merge-input-iteration" + mtreeMergeIteration);
            fullInputList = new Path(inputStepDir, FULL_INPUT_LIST);
            LOG.debug("MTree merge iteration {}/{}: Creating input list file for mappers {}", new Object[]{mtreeMergeIteration, mtreeMergeIterations, fullInputList});
            numFiles = this.createTreeMergeInputDirList(outputReduceDir, fs, fullInputList);
            if (numFiles != (long)reducers) {
                throw new IllegalStateException("Not same reducers: " + reducers + ", numFiles: " + numFiles);
            }
            NLineInputFormat.addInputPath((Job)this.job, (Path)fullInputList);
            NLineInputFormat.setNumLinesPerSplit((Job)this.job, (int)options.fanout);
            FileOutputFormat.setOutputPath((Job)this.job, (Path)outputTreeMergeStep);
            LOG.info("MTree merge iteration {}/{}: Merging {} shards into {} shards using fanout {}", new Object[]{mtreeMergeIteration, mtreeMergeIterations, reducers, reducers / options.fanout, options.fanout});
            startTime = System.nanoTime();
            if (!this.waitForCompletion(this.job, options.isVerbose)) {
                return -1;
            }
            if (!this.renameTreeMergeShardDirs(outputTreeMergeStep, this.job, fs)) {
                return -1;
            }
            secs = (float)(System.nanoTime() - startTime) / 3.0f;
            LOG.info("MTree merge iteration {}/{}: Done. Merging {} shards into {} shards using fanout {} took {} secs", new Object[]{mtreeMergeIteration, mtreeMergeIterations, reducers, reducers / options.fanout, options.fanout, Float.valueOf(secs)});
            if (!this.delete(outputReduceDir, true, fs)) {
                return -1;
            }
            if (!this.rename(outputTreeMergeStep, outputReduceDir, fs)) {
                return -1;
            }
            assert (reducers % options.fanout == 0);
            reducers /= options.fanout;
            ++mtreeMergeIteration;
        }
        assert (reducers == options.shards);
        for (FileStatus stats : fs.listStatus(outputReduceDir)) {
            String dirPrefix = SolrOutputFormat.getOutputName((JobContext)this.job);
            Path srcPath = stats.getPath();
            if (!stats.isDirectory() || !srcPath.getName().startsWith(dirPrefix)) continue;
            String dstName = dirPrefix + srcPath.getName().substring(dirPrefix.length() + "-m".length());
            Path dstPath = new Path(srcPath.getParent(), dstName);
            if (this.rename(srcPath, dstPath, fs)) continue;
            return -1;
        }
        if (!this.rename(outputReduceDir, outputResultsDir, fs)) {
            return -1;
        }
        if (options.goLive && !new GoLive().goLive(options, this.listSortedOutputShardDirs(outputResultsDir, fs))) {
            return -1;
        }
        this.goodbye(this.job, programStartTime);
        return 0;
    }

    private void calculateNumReducers(Options options, int realMappers) throws IOException {
        if (options.shards <= 0) {
            throw new IllegalStateException("Illegal number of shards: " + options.shards);
        }
        if (options.fanout <= 1) {
            throw new IllegalStateException("Illegal fanout: " + options.fanout);
        }
        if (realMappers <= 0) {
            throw new IllegalStateException("Illegal realMappers: " + realMappers);
        }
        int reducers = new JobClient(this.job.getConfiguration()).getClusterStatus().getMaxReduceTasks();
        LOG.info("Cluster reports {} reduce slots", (Object)reducers);
        if (options.reducers == -2) {
            reducers = options.shards;
        } else if (options.reducers == -1) {
            reducers = Math.min(reducers, realMappers);
        } else {
            if (options.reducers == 0) {
                throw new IllegalStateException("Illegal zero reducers");
            }
            reducers = options.reducers;
        }
        reducers = Math.max(reducers, options.shards);
        if (reducers != options.shards) {
            int s;
            options.fanout = Math.min(options.fanout, (int)this.ceilDivide(reducers, options.shards.intValue()));
            for (s = options.shards.intValue(); s < reducers; s *= options.fanout) {
            }
            reducers = s;
            assert (reducers % options.fanout == 0);
        }
        options.reducers = reducers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addInputFiles(List<Path> inputFiles, List<Path> inputLists, Path fullInputList, Configuration conf) throws IOException {
        long numFiles = 0L;
        FileSystem fs = fullInputList.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(fullInputList);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            for (Path inputFile : inputFiles) {
                FileSystem inputFileFs = inputFile.getFileSystem(conf);
                if (!inputFileFs.exists(inputFile)) continue;
                PathFilter pathFilter = new PathFilter(){

                    public boolean accept(Path path) {
                        return !path.getName().startsWith(".") && !path.getName().startsWith("_");
                    }
                };
                numFiles += this.addInputFilesRecursively(inputFile, writer, inputFileFs, pathFilter);
            }
            for (Path inputList : inputLists) {
                try (InputStream in = inputList.toString().equals("-") ? System.in : (inputList.isAbsoluteAndSchemeAuthorityNull() ? new BufferedInputStream(new FileInputStream(inputList.toString())) : inputList.getFileSystem(conf).open(inputList));){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        writer.write(line + "\n");
                        ++numFiles;
                    }
                    reader.close();
                }
            }
            ((Writer)writer).close();
        }
        return numFiles;
    }

    private long addInputFilesRecursively(Path path, Writer writer, FileSystem fs, PathFilter pathFilter) throws IOException {
        long numFiles = 0L;
        for (FileStatus stat : fs.listStatus(path, pathFilter)) {
            LOG.debug("Adding path {}", (Object)stat.getPath());
            if (stat.isDirectory()) {
                numFiles += this.addInputFilesRecursively(stat.getPath(), writer, fs, pathFilter);
                continue;
            }
            writer.write(stat.getPath().toString() + "\n");
            ++numFiles;
        }
        return numFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void randomizeFewInputFiles(FileSystem fs, Path outputStep2Dir, Path fullInputList) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(fullInputList), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        Collections.shuffle(lines, new Random(421439783L));
        FSDataOutputStream out = fs.create(new Path(outputStep2Dir, FULL_INPUT_LIST));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
    }

    private Job randomizeManyInputFiles(Configuration baseConfig, Path fullInputList, Path outputStep2Dir, int numLinesPerSplit) throws IOException {
        Job job2 = Job.getInstance((Configuration)baseConfig);
        job2.setJarByClass(((Object)((Object)this)).getClass());
        job2.setJobName(((Object)((Object)this)).getClass().getName() + "/" + Utils.getShortClassName(LineRandomizerMapper.class));
        job2.setInputFormatClass(NLineInputFormat.class);
        NLineInputFormat.addInputPath((Job)job2, (Path)fullInputList);
        NLineInputFormat.setNumLinesPerSplit((Job)job2, (int)numLinesPerSplit);
        job2.setMapperClass(LineRandomizerMapper.class);
        job2.setReducerClass(LineRandomizerReducer.class);
        job2.setOutputFormatClass(TextOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job2, (Path)outputStep2Dir);
        job2.setNumReduceTasks(1);
        job2.setOutputKeyClass(LongWritable.class);
        job2.setOutputValueClass(Text.class);
        return job2;
    }

    private void addDistributedCacheFile(File file, Configuration conf) throws IOException {
        String HADOOP_TMP_FILES = "tmpfiles";
        String tmpFiles = conf.get(HADOOP_TMP_FILES, "");
        if (tmpFiles.length() > 0) {
            tmpFiles = tmpFiles + ",";
        }
        GenericOptionsParser parser = new GenericOptionsParser(new Configuration(conf), new String[]{"--files", file.getCanonicalPath()});
        String additionalTmpFiles = parser.getConfiguration().get(HADOOP_TMP_FILES);
        assert (additionalTmpFiles != null);
        assert (additionalTmpFiles.length() > 0);
        tmpFiles = tmpFiles + additionalTmpFiles;
        conf.set(HADOOP_TMP_FILES, tmpFiles);
    }

    private MorphlineMapRunner setupMorphline(Options options) throws IOException, URISyntaxException {
        if (options.morphlineId != null) {
            this.job.getConfiguration().set("morphlineId", options.morphlineId);
        }
        this.addDistributedCacheFile(options.morphlineFile, this.job.getConfiguration());
        if (!options.isDryRun) {
            return null;
        }
        LOG.trace("dryRun: java.class.path: {}", (Object)System.getProperty("java.class.path"));
        String fullClassPath = "";
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] classPathPartURLs = ((URLClassLoader)loader).getURLs();
            LOG.trace("dryRun: classPathPartURLs: {}", Arrays.asList(classPathPartURLs));
            StringBuilder classPathParts = new StringBuilder();
            for (URL url : classPathPartURLs) {
                File file = new File(url.toURI());
                if (classPathPartURLs.length > 0) {
                    classPathParts.append(File.pathSeparator);
                }
                classPathParts.append(file.getPath());
            }
            LOG.trace("dryRun: classPathParts: {}", (Object)classPathParts);
            String separator = File.pathSeparator;
            if (fullClassPath.length() == 0 || classPathParts.length() == 0) {
                separator = "";
            }
            fullClassPath = classPathParts + separator + fullClassPath;
        }
        if (fullClassPath.length() > 0) {
            assert (System.getProperty("java.class.path") != null);
            fullClassPath = System.getProperty("java.class.path") + File.pathSeparator + fullClassPath;
            LOG.trace("dryRun: fullClassPath: {}", (Object)fullClassPath);
            System.setProperty("java.class.path", fullClassPath);
        }
        this.job.getConfiguration().set("morphlineFile", options.morphlineFile.getPath());
        return new MorphlineMapRunner(this.job.getConfiguration(), new DryRunDocumentLoader(), options.solrHomeDir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dryRun(MorphlineMapRunner runner, FileSystem fs, Path fullInputList) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(fullInputList), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                runner.map(line, this.job.getConfiguration(), null);
            }
            runner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createTreeMergeInputDirList(Path outputReduceDir, FileSystem fs, Path fullInputList) throws FileNotFoundException, IOException {
        FileStatus[] dirs = this.listSortedOutputShardDirs(outputReduceDir, fs);
        int numFiles = 0;
        try (FSDataOutputStream out = fs.create(fullInputList);){
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            for (FileStatus stat : dirs) {
                LOG.debug("Adding path {}", (Object)stat.getPath());
                Path dir = new Path(stat.getPath(), "data/index");
                if (!fs.isDirectory(dir)) {
                    throw new IllegalStateException("Not a directory: " + dir);
                }
                writer.write(dir.toString() + "\n");
                ++numFiles;
            }
            ((Writer)writer).close();
        }
        return numFiles;
    }

    private FileStatus[] listSortedOutputShardDirs(Path outputReduceDir, FileSystem fs) throws FileNotFoundException, IOException {
        FileStatus[] dirs;
        final String dirPrefix = SolrOutputFormat.getOutputName((JobContext)this.job);
        for (FileStatus dir : dirs = fs.listStatus(outputReduceDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(dirPrefix);
            }
        })) {
            if (dir.isDirectory()) continue;
            throw new IllegalStateException("Not a directory: " + dir.getPath());
        }
        Arrays.sort(dirs, new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus f1, FileStatus f2) {
                return new AlphaNumericComparator().compare(f1.getPath().getName(), f2.getPath().getName());
            }
        });
        return dirs;
    }

    private boolean renameTreeMergeShardDirs(Path outputTreeMergeStep, Job job, FileSystem fs) throws IOException {
        Path renamedPath;
        Path path;
        FileStatus[] dirs;
        final String dirPrefix = SolrOutputFormat.getOutputName((JobContext)job);
        for (FileStatus dir : dirs = fs.listStatus(outputTreeMergeStep, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(dirPrefix);
            }
        })) {
            if (dir.isDirectory()) continue;
            throw new IllegalStateException("Not a directory: " + dir.getPath());
        }
        for (FileStatus dir : dirs) {
            path = dir.getPath();
            if (this.rename(path, renamedPath = new Path(path.getParent(), "_" + path.getName()), fs)) continue;
            return false;
        }
        for (FileStatus dir : dirs) {
            path = dir.getPath();
            renamedPath = new Path(path.getParent(), "_" + path.getName());
            Path solrShardNumberFile = new Path(renamedPath, "_solrShardNumber");
            FSDataInputStream in = fs.open(solrShardNumberFile);
            byte[] bytes = ByteStreams.toByteArray((InputStream)in);
            in.close();
            Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0);
            int solrShard = Integer.parseInt(new String(bytes, StandardCharsets.UTF_8));
            if (!this.delete(solrShardNumberFile, false, fs)) {
                return false;
            }
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
            numberFormat.setMinimumIntegerDigits(5);
            numberFormat.setGroupingUsed(false);
            Path finalPath = new Path(renamedPath.getParent(), dirPrefix + "-m-" + numberFormat.format(solrShard));
            LOG.info("MTree merge renaming solr shard: " + solrShard + " from dir: " + dir.getPath() + " to dir: " + finalPath);
            if (this.rename(renamedPath, finalPath, fs)) continue;
            return false;
        }
        return true;
    }

    private static void verifyGoLiveArgs(Options opts, ArgumentParser parser) throws ArgumentParserException {
        if (opts.zkHost == null && opts.solrHomeDir == null) {
            throw new ArgumentParserException("At least one of --zk-host or --solr-home-dir is required", parser);
        }
        if (opts.goLive && opts.zkHost == null && opts.shardUrls == null) {
            throw new ArgumentParserException("--go-live requires that you also pass --shard-url or --zk-host", parser);
        }
        if (opts.zkHost != null && opts.collection == null) {
            throw new ArgumentParserException("--zk-host requires that you also pass --collection", parser);
        }
        if (opts.zkHost != null) {
            return;
        }
        if (opts.shardUrls != null) {
            if (opts.shardUrls.size() == 0) {
                throw new ArgumentParserException("--shard-url requires at least one URL", parser);
            }
        } else if (opts.shards != null) {
            if (opts.shards <= 0) {
                throw new ArgumentParserException("--shards must be a positive number: " + opts.shards, parser);
            }
        } else {
            throw new ArgumentParserException("You must specify one of the following (mutually exclusive) arguments: --zk-host or --shard-url or --shards", parser);
        }
        if (opts.shardUrls != null) {
            opts.shards = opts.shardUrls.size();
        }
        assert (opts.shards != null);
        assert (opts.shards > 0);
    }

    private static void verifyZKStructure(Options opts, ArgumentParser parser) throws ArgumentParserException {
        if (opts.zkHost != null) {
            assert (opts.collection != null);
            ZooKeeperInspector zki = new ZooKeeperInspector();
            try {
                opts.shardUrls = zki.extractShardUrls(opts.zkHost, opts.collection);
            }
            catch (Exception e) {
                LOG.debug("Cannot extract SolrCloud shard URLs from ZooKeeper", (Throwable)e);
                throw new ArgumentParserException((Throwable)e, parser);
            }
            assert (opts.shardUrls != null);
            if (opts.shardUrls.size() == 0) {
                throw new ArgumentParserException("--zk-host requires ZooKeeper " + opts.zkHost + " to contain at least one SolrCore for collection: " + opts.collection, parser);
            }
            opts.shards = opts.shardUrls.size();
            LOG.debug("Using SolrCloud shard URLs: {}", opts.shardUrls);
        }
    }

    private boolean waitForCompletion(Job job, boolean isVerbose) throws IOException, InterruptedException, ClassNotFoundException {
        LOG.debug("Running job: " + this.getJobInfo(job));
        boolean success = job.waitForCompletion(isVerbose);
        if (!success) {
            LOG.error("Job failed! " + this.getJobInfo(job));
        }
        return success;
    }

    private void goodbye(Job job, long startTime) {
        float secs = (float)(System.nanoTime() - startTime) / 3.0f;
        if (job != null) {
            LOG.info("Succeeded with job: " + this.getJobInfo(job));
        }
        LOG.info("Success. Done. Program took {} secs. Goodbye.", (Object)Float.valueOf(secs));
    }

    private String getJobInfo(Job job) {
        return "jobName: " + job.getJobName() + ", jobId: " + job.getJobID();
    }

    private boolean rename(Path src, Path dst, FileSystem fs) throws IOException {
        boolean success = fs.rename(src, dst);
        if (!success) {
            LOG.error("Cannot rename " + src + " to " + dst);
        }
        return success;
    }

    private boolean delete(Path path, boolean recursive, FileSystem fs) throws IOException {
        boolean success = fs.delete(path, recursive);
        if (!success) {
            LOG.error("Cannot delete " + path);
        }
        return success;
    }

    private long ceilDivide(long p, long q) {
        long result = p / q;
        if (p % q != 0L) {
            ++result;
        }
        return result;
    }

    private double log(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    static final class Options {
        boolean goLive;
        String collection;
        String zkHost;
        Integer goLiveThreads;
        List<List<String>> shardUrls;
        List<Path> inputLists;
        List<Path> inputFiles;
        Path outputDir;
        int mappers;
        int reducers;
        String updateConflictResolver;
        int fanout;
        Integer shards;
        int maxSegments;
        File morphlineFile;
        String morphlineId;
        File solrHomeDir;
        String fairSchedulerPool;
        boolean isDryRun;
        File log4jConfigFile;
        boolean isVerbose;

        Options() {
        }
    }

    static final class MyArgumentParser {
        private static final String SHOW_NON_SOLR_CLOUD = "--show-non-solr-cloud";
        private boolean showNonSolrCloud = false;

        MyArgumentParser() {
        }

        public Integer parseArgs(String[] args, Configuration conf, Options opts) {
            Namespace ns;
            assert (args != null);
            assert (conf != null);
            assert (opts != null);
            if (args.length == 0) {
                args = new String[]{"--help"};
            }
            this.showNonSolrCloud = Arrays.asList(args).contains(SHOW_NON_SOLR_CLOUD);
            ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"hadoop [GenericOptions]... jar solr-map-reduce-*.jar ", (boolean)false).defaultHelp(true).description("MapReduce batch job driver that takes a morphline and creates a set of Solr index shards from a set of input files and writes the indexes into HDFS, in a flexible, scalable and fault-tolerant manner. It also supports merging the output shards into a set of live customer facing Solr servers, typically a SolrCloud. The program proceeds in several consecutive MapReduce based phases, as follows:\n\n1) Randomization phase: This (parallel) phase randomizes the list of input files in order to spread indexing load more evenly among the mappers of the subsequent phase.\n\n2) Mapper phase: This (parallel) phase takes the input files, extracts the relevant content, transforms it and hands SolrInputDocuments to a set of reducers. The ETL functionality is flexible and customizable using chains of arbitrary morphline commands that pipe records from one transformation command to another. Commands to parse and transform a set of standard data formats such as Avro, CSV, Text, HTML, XML, PDF, Word, Excel, etc. are provided out of the box, and additional custom commands and parsers for additional file or data formats can be added as morphline plugins. This is done by implementing a simple Java interface that consumes a record (e.g. a file in the form of an InputStream plus some headers plus contextual metadata) and generates as output zero or more records. Any kind of data format can be indexed and any Solr documents for any kind of Solr schema can be generated, and any custom ETL logic can be registered and executed.\nRecord fields, including MIME types, can also explicitly be passed by force from the CLI to the morphline, for example: hadoop ... -D morphlineField._attachment_mimetype=text/csv\n\n3) Reducer phase: This (parallel) phase loads the mapper's SolrInputDocuments into one EmbeddedSolrServer per reducer. Each such reducer and Solr server can be seen as a (micro) shard. The Solr servers store their data in HDFS.\n\n4) Mapper-only merge phase: This (parallel) phase merges the set of reducer shards into the number of solr shards expected by the user, using a mapper-only job. This phase is omitted if the number of shards is already equal to the number of shards expected by the user. \n\n5) Go-live phase: This optional (parallel) phase merges the output shards of the previous phase into a set of live customer facing Solr servers, typically a SolrCloud. If this phase is omitted you can explicitly point each Solr server to one of the HDFS output shard directories.\n\nFault Tolerance: Mapper and reducer task attempts are retried on failure per the standard MapReduce semantics. On program startup all data in the --output-dir is deleted if that output directory already exists. If the whole job fails you can retry simply by rerunning the program again using the same arguments.");
            parser.addArgument(new String[]{"--help", "-help", "-h"}).help("Show this help message and exit").action((ArgumentAction)new HelpArgumentAction(){

                public void run(ArgumentParser parser, Argument arg, Map<String, Object> attrs, String flag, Object value) throws ArgumentParserException {
                    parser.printHelp();
                    System.out.println();
                    System.out.print(ToolRunnerHelpFormatter.getGenericCommandUsage());
                    System.out.println("Examples: \n\n# (Re)index an Avro based Twitter tweet file:\nsudo -u hdfs hadoop \\\n  --config /etc/hadoop/conf.cloudera.mapreduce1 \\\n  jar target/solr-map-reduce-*.jar \\\n  -D 'mapred.child.java.opts=-Xmx500m' \\\n  --log4j src/test/resources/log4j.properties \\\n  --morphline-file ../search-core/src/test/resources/test-morphlines/tutorialReadAvroContainer.conf \\\n  --solr-home-dir src/test/resources/solr/minimr \\\n  --output-dir hdfs://c2202.mycompany.com/user/$USER/test \\\n  --shards 1 \\\n  hdfs:///user/$USER/test-documents/sample-statuses-20120906-141433.avro\n\n# Go live by merging resulting index shards into a live Solr cluster\n# (explicitly specify Solr URLs - for a SolrCloud cluster see next example):\nsudo -u hdfs hadoop \\\n  --config /etc/hadoop/conf.cloudera.mapreduce1 \\\n  jar target/solr-map-reduce-*.jar \\\n  -D 'mapred.child.java.opts=-Xmx500m' \\\n  --log4j src/test/resources/log4j.properties \\\n  --morphline-file ../search-core/src/test/resources/test-morphlines/tutorialReadAvroContainer.conf \\\n  --solr-home-dir src/test/resources/solr/minimr \\\n  --output-dir hdfs://c2202.mycompany.com/user/$USER/test \\\n  --shard-url http://solr001.mycompany.com:8983/solr/collection1 \\\n  --shard-url http://solr002.mycompany.com:8983/solr/collection1 \\\n  --go-live \\\n  hdfs:///user/foo/indir\n\n# Go live by merging resulting index shards into a live SolrCloud cluster\n# (discover shards and Solr URLs through ZooKeeper):\nsudo -u hdfs hadoop \\\n  --config /etc/hadoop/conf.cloudera.mapreduce1 \\\n  jar target/solr-map-reduce-*.jar \\\n  -D 'mapred.child.java.opts=-Xmx500m' \\\n  --log4j src/test/resources/log4j.properties \\\n  --morphline-file ../search-core/src/test/resources/test-morphlines/tutorialReadAvroContainer.conf \\\n  --output-dir hdfs://c2202.mycompany.com/user/$USER/test \\\n  --zk-host zk01.mycompany.com:2181/solr \\\n  --collection collection1 \\\n  --go-live \\\n  hdfs:///user/foo/indir\n");
                    throw new FoundHelpArgument();
                }
            });
            ArgumentGroup requiredGroup = parser.addArgumentGroup("Required arguments");
            Argument outputDirArg = requiredGroup.addArgument(new String[]{"--output-dir"}).metavar(new String[]{"HDFS_URI"}).type((ArgumentType)new PathArgumentType(conf){

                @Override
                public Path convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
                    Path path = super.convert(parser, arg, value);
                    if ("hdfs".equals(path.toUri().getScheme()) && path.toUri().getAuthority() == null) {
                        throw new ArgumentParserException("Missing authority in path URI: " + path, parser);
                    }
                    return path;
                }
            }.verifyHasScheme().verifyIsAbsolute().verifyCanWriteParent()).required(true).help("HDFS directory to write Solr indexes to. Inside there one output directory per shard will be generated. Example: hdfs://c2202.mycompany.com/user/$USER/test");
            Argument inputListArg = parser.addArgument(new String[]{"--input-list"}).action((ArgumentAction)Arguments.append()).metavar(new String[]{"URI"}).type(Path.class).help("Local URI or HDFS URI of a UTF-8 encoded file containing a list of HDFS URIs to index, one URI per line in the file. If '-' is specified, URIs are read from the standard input. Multiple --input-list arguments can be specified.");
            Argument morphlineFileArg = requiredGroup.addArgument(new String[]{"--morphline-file"}).metavar(new String[]{"FILE"}).type((ArgumentType)new FileArgumentType().verifyExists().verifyIsFile().verifyCanRead()).required(true).help("Relative or absolute path to a local config file that contains one or more morphlines. The file must be UTF-8 encoded. Example: /path/to/morphline.conf");
            Argument morphlineIdArg = parser.addArgument(new String[]{"--morphline-id"}).metavar(new String[]{"STRING"}).type(String.class).help("The identifier of the morphline that shall be executed within the morphline config file specified by --morphline-file. If the --morphline-id option is ommitted the first (i.e. top-most) morphline within the config file is used. Example: morphline1");
            Argument solrHomeDirArg = this.nonSolrCloud(parser.addArgument(new String[]{"--solr-home-dir"}).metavar(new String[]{"DIR"}).type((ArgumentType)new FileArgumentType(){

                public File convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
                    File solrHomeDir = super.convert(parser, arg, value);
                    File solrConfigFile = new File(new File(solrHomeDir, "conf"), "solrconfig.xml");
                    new FileArgumentType().verifyExists().verifyIsFile().verifyCanRead().convert(parser, arg, solrConfigFile.getPath());
                    return solrHomeDir;
                }
            }.verifyIsDirectory().verifyCanRead()).required(false).help("Relative or absolute path to a local dir containing Solr conf/ dir and in particular conf/solrconfig.xml and optionally also lib/ dir. This directory will be uploaded to each MR task. Example: src/test/resources/solr/minimr"));
            Argument updateConflictResolverArg = parser.addArgument(new String[]{"--update-conflict-resolver"}).metavar(new String[]{"FQCN"}).type(String.class).setDefault((Object)RetainMostRecentUpdateConflictResolver.class.getName()).help("Fully qualified class name of a Java class that implements the UpdateConflictResolver interface. This enables deduplication and ordering of a series of document updates for the same unique document key. For example, a MapReduce batch job might index multiple files in the same job where some of the files contain old and new versions of the very same document, using the same unique document key.\nTypically, implementations of this interface forbid collisions by throwing an exception, or ignore all but the most recent document version, or, in the general case, order colliding updates ascending from least recent to most recent (partial) update. The caller of this interface (i.e. the Hadoop Reducer) will then apply the updates to Solr in the order returned by the orderUpdates() method.\nThe default RetainMostRecentUpdateConflictResolver implementation ignores all but the most recent document version, based on a configurable numeric Solr field, which defaults to the file_last_modified timestamp");
            Argument mappersArg = parser.addArgument(new String[]{"--mappers"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).setDefault((Object)-1).help("Tuning knob that indicates the maximum number of MR mapper tasks to use. -1 indicates use all map slots available on the cluster.");
            Argument reducersArg = parser.addArgument(new String[]{"--reducers"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(-2), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).setDefault((Object)-1).help("Tuning knob that indicates the number of reducers to index into. 0 is reserved for a mapper-only feature that may ship in a future release. -1 indicates use all reduce slots available on the cluster. -2 indicates use one reducer per output shard, which disables the mtree merge MR algorithm. The mtree merge MR algorithm improves scalability by spreading load (in particular CPU load) among a number of parallel reducers that can be much larger than the number of solr shards expected by the user. It can be seen as an extension of concurrent lucene merges and tiered lucene merges to the clustered case. The subsequent mapper-only phase merges the output of said large number of reducers to the number of shards expected by the user, again by utilizing more available parallelism on the cluster.");
            Argument fanoutArg = parser.addArgument(new String[]{"--fanout"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).setDefault((Object)Integer.MAX_VALUE).help(FeatureControl.SUPPRESS);
            Argument maxSegmentsArg = parser.addArgument(new String[]{"--max-segments"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).setDefault((Object)1).help("Tuning knob that indicates the maximum number of segments to be contained on output in the index of each reducer shard. After a reducer has built its output index it applies a merge policy to merge segments until there are <= maxSegments lucene segments left in this index. Merging segments involves reading and rewriting all data in all these segment files, potentially multiple times, which is very I/O intensive and time consuming. However, an index with fewer segments can later be merged faster, and it can later be queried faster once deployed to a live Solr serving shard. Set maxSegments to 1 to optimize the index for low query latency. In a nutshell, a small maxSegments value trades indexing latency for subsequently improved query latency. This can be a reasonable trade-off for batch indexing systems.");
            Argument fairSchedulerPoolArg = parser.addArgument(new String[]{"--fair-scheduler-pool"}).metavar(new String[]{"STRING"}).help("Optional tuning knob that indicates the name of the fair scheduler pool to submit jobs to. The Fair Scheduler is a pluggable MapReduce scheduler that provides a way to share large clusters. Fair scheduling is a method of assigning resources to jobs such that all jobs get, on average, an equal share of resources over time. When there is a single job running, that job uses the entire cluster. When other jobs are submitted, tasks slots that free up are assigned to the new jobs, so that each job gets roughly the same amount of CPU time. Unlike the default Hadoop scheduler, which forms a queue of jobs, this lets short jobs finish in reasonable time while not starving long jobs. It is also an easy way to share a cluster between multiple of users. Fair sharing can also work with job priorities - the priorities are used as weights to determine the fraction of total compute time that each job gets.");
            Argument dryRunArg = parser.addArgument(new String[]{"--dry-run"}).action((ArgumentAction)Arguments.storeTrue()).help("Run in local mode and print documents to stdout instead of loading them into Solr. This executes the morphline in the client process (without submitting a job to MR) for quicker turnaround during early trial & debug sessions.");
            Argument log4jConfigFileArg = parser.addArgument(new String[]{"--log4j"}).metavar(new String[]{"FILE"}).type((ArgumentType)new FileArgumentType().verifyExists().verifyIsFile().verifyCanRead()).help("Relative or absolute path to a log4j.properties config file on the local file system. This file will be uploaded to each MR task. Example: /path/to/log4j.properties");
            Argument verboseArg = parser.addArgument(new String[]{"--verbose", "-v"}).action((ArgumentAction)Arguments.storeTrue()).help("Turn on verbose output.");
            parser.addArgument(new String[]{SHOW_NON_SOLR_CLOUD}).action((ArgumentAction)Arguments.storeTrue()).help("Also show options for Non-SolrCloud mode as part of --help.");
            ArgumentGroup clusterInfoGroup = parser.addArgumentGroup("Cluster arguments").description("Arguments that provide information about your Solr cluster. " + this.nonSolrCloud("If you are building shards for a SolrCloud cluster, pass the --zk-host argument. If you are building shards for a Non-SolrCloud cluster, pass the --shard-url argument one or more times. To build indexes for a replicated Non-SolrCloud cluster with --shard-url, pass replica urls consecutively and also pass --shards. Using --go-live requires either --zk-host or --shard-url."));
            Argument zkHostArg = clusterInfoGroup.addArgument(new String[]{"--zk-host"}).metavar(new String[]{"STRING"}).type(String.class).help("The address of a ZooKeeper ensemble being used by a SolrCloud cluster. This ZooKeeper ensemble will be examined to determine the number of output shards to create as well as the Solr URLs to merge the output shards into when using the --go-live option. Requires that you also pass the --collection to merge the shards into.\n\nThe --zk-host option implements the same partitioning semantics as the standard SolrCloud Near-Real-Time (NRT) API. This enables to mix batch updates from MapReduce ingestion with updates from standard Solr NRT ingestion on the same SolrCloud cluster, using identical unique document keys.\n\nFormat is: a list of comma separated host:port pairs, each corresponding to a zk server. Example: '127.0.0.1:2181,127.0.0.1:2182,127.0.0.1:2183' If the optional chroot suffix is used the example would look like: '127.0.0.1:2181/solr,127.0.0.1:2182/solr,127.0.0.1:2183/solr' where the client would be rooted at '/solr' and all paths would be relative to this root - i.e. getting/setting/etc... '/foo/bar' would result in operations being run on '/solr/foo/bar' (from the server perspective).\n" + this.nonSolrCloud("\nIf --solr-home-dir is not specified, the Solr home directory for the collection will be downloaded from this ZooKeeper ensemble."));
            Argument shardUrlsArg = this.nonSolrCloud(clusterInfoGroup.addArgument(new String[]{"--shard-url"}).metavar(new String[]{"URL"}).type(String.class).action((ArgumentAction)Arguments.append()).help("Solr URL to merge resulting shard into if using --go-live. Example: http://solr001.mycompany.com:8983/solr/collection1. Multiple --shard-url arguments can be specified, one for each desired shard. If you are merging shards into a SolrCloud cluster, use --zk-host instead."));
            Argument shardsArg = this.nonSolrCloud(clusterInfoGroup.addArgument(new String[]{"--shards"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).help("Number of output shards to generate."));
            ArgumentGroup goLiveGroup = parser.addArgumentGroup("Go live arguments").description("Arguments for merging the shards that are built into a live Solr cluster. Also see the Cluster arguments.");
            Argument goLiveArg = goLiveGroup.addArgument(new String[]{"--go-live"}).action((ArgumentAction)Arguments.storeTrue()).help("Allows you to optionally merge the final index shards into a live Solr cluster after they are built. You can pass the ZooKeeper address with --zk-host and the relevant cluster information will be auto detected. " + this.nonSolrCloud("If you are not using a SolrCloud cluster, --shard-url arguments can be used to specify each SolrCore to merge each shard into."));
            Argument collectionArg = goLiveGroup.addArgument(new String[]{"--collection"}).metavar(new String[]{"STRING"}).help("The SolrCloud collection to merge shards into when using --go-live and --zk-host. Example: collection1");
            Argument goLiveThreadsArg = goLiveGroup.addArgument(new String[]{"--go-live-threads"}).metavar(new String[]{"INTEGER"}).type(Integer.class).choices((ArgumentChoice)new RangeArgumentChoice((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE))).setDefault((Object)1000).help("Tuning knob that indicates the maximum number of live merges to run in parallel at one time.");
            Argument inputFilesArg = parser.addArgument(new String[]{"input-files"}).metavar(new String[]{"HDFS_URI"}).type((ArgumentType)new PathArgumentType(conf).verifyHasScheme().verifyExists().verifyCanRead()).nargs("*").setDefault(new Object[0]).help("HDFS URI of file or directory tree to index.");
            try {
                ns = parser.parseArgs(args);
            }
            catch (FoundHelpArgument e) {
                return 0;
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                return 1;
            }
            opts.log4jConfigFile = (File)ns.get(log4jConfigFileArg.getDest());
            if (opts.log4jConfigFile != null) {
                PropertyConfigurator.configure((String)opts.log4jConfigFile.getPath());
            }
            LOG.debug("Parsed command line args: {}", (Object)ns);
            opts.inputLists = ns.getList(inputListArg.getDest());
            if (opts.inputLists == null) {
                opts.inputLists = Collections.EMPTY_LIST;
            }
            opts.inputFiles = ns.getList(inputFilesArg.getDest());
            opts.outputDir = (Path)ns.get(outputDirArg.getDest());
            opts.mappers = ns.getInt(mappersArg.getDest());
            opts.reducers = ns.getInt(reducersArg.getDest());
            opts.updateConflictResolver = ns.getString(updateConflictResolverArg.getDest());
            opts.fanout = ns.getInt(fanoutArg.getDest());
            opts.maxSegments = ns.getInt(maxSegmentsArg.getDest());
            opts.morphlineFile = (File)ns.get(morphlineFileArg.getDest());
            opts.morphlineId = ns.getString(morphlineIdArg.getDest());
            opts.solrHomeDir = (File)ns.get(solrHomeDirArg.getDest());
            opts.fairSchedulerPool = ns.getString(fairSchedulerPoolArg.getDest());
            opts.isDryRun = ns.getBoolean(dryRunArg.getDest());
            opts.isVerbose = ns.getBoolean(verboseArg.getDest());
            opts.zkHost = ns.getString(zkHostArg.getDest());
            opts.shards = ns.getInt(shardsArg.getDest());
            opts.shardUrls = MapReduceIndexerTool.buildShardUrls(ns.getList(shardUrlsArg.getDest()), opts.shards);
            opts.goLive = ns.getBoolean(goLiveArg.getDest());
            opts.goLiveThreads = ns.getInt(goLiveThreadsArg.getDest());
            opts.collection = ns.getString(collectionArg.getDest());
            try {
                if (opts.reducers == 0) {
                    throw new ArgumentParserException("--reducers must not be zero", parser);
                }
                MapReduceIndexerTool.verifyGoLiveArgs(opts, parser);
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                return 1;
            }
            if (opts.inputLists.isEmpty() && opts.inputFiles.isEmpty()) {
                LOG.info("No input files specified - nothing to process");
                return 0;
            }
            return null;
        }

        private Argument nonSolrCloud(Argument arg) {
            return this.showNonSolrCloud ? arg : arg.help(FeatureControl.SUPPRESS);
        }

        private String nonSolrCloud(String msg) {
            return this.showNonSolrCloud ? msg : "";
        }

        private static final class FoundHelpArgument
        extends RuntimeException {
            private FoundHelpArgument() {
            }
        }
    }
}

