/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.IntIntProcedure;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractIntIntMap
extends AbstractSet {
    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final int value) {
        return !this.forEachPair(new IntIntProcedure(){

            public boolean apply(int iterKey, int iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntIntMap copy() {
        return (AbstractIntIntMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntIntMap)) {
            return false;
        }
        final AbstractIntIntMap other = (AbstractIntIntMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntIntProcedure(){

            public boolean apply(int key, int value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntIntProcedure(){

            public boolean apply(int key, int value) {
                return AbstractIntIntMap.this.containsKey(key) && AbstractIntIntMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntIntProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntIntMap.this.get(key));
            }
        });
    }

    public abstract int get(int var1);

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new IntArrayList(this.size()));
    }

    public void pairsMatching(final IntIntProcedure condition, final IntArrayList keyList, final IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntIntProcedure(){

            public boolean apply(int key, int value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, IntArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final int[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                int t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, int var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public IntArrayList values() {
        IntArrayList list = new IntArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int key) {
                list.add(AbstractIntIntMap.this.get(key));
                return true;
            }
        });
    }

    public int adjustOrPutValue(int key, int newValue, int incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

