/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.tika.language.LanguageIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    public TikaLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(String content) {
        ArrayList<DetectedLanguage> languages = new ArrayList<DetectedLanguage>();
        if (content.trim().length() != 0) {
            LanguageIdentifier identifier = new LanguageIdentifier(content);
            Double distance = Double.parseDouble(this.tikaSimilarityPattern.matcher(identifier.toString()).replaceFirst("$1"));
            Double certainty = 1.0 - 5.0 * distance;
            certainty = certainty < 0.0 ? 0.0 : certainty;
            DetectedLanguage language = new DetectedLanguage(identifier.getLanguage(), certainty);
            languages.add(language);
            log.debug("Language detected as " + language + " with a certainty of " + language.getCertainty() + " (Tika distance=" + identifier.toString() + ")");
        } else {
            log.debug("No input text to detect language from, returning empty list");
        }
        return languages;
    }
}

