/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.ILabelFilter;
import org.carrot2.text.preprocessing.filter.LeftCompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.RightCompleteLabelFilter;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.constraint.DoubleRange;

@Bindable(prefix="CompleteLabelFilter")
public class CompleteLabelFilter
implements ILabelFilter {
    @Input
    @Processing
    @Attribute
    public boolean enabled = true;
    @Input
    @Processing
    @Attribute
    @DoubleRange(min=0.0, max=1.0)
    public double labelOverrideThreshold = 0.65;
    private LeftCompleteLabelFilter leftCompleteLabelFilter = new LeftCompleteLabelFilter();
    private RightCompleteLabelFilter rightCompleteLabelFilter = new RightCompleteLabelFilter();

    public void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        if (!this.enabled) {
            return;
        }
        this.leftCompleteLabelFilter.filter(context, acceptedStems, acceptedPhrases, this.labelOverrideThreshold);
        this.rightCompleteLabelFilter.filter(context, acceptedStems, acceptedPhrases, this.labelOverrideThreshold);
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

