/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ControllerContextImpl;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.attribute.Init;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.AttributeValueSets;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceLookup;
import org.carrot2.util.simplexml.PersisterHelpers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Commit;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingComponentDescriptor {
    @Attribute(name="component-class")
    private String componentClassName;
    private Class<? extends IProcessingComponent> componentClass;
    private Throwable initializationException;
    @Attribute
    private String id;
    @Element
    private String label;
    @Element(required=false)
    private String mnemonic;
    @Element
    private String title;
    @Element(required=false, name="icon-path")
    private String iconPath;
    @Element(required=false)
    private String description;
    private AttributeValueSets attributeSets;
    @Attribute(name="attribute-sets-resource", required=false)
    private String attributeSetsResource;
    @Attribute(name="attribute-set-id", required=false)
    private String attributeSetId;
    private BindableDescriptor bindableDescriptor;

    ProcessingComponentDescriptor() {
    }

    public ProcessingComponentConfiguration getComponentConfiguration() {
        return new ProcessingComponentConfiguration(this.getComponentClass(), this.id, this.getAttributes());
    }

    private Map<String, Object> getAttributes() {
        HashMap result = AttributeValueSet.getAttributeValues(this.getAttributeSets().getAttributeValueSet(this.attributeSetId, true));
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }

    public synchronized Class<? extends IProcessingComponent> getComponentClass() {
        if (this.componentClass == null) {
            try {
                this.componentClass = ReflectionUtils.classForName(this.componentClassName);
            }
            catch (Exception e) {
                throw new RuntimeException("Component class cannot be acquired: " + this.componentClassName, e);
            }
        }
        return this.componentClass;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAttributeSetsResource() {
        return this.attributeSetsResource;
    }

    public AttributeValueSets getAttributeSets() {
        return this.attributeSets;
    }

    public String getAttributeSetId() {
        return this.attributeSetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProcessingComponent newInitializedInstance() throws InstantiationException, IllegalAccessException {
        IProcessingComponent instance = this.getComponentClass().newInstance();
        HashMap initAttributes = Maps.newHashMap();
        AttributeValueSet defaultAttributeValueSet = this.attributeSets.getDefaultAttributeValueSet();
        if (defaultAttributeValueSet != null) {
            initAttributes.putAll(defaultAttributeValueSet.getAttributeValues());
        }
        ControllerContextImpl context = new ControllerContextImpl();
        try {
            AttributeBinder.set(instance, (Map<String, Object>)initAttributes, false, Input.class);
            try {
                instance.init(context);
            }
            catch (Throwable t) {
                // empty catch block
            }
            AttributeBinder.get(instance, initAttributes, Output.class, Init.class);
        }
        finally {
            context.dispose();
        }
        return instance;
    }

    public BindableDescriptor getBindableDescriptor() {
        if (this.bindableDescriptor == null) {
            throw new RuntimeException("Descriptor not available.", this.initializationException);
        }
        return this.bindableDescriptor;
    }

    public boolean isComponentAvailable() {
        return this.initializationException == null;
    }

    public Throwable getInitializationFailure() {
        return this.initializationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeSets(ResourceLookup resourceLookup) throws Exception {
        this.attributeSets = new AttributeValueSets();
        IResource resource = null;
        if (!StringUtils.isBlank((String)this.attributeSetsResource) && (resource = resourceLookup.getFirst(this.attributeSetsResource)) == null) {
            throw new IOException("Attribute set resource not found: " + this.attributeSetsResource);
        }
        if (resource != null) {
            InputStream inputStream = resource.open();
            try {
                this.attributeSets = AttributeValueSets.deserialize(inputStream);
            }
            finally {
                CloseableUtils.close((Closeable)inputStream);
            }
        }
        if (this.getAttributeSets() == null) {
            this.attributeSets = new AttributeValueSets();
        }
    }

    @Commit
    private void onCommit(Map<Object, Object> session) {
        this.initializationException = null;
        try {
            ResourceLookup resourceLookup = PersisterHelpers.getResourceLookup(session);
            this.loadAttributeSets(resourceLookup);
            this.bindableDescriptor = BindableDescriptorBuilder.buildDescriptor(this.newInitializedInstance());
        }
        catch (Throwable e) {
            LoggerFactory.getLogger(this.getClass()).warn("Component unavailable: " + this.componentClassName, e);
            this.initializationException = e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProcessingComponentDescriptorToId
    implements Function<ProcessingComponentDescriptor, String> {
        public static final ProcessingComponentDescriptorToId INSTANCE = new ProcessingComponentDescriptorToId();

        private ProcessingComponentDescriptorToId() {
        }

        public String apply(ProcessingComponentDescriptor descriptor) {
            return descriptor.id;
        }
    }
}

