/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.LanguageCode;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Root(name="document")
@JsonAutoDetect(value={JsonMethod.NONE})
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class Document {
    public static final String TITLE = "title";
    public static final String SUMMARY = "snippet";
    public static final String CONTENT_URL = "url";
    public static final String CLICK_URL = "click-url";
    public static final String THUMBNAIL_URL = "thumbnail-url";
    public static final String SIZE = "size";
    public static final String SOURCES = "sources";
    public static final String LANGUAGE = "language";
    public static final String PARTITIONS = "partitions";
    private final Map<String, Object> fields = Maps.newHashMap();
    private final Map<String, Object> fieldsView = Collections.unmodifiableMap(this.fields);
    @Attribute(required=false)
    Integer id;
    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherFieldsForSerialization;
    public static final Comparator<Document> BY_ID_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)DocumentToId.INSTANCE);

    public Document() {
    }

    public Document(String title) {
        this(title, null);
    }

    public Document(String title, String summary) {
        this(title, summary, (String)null);
    }

    public Document(String title, String summary, LanguageCode language) {
        this(title, summary, null, language);
    }

    public Document(String title, String summary, String contentUrl) {
        this(title, summary, contentUrl, null);
    }

    public Document(String title, String summary, String contentUrl, LanguageCode language) {
        this.setField(TITLE, title);
        this.setField(SUMMARY, summary);
        if (StringUtils.isNotBlank((String)contentUrl)) {
            this.setField(CONTENT_URL, contentUrl);
        }
        if (language != null) {
            this.setField(LANGUAGE, (Object)language);
        }
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    @JsonProperty
    @Element(required=false)
    public String getTitle() {
        return (String)this.getField(TITLE);
    }

    @Element(required=false)
    public Document setTitle(String title) {
        return this.setField(TITLE, title);
    }

    @JsonProperty(value="snippet")
    @Element(name="snippet", required=false)
    public String getSummary() {
        return (String)this.getField(SUMMARY);
    }

    @Element(name="snippet", required=false)
    public Document setSummary(String summary) {
        return this.setField(SUMMARY, summary);
    }

    @JsonProperty(value="url")
    @Element(name="url", required=false)
    public String getContentUrl() {
        return (String)this.getField(CONTENT_URL);
    }

    @Element(name="url", required=false)
    public Document setContentUrl(String contentUrl) {
        return this.setField(CONTENT_URL, contentUrl);
    }

    @JsonProperty
    @ElementList(entry="source", required=false)
    public List<String> getSources() {
        return (List)this.getField(SOURCES);
    }

    @ElementList(entry="source", required=false)
    public Document setSources(List<String> sources) {
        return this.setField(SOURCES, sources);
    }

    public LanguageCode getLanguage() {
        return (LanguageCode)((Object)this.getField(LANGUAGE));
    }

    public Document setLanguage(LanguageCode language) {
        return this.setField(LANGUAGE, (Object)language);
    }

    @JsonProperty(value="language")
    @Attribute(required=false, name="language")
    private String getLanguageIsoCode() {
        LanguageCode language = this.getLanguage();
        return language != null ? language.getIsoCode() : null;
    }

    @Attribute(required=false, name="language")
    private void setLanguageIsoCode(String languageIsoCode) {
        if (languageIsoCode != null) {
            LanguageCode language = LanguageCode.forISOCode(languageIsoCode);
            if (language != null) {
                this.setLanguage(language);
            } else {
                this.setLanguage(LanguageCode.valueOf(languageIsoCode));
            }
        } else {
            this.setLanguage(null);
        }
    }

    @JsonProperty(value="fields")
    private Map<String, Object> getOtherFields() {
        HashMap otherFields = Maps.newHashMap(this.fieldsView);
        otherFields.remove(TITLE);
        otherFields.remove(SUMMARY);
        otherFields.remove(CONTENT_URL);
        otherFields.remove(SOURCES);
        otherFields.remove(LANGUAGE);
        return otherFields.isEmpty() ? null : otherFields;
    }

    public Map<String, Object> getFields() {
        return this.fieldsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getField(String name) {
        Map<String, Object> map = this.fields;
        synchronized (map) {
            return (T)this.fields.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setField(String name, Object value) {
        Map<String, Object> map = this.fields;
        synchronized (map) {
            this.fields.put(name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignDocumentIds(Collection<Document> documents) {
        Collection<Document> collection = documents;
        synchronized (collection) {
            HashSet ids = Sets.newHashSet();
            int maxId = Integer.MIN_VALUE;
            for (Document document : documents) {
                if (document.id == null) continue;
                if (ids.add(document.id)) {
                    maxId = Math.max(maxId, document.id);
                    continue;
                }
                document.id = null;
            }
            maxId = Math.max(maxId, -1);
            for (Document document : documents) {
                if (document.id != null) continue;
                document.id = ++maxId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Persist
    private void beforeSerialization() {
        Map<String, Object> map = this.fields;
        synchronized (map) {
            this.otherFieldsForSerialization = MapUtils.asHashMap(SimpleXmlWrappers.wrap(this.fields));
            this.otherFieldsForSerialization.remove(TITLE);
            this.otherFieldsForSerialization.remove(SUMMARY);
            this.otherFieldsForSerialization.remove(CONTENT_URL);
            this.otherFieldsForSerialization.remove(SOURCES);
            this.otherFieldsForSerialization.remove(LANGUAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Commit
    private void afterDeserialization() throws Throwable {
        Map<String, Object> map = this.fields;
        synchronized (map) {
            if (this.otherFieldsForSerialization != null) {
                this.fields.putAll(SimpleXmlWrappers.unwrap(this.otherFieldsForSerialization));
            }
            this.otherFieldsForSerialization = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DocumentToId
    implements Function<Document, Integer> {
        public static final DocumentToId INSTANCE = new DocumentToId();

        private DocumentToId() {
        }

        public Integer apply(Document document) {
            return document.id;
        }
    }
}

