/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowFileRequestHandler
extends RequestHandlerBase {
    public static final String HIDDEN = "hidden";
    public static final String USE_CONTENT_TYPE = "contentType";
    protected Set<String> hiddenFiles;
    private static ShowFileRequestHandler instance;

    public ShowFileRequestHandler() {
        instance = this;
    }

    @Override
    public void init(NamedList args) {
        String[] hidden;
        super.init(args);
        this.hiddenFiles = new HashSet<String>();
        if (this.invariants != null && (hidden = this.invariants.getParams(HIDDEN)) != null) {
            for (String s : hidden) {
                this.hiddenFiles.add(s.toUpperCase(Locale.ENGLISH));
            }
        }
    }

    public Set<String> getHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        String fname;
        File adminFile = null;
        SolrResourceLoader loader = req.getCore().getResourceLoader();
        File configdir = new File(loader.getConfigDir());
        if (!configdir.exists()) {
            try {
                configdir = new File(loader.getClassLoader().getResource(loader.getConfigDir()).toURI());
            }
            catch (URISyntaxException e) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access configuration directory!");
            }
        }
        if ((fname = req.getParams().get("file", null)) == null) {
            adminFile = configdir;
        } else {
            if (this.hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase(Locale.ENGLISH))) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname);
            }
            if (fname.indexOf("..") >= 0) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fname);
            }
            adminFile = new File(configdir, fname);
        }
        if (!adminFile.exists()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (!adminFile.canRead() || adminFile.isHidden()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (adminFile.isDirectory()) {
            int basePath = configdir.getAbsolutePath().length() + 1;
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (File f : adminFile.listFiles()) {
                String path = f.getAbsolutePath().substring(basePath);
                if (this.hiddenFiles.contains((path = path.replace('\\', '/')).toUpperCase(Locale.ENGLISH)) || f.isHidden() || f.getName().startsWith(".")) continue;
                SimpleOrderedMap fileInfo = new SimpleOrderedMap();
                files.add(path, (Object)fileInfo);
                if (f.isDirectory()) {
                    fileInfo.add("directory", (Object)true);
                } else {
                    fileInfo.add("size", (Object)f.length());
                }
                fileInfo.add("modified", (Object)new Date(f.lastModified()));
            }
            rsp.add("files", files);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
            params.set("wt", new String[]{"raw"});
            req.setParams((SolrParams)params);
            ContentStreamBase.FileStream content = new ContentStreamBase.FileStream(adminFile);
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getFileContents(String path) {
        String string;
        if (instance != null && ShowFileRequestHandler.instance.hiddenFiles != null && ShowFileRequestHandler.instance.hiddenFiles.contains(path)) {
            return "";
        }
        InputStream input = null;
        try {
            SolrCore core = SolrCore.getSolrCore();
            input = core.getResourceLoader().openResource(path);
            string = IOUtils.toString((InputStream)input, (String)"UTF-8");
            Object var5_5 = null;
        }
        catch (Exception exception) {
            try {
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                IOUtils.closeQuietly((InputStream)input);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            return "";
        }
        IOUtils.closeQuietly((InputStream)input);
        return string;
    }

    @Override
    public String getDescription() {
        return "Admin Get File -- view config files directly";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1205775 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: ShowFileRequestHandler.java 1205775 2011-11-24 10:16:09Z shalin $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_6/solr/core/src/java/org/apache/solr/handler/admin/ShowFileRequestHandler.java $";
    }
}

