/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.bkd.OfflinePointReader;
import org.apache.lucene.util.bkd.PointReader;
import org.apache.lucene.util.bkd.PointWriter;

final class OfflinePointWriter
implements PointWriter {
    final Directory tempDir;
    final IndexOutput out;
    final int packedBytesLength;
    private long count;
    private boolean closed;

    public OfflinePointWriter(Directory tempDir, String tempFileNamePrefix, int packedBytesLength, String desc) throws IOException {
        this.out = tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.DEFAULT);
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
    }

    public OfflinePointWriter(Directory tempDir, IndexOutput out, int packedBytesLength, long count) {
        this.out = out;
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
        this.count = count;
        this.closed = true;
    }

    @Override
    public void append(byte[] packedValue, long ord, int docID) throws IOException {
        assert (packedValue.length == this.packedBytesLength);
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(docID);
        this.out.writeLong(ord);
        ++this.count;
    }

    @Override
    public PointReader getReader(long start, long length) throws IOException {
        assert (this.closed);
        assert (start + length <= this.count) : "start=" + start + " length=" + length + " count=" + this.count;
        return new OfflinePointReader(this.tempDir, this.out.getName(), this.packedBytesLength, start, length);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.tempDir.deleteFile(this.out.getName());
    }

    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.out.getName() + ")";
    }
}

