/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class FunctionRangeQuery
extends Query {
    private final ValueSource valueSource;
    private final String lowerVal;
    private final String upperVal;
    private final boolean includeLower;
    private final boolean includeUpper;

    public FunctionRangeQuery(ValueSource valueSource, Number lowerVal, Number upperVal, boolean includeLower, boolean includeUpper) {
        this(valueSource, lowerVal == null ? null : lowerVal.toString(), upperVal == null ? null : upperVal.toString(), includeLower, includeUpper);
    }

    public FunctionRangeQuery(ValueSource valueSource, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        this.valueSource = valueSource;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public String getLowerVal() {
        return this.lowerVal;
    }

    public String getUpperVal() {
        return this.upperVal;
    }

    public boolean isIncludeLower() {
        return this.includeLower;
    }

    public boolean isIncludeUpper() {
        return this.includeUpper;
    }

    public String toString(String field) {
        return "frange(" + this.valueSource + "):" + (this.includeLower ? (char)'[' : '{') + (this.lowerVal == null ? "*" : this.lowerVal) + " TO " + (this.upperVal == null ? "*" : this.upperVal) + (this.includeUpper ? (char)']' : '}');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionRangeQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FunctionRangeQuery that = (FunctionRangeQuery)((Object)o);
        return Objects.equals(this.includeLower, that.includeLower) && Objects.equals(this.includeUpper, that.includeUpper) && Objects.equals(this.valueSource, that.valueSource) && Objects.equals(this.lowerVal, that.lowerVal) && Objects.equals(this.upperVal, that.upperVal);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valueSource, this.lowerVal, this.upperVal, this.includeLower, this.includeUpper);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new FunctionRangeWeight(searcher);
    }

    private class FunctionRangeWeight
    extends Weight {
        private final Map vsContext;

        public FunctionRangeWeight(IndexSearcher searcher) throws IOException {
            super((Query)FunctionRangeQuery.this);
            this.vsContext = ValueSource.newContext(searcher);
            FunctionRangeQuery.this.valueSource.createWeight(this.vsContext, searcher);
        }

        public void extractTerms(Set<Term> terms) {
        }

        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            FunctionValues functionValues = FunctionRangeQuery.this.valueSource.getValues(this.vsContext, context);
            ValueSourceScorer scorer = this.scorer(context);
            if (scorer.matches(doc)) {
                scorer.iterator().advance(doc);
                return Explanation.match((float)scorer.score(), (String)FunctionRangeQuery.this.toString(), (Explanation[])new Explanation[]{functionValues.explain(doc)});
            }
            return Explanation.noMatch((String)FunctionRangeQuery.this.toString(), (Explanation[])new Explanation[]{functionValues.explain(doc)});
        }

        public ValueSourceScorer scorer(LeafReaderContext context) throws IOException {
            FunctionValues functionValues = FunctionRangeQuery.this.valueSource.getValues(this.vsContext, context);
            return functionValues.getRangeScorer(context, FunctionRangeQuery.this.lowerVal, FunctionRangeQuery.this.upperVal, FunctionRangeQuery.this.includeLower, FunctionRangeQuery.this.includeUpper);
        }
    }
}

