/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.io.IOException;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.internal.web.controllers.AbstractCommandsController;
import org.apache.geode.management.internal.web.domain.Link;
import org.apache.geode.management.internal.web.domain.LinkIndex;
import org.apache.geode.management.internal.web.domain.QueryParameterSource;
import org.apache.geode.management.internal.web.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="shellController")
@RequestMapping(value={"/v1"})
public class ShellCommandsController
extends AbstractCommandsController {
    protected static final String MBEAN_ATTRIBUTE_LINK_RELATION = "mbean-attribute";
    protected static final String MBEAN_OPERATION_LINK_RELATION = "mbean-operation";
    protected static final String MBEAN_QUERY_LINK_RELATION = "mbean-query";
    protected static final String PING_LINK_RELATION = "ping";

    @RequestMapping(method={RequestMethod.POST}, value={"/management/commands"}, params={"cmd"})
    @ResponseBody
    public String command(@RequestParam(value="cmd") String command) {
        return this.processCommand(ShellCommandsController.decode(command));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/mbean/attribute"})
    public ResponseEntity<?> getAttribute(@RequestParam(value="resourceName") String resourceName, @RequestParam(value="attributeName") String attributeName) {
        try {
            Object attributeValue = this.getMBeanServer().getAttribute(ObjectName.getInstance(ShellCommandsController.decode(resourceName)), ShellCommandsController.decode(attributeName));
            return new ResponseEntity((Object)IOUtils.serializeObject((Object)attributeValue), HttpStatus.OK);
        }
        catch (AttributeNotFoundException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.BAD_REQUEST);
        }
        catch (InstanceNotFoundException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.NOT_FOUND);
        }
        catch (MalformedObjectNameException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mbean/operation"})
    public ResponseEntity<?> invoke(@RequestParam(value="resourceName") String resourceName, @RequestParam(value="operationName") String operationName, @RequestParam(value="signature", required=false) String[] signature, @RequestParam(value="parameters", required=false) Object[] parameters) {
        signature = signature != null ? signature : StringUtils.EMPTY_STRING_ARRAY;
        parameters = parameters != null ? parameters : ObjectUtils.EMPTY_OBJECT_ARRAY;
        try {
            Object result = this.getMBeanServer().invoke(ObjectName.getInstance(ShellCommandsController.decode(resourceName)), ShellCommandsController.decode(operationName), parameters, signature);
            return new ResponseEntity((Object)IOUtils.serializeObject((Object)result), HttpStatus.OK);
        }
        catch (InstanceNotFoundException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.NOT_FOUND);
        }
        catch (MalformedObjectNameException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mbean/query"})
    public ResponseEntity<?> queryNames(@RequestBody QueryParameterSource query) {
        try {
            Set<ObjectName> objectNames = this.getMBeanServer().queryNames(query.getObjectName(), query.getQueryExpression());
            return new ResponseEntity((Object)IOUtils.serializeObject(objectNames), HttpStatus.OK);
        }
        catch (IOException e) {
            return new ResponseEntity((Object)ShellCommandsController.printStackTrace(e), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/index"}, produces={"application/xml"})
    @ResponseBody
    public LinkIndex index(@RequestParam(value="scheme", required=false, defaultValue="http") String scheme) {
        return new LinkIndex().add(new Link("status cluster-config-service", this.toUri("/services/cluster-config", scheme))).add(new Link("list members", this.toUri("/members", scheme))).add(new Link("describe member", this.toUri("/members/{name}", scheme))).add(new Link("list regions", this.toUri("/regions", scheme))).add(new Link("describe region", this.toUri("/regions/{name}", scheme))).add(new Link("alter region", this.toUri("/regions/{name}", scheme), HttpMethod.PUT)).add(new Link("create region", this.toUri("/regions", scheme), HttpMethod.POST)).add(new Link("destroy region", this.toUri("/regions/{name}", scheme), HttpMethod.DELETE)).add(new Link("list indexes", this.toUri("/indexes", scheme))).add(new Link("clear defined indexes", this.toUri("/indexes?op=clear-defined", scheme), HttpMethod.DELETE)).add(new Link("create index", this.toUri("/indexes", scheme), HttpMethod.POST)).add(new Link("create defined indexes", this.toUri("/indexes?op=create-defined", scheme), HttpMethod.POST)).add(new Link("define index", this.toUri("/indexes?op=define", scheme), HttpMethod.POST)).add(new Link("destroy index", this.toUri("/indexes", scheme), HttpMethod.DELETE)).add(new Link("destroy index", this.toUri("/indexes/{name}", scheme), HttpMethod.DELETE)).add(new Link("get", this.toUri("/regions/{region}/data", scheme), HttpMethod.GET)).add(new Link("put", this.toUri("/regions/{region}/data", scheme), HttpMethod.PUT)).add(new Link("remove", this.toUri("/regions/{region}/data", scheme), HttpMethod.DELETE)).add(new Link("export data", this.toUri("/members/{member}/regions/{region}/data", scheme), HttpMethod.GET)).add(new Link("import data", this.toUri("/members/{member}/regions/{region}/data", scheme), HttpMethod.POST)).add(new Link("locate entry", this.toUri("/regions/{region}/data/location", scheme), HttpMethod.GET)).add(new Link("query", this.toUri("/regions/data/query", scheme), HttpMethod.GET)).add(new Link("rebalance", this.toUri("/regions/data?op=rebalance", scheme), HttpMethod.POST)).add(new Link("list functions", this.toUri("/functions", scheme))).add(new Link("destroy function", this.toUri("/functions/{id}", scheme), HttpMethod.DELETE)).add(new Link("execute function", this.toUri("/functions/{id}", scheme), HttpMethod.POST)).add(new Link("list clients", this.toUri("/clients", scheme))).add(new Link("describe client", this.toUri("/clients/{clientID}", scheme))).add(new Link("alter runtime", this.toUri("/config", scheme), HttpMethod.POST)).add(new Link("describe config", this.toUri("/members/{member}/config", scheme))).add(new Link("export config", this.toUri("/config", scheme))).add(new Link("export cluster-configuration", this.toUri("/config/cluster", scheme))).add(new Link("import cluster-configuration", this.toUri("/config/cluster", scheme), HttpMethod.POST)).add(new Link("list deployed", this.toUri("/deployed", scheme))).add(new Link("deploy", this.toUri("/deployed", scheme), HttpMethod.POST)).add(new Link("undeploy", this.toUri("/deployed", scheme), HttpMethod.DELETE)).add(new Link("list disk-stores", this.toUri("/diskstores", scheme))).add(new Link("backup disk-store", this.toUri("/diskstores?op=backup", scheme), HttpMethod.POST)).add(new Link("compact disk-store", this.toUri("/diskstores/{name}?op=compact", scheme), HttpMethod.POST)).add(new Link("create disk-store", this.toUri("/diskstores", scheme), HttpMethod.POST)).add(new Link("describe disk-store", this.toUri("/diskstores/{name}", scheme))).add(new Link("destroy disk-store", this.toUri("/diskstores/{name}", scheme), HttpMethod.DELETE)).add(new Link("revoke missing-disk-store", this.toUri("/diskstores/{id}?op=revoke", scheme), HttpMethod.POST)).add(new Link("show missing-disk-stores", this.toUri("/diskstores/missing", scheme))).add(new Link("list durable-cqs", this.toUri("/durable-clients/{durable-client-id}/cqs", scheme))).add(new Link("show subscription-queue-size", this.toUri("/durable-clients/{durable-client-id}/cqs/events", scheme))).add(new Link("show subscription-queue-size", this.toUri("/durable-clients/{durable-client-id}/cqs/{durable-cq-name}/events", scheme))).add(new Link("close durable-client", this.toUri("/durable-clients/{durable-client-id}?op=close", scheme), HttpMethod.POST)).add(new Link("close durable-cq", this.toUri("/durable-clients/{durable-client-id}/cqs/{durable-cq-name}?op=close", scheme), HttpMethod.POST)).add(new Link("status locator", this.toUri("/members/{name}/locator", scheme))).add(new Link("status server", this.toUri("/members/{name}/server", scheme))).add(new Link("change loglevel", this.toUri("/groups/{groups}/loglevel", scheme), HttpMethod.POST)).add(new Link("change loglevel", this.toUri("/members/{members}/loglevel", scheme), HttpMethod.POST)).add(new Link("change loglevel", this.toUri("/members/{members}/groups/{groups}/loglevel", scheme), HttpMethod.POST)).add(new Link("export logs", this.toUri("/logs", scheme))).add(new Link("export stack-traces", this.toUri("/stacktraces", scheme))).add(new Link("gc", this.toUri("/gc", scheme), HttpMethod.POST)).add(new Link("gc", this.toUri("/members/{member}/gc", scheme), HttpMethod.POST)).add(new Link("netstat", this.toUri("/netstat", scheme))).add(new Link("show dead-locks", this.toUri("/deadlocks", scheme))).add(new Link("show log", this.toUri("/members/{member}/log", scheme))).add(new Link("show metrics", this.toUri("/metrics", scheme))).add(new Link("shutdown", this.toUri("/shutdown", scheme), HttpMethod.POST)).add(new Link("create async-event-queue", this.toUri("/async-event-queues", scheme), HttpMethod.POST)).add(new Link("list async-event-queues", this.toUri("/async-event-queues", scheme))).add(new Link("configure pdx", this.toUri("/pdx", scheme), HttpMethod.POST)).add(new Link("pdx rename", this.toUri("/pdx/type", scheme), HttpMethod.POST)).add(new Link(MBEAN_ATTRIBUTE_LINK_RELATION, this.toUri("/mbean/attribute", scheme))).add(new Link(MBEAN_OPERATION_LINK_RELATION, this.toUri("/mbean/operation", scheme), HttpMethod.POST)).add(new Link(MBEAN_QUERY_LINK_RELATION, this.toUri("/mbean/query", scheme), HttpMethod.POST)).add(new Link(PING_LINK_RELATION, this.toUri("/ping", scheme), HttpMethod.GET)).add(new Link("version", this.toUri("/version", scheme))).add(new Link("list gateways", this.toUri("/gateways", scheme))).add(new Link("create gateway-receiver", this.toUri("/gateways/receivers", scheme), HttpMethod.POST)).add(new Link("create gateway-sender", this.toUri("/gateways/senders", scheme), HttpMethod.POST)).add(new Link("load-balance gateway-sender", this.toUri("/gateways/senders/{id}?op=load-balance", scheme), HttpMethod.POST)).add(new Link("pause gateway-sender", this.toUri("/gateways/senders/{id}?op=pause", scheme), HttpMethod.POST)).add(new Link("resume gateway-sender", this.toUri("/gateways/senders/{id}?op=resume", scheme), HttpMethod.POST)).add(new Link("start gateway-receiver", this.toUri("/gateways/receivers?op=start", scheme), HttpMethod.POST)).add(new Link("start gateway-sender", this.toUri("/gateways/senders?op=start", scheme), HttpMethod.POST)).add(new Link("status gateway-receiver", this.toUri("/gateways/receivers", scheme))).add(new Link("status gateway-sender", this.toUri("/gateways/senders/{id}", scheme))).add(new Link("stop gateway-receiver", this.toUri("/gateways/receivers?op=stop", scheme), HttpMethod.POST)).add(new Link("stop gateway-sender", this.toUri("/gateways/senders/{id}?op=stop", scheme), HttpMethod.POST));
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.HEAD}, value={"/ping"})
    public ResponseEntity<String> ping() {
        return new ResponseEntity((Object)"<html><body><h1>Mischief Managed!</h1></body></html>", HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/version"})
    @ResponseBody
    public String version() {
        return GemFireVersion.getProductName().concat("/").concat(GemFireVersion.getGemFireVersion());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/version/full"})
    @ResponseBody
    public String versionSimple() {
        return GemFireVersion.asString();
    }
}

