/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.web.controllers;

import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.util.CommandStringBuilder;
import org.apache.geode.management.internal.web.controllers.support.LoginHandlerInterceptor;
import org.apache.geode.management.internal.web.util.UriUtils;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractCommandsController {
    private static final Logger logger = LogService.getLogger();
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String REST_API_VERSION = "/v1";
    private MemberMXBean managingMemberMXBeanProxy;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();
    private Class accessControlKlass;

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED, reason="Not authenticated")
    @ExceptionHandler(value={AuthenticationFailedException.class})
    public void authenticate() {
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Access Denied")
    @ExceptionHandler(value={SecurityException.class})
    public void authorize() {
    }

    protected static void assertArgument(boolean validArg, String message, Object ... args) {
        if (!validArg) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    protected static void assertNotNull(Object obj, String message, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(message, args));
        }
    }

    protected static void assertState(boolean validState, String message, Object ... args) {
        if (!validState) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    protected static String decode(String encodedValue) {
        return UriUtils.decode(encodedValue);
    }

    protected static String decode(String encodedValue, String encoding) {
        return UriUtils.decode(encodedValue, encoding);
    }

    protected static String defaultIfNoValue(String value, String defaultValue) {
        return AbstractCommandsController.hasValue(value) ? value : defaultValue;
    }

    protected static String encode(String value) {
        return UriUtils.encode(value);
    }

    protected static String encode(String value, String encoding) {
        return UriUtils.encode(value, encoding);
    }

    protected static boolean hasValue(Object value) {
        return value instanceof String[] ? AbstractCommandsController.hasValue((String[])value) : (value instanceof String ? AbstractCommandsController.hasValue((String)value) : value != null);
    }

    protected static boolean hasValue(String value) {
        return !StringUtils.isBlank((String)value);
    }

    protected static boolean hasValue(String[] array) {
        if (array != null && array.length > 0) {
            for (String element : array) {
                if (!AbstractCommandsController.hasValue(element)) continue;
                return true;
            }
        }
        return false;
    }

    protected static String printStackTrace(Throwable t) {
        StringWriter stackTraceWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTraceWriter));
        return stackTraceWriter.toString();
    }

    protected URI toUri(String path, String scheme) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path(REST_API_VERSION).path(path).scheme(scheme).build().toUri();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<String> handleException(Exception cause) {
        String stackTrace = AbstractCommandsController.printStackTrace(cause);
        logger.fatal(stackTrace);
        return new ResponseEntity((Object)stackTrace, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(String[].class, (PropertyEditor)new StringArrayPropertyEditor(",", false));
    }

    protected void logRequest(WebRequest request) {
        if (request != null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            Iterator it = request.getHeaderNames();
            while (it.hasNext()) {
                String headerName = (String)it.next();
                headers.put(headerName, ArrayUtils.toString((Object[])request.getHeaderValues(headerName)));
            }
            HashMap<String, String> parameters = new HashMap<String, String>(request.getParameterMap().size());
            Iterator it2 = request.getParameterNames();
            while (it2.hasNext()) {
                String parameterName = (String)it2.next();
                parameters.put(parameterName, ArrayUtils.toString((Object[])request.getParameterValues(parameterName)));
            }
            logger.info("HTTP-request: description ({}), context ({}), headers ({}), parameters ({})", (Object)request.getDescription(false), (Object)request.getContextPath(), headers, parameters);
        }
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected MemberMXBean getMemberMXBean(String memberNameId) {
        try {
            MBeanServer connection = this.getMBeanServer();
            String objectNamePattern = "GemFire:".concat("type=Member,*");
            ObjectName objectName = ObjectName.getInstance(objectNamePattern);
            QueryExp query = Query.or(Query.eq(Query.attr("Name"), Query.value(memberNameId)), Query.eq(Query.attr("Id"), Query.value(memberNameId)));
            Set<ObjectName> objectNames = connection.queryNames(objectName, query);
            AbstractCommandsController.assertState(this.isMemberMXBeanFound(objectNames), "No MemberMXBean with ObjectName (%1$s) based on Query (%2$s) was found in the Platform MBeanServer for member (%3$s)!", objectName, query, memberNameId);
            return JMX.newMXBeanProxy(connection, objectNames.iterator().next(), MemberMXBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isMemberMXBeanFound(Collection<ObjectName> objectNames) {
        return objectNames != null && !objectNames.isEmpty();
    }

    protected synchronized MemberMXBean getManagingMemberMXBean() {
        if (this.managingMemberMXBeanProxy == null) {
            SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService((Cache)GemFireCacheImpl.getInstance());
            MBeanServer mbs = this.getMBeanServer();
            DistributedSystemMXBean distributedSystemMXBean = JMX.newMXBeanProxy(mbs, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
            this.managingMemberMXBeanProxy = this.createMemberMXBeanForManagerUsingProxy(mbs, distributedSystemMXBean.getMemberObjectName());
        }
        return this.managingMemberMXBeanProxy;
    }

    protected synchronized ObjectName getMemberObjectName() {
        MBeanServer platformMBeanServer = this.getMBeanServer();
        DistributedSystemMXBean distributedSystemMXBean = JMX.newMXBeanProxy(platformMBeanServer, MBeanJMXAdapter.getDistributedSystemName(), DistributedSystemMXBean.class);
        return distributedSystemMXBean.getMemberObjectName();
    }

    private MemberMXBean createMemberMXBeanForManagerUsingProxy(MBeanServer server, ObjectName managingMemberObjectName) {
        return JMX.newMXBeanProxy(server, managingMemberObjectName, MemberMXBean.class);
    }

    protected Map<String, String> getEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.putAll(LoginHandlerInterceptor.getEnvironment());
        environment.put("APP_NAME", "gfsh");
        return environment;
    }

    protected void addCommandOption(WebRequest request, CommandStringBuilder command, String optionName, Object optionValue) {
        AbstractCommandsController.assertNotNull(command, "The command to append options to cannot be null!", new Object[0]);
        AbstractCommandsController.assertNotNull(optionName, "The name of the option to add to the command cannot be null!", new Object[0]);
        if (AbstractCommandsController.hasValue(optionValue)) {
            String optionValueString = optionValue instanceof String[] ? StringUtils.concat((Object[])((String[])optionValue), (String)",") : String.valueOf(optionValue);
            command.addOption(optionName, optionValueString);
        } else if (request != null && request.getParameterMap().containsKey(optionName)) {
            command.addOption(optionName);
        }
    }

    protected String processCommand(String command) {
        return this.processCommand(command, this.getEnvironment(), null);
    }

    protected Callable<ResponseEntity<String>> getProcessCommandCallable(String command) {
        return this.getProcessCommandCallable(command, this.getEnvironment(), null);
    }

    protected Callable<ResponseEntity<String>> getProcessCommandCallable(final String command, final Map<String, String> environment, final byte[][] fileData) {
        Callable<ResponseEntity<String>> callable = new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                String result = null;
                try {
                    result = AbstractCommandsController.this.processCommand(command, environment, fileData);
                }
                catch (NotAuthorizedException ex) {
                    return new ResponseEntity((Object)ex.getMessage(), HttpStatus.FORBIDDEN);
                }
                catch (Exception ex) {
                    return new ResponseEntity((Object)ex.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return new ResponseEntity((Object)result, HttpStatus.OK);
            }
        };
        return this.securityService.associateWith((Callable)callable);
    }

    protected String processCommand(String command, byte[][] fileData) {
        return this.processCommand(command, this.getEnvironment(), fileData);
    }

    protected String processCommand(String command, Map<String, String> environment) {
        return this.processCommand(command, environment, null);
    }

    protected String processCommand(String command, Map<String, String> environment, byte[][] fileData) {
        logger.info(LogMarker.CONFIG, "Processing Command ({}) with Environment ({}) having File Data ({})...", (Object)command, environment, (Object)(fileData != null ? 1 : 0));
        return this.getManagingMemberMXBean().processCommand(command, environment, ArrayUtils.toByteArray((byte[][])fileData));
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    public ResponseEntity<String> handleAppException(NotAuthorizedException ex) {
        return new ResponseEntity((Object)ex.getMessage(), HttpStatus.FORBIDDEN);
    }
}

