/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HMGetExecutor
extends HashExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HMGET command is \"HMGET key field [field ...]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        this.checkDataType(key, RedisDataType.REDIS_HASH, context);
        if (keyRegion == null) {
            command.setResponse(Coder.getArrayOfNils(context.getByteBufAllocator(), commandElems.size() - 2));
            return;
        }
        ArrayList<ByteArrayWrapper> fields = new ArrayList<ByteArrayWrapper>();
        for (int i = 2; i < commandElems.size(); ++i) {
            byte[] fieldArray = commandElems.get(i);
            ByteArrayWrapper field = new ByteArrayWrapper(fieldArray);
            fields.add(field);
        }
        Map<ByteArrayWrapper, ByteArrayWrapper> results = keyRegion.getAll(fields);
        ArrayList<ByteArrayWrapper> values = new ArrayList<ByteArrayWrapper>();
        for (ByteArrayWrapper field : fields) {
            values.add(results.get(field));
        }
        command.setResponse(Coder.getBulkStringArrayResponse(context.getByteBufAllocator(), values));
    }
}

