/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.Version;

public class EnumId
implements DataSerializableFixedID {
    private int id;

    public EnumId(int id) {
        this.id = id;
    }

    public EnumId() {
    }

    @Override
    public int getDSFID() {
        return 8;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.id);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
    }

    public int intValue() {
        return this.id;
    }

    public int getDSId() {
        return this.id >> 24;
    }

    public int getEnumNum() {
        return this.id & 0xFFFFFF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumId other = (EnumId)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "EnumId[dsid=" + this.getDSId() + ", enumnum=" + this.getEnumNum() + "]";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

