/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipUtils {
    public static void zip(String sourceFolderPath, String targetFilePath) throws Exception {
        File sourceFolder = new File(sourceFolderPath);
        File targetFile = new File(targetFilePath);
        if (!sourceFolder.exists()) {
            throw new Exception("Source folder does not exist");
        }
        FileOutputStream fos = new FileOutputStream(targetFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        URI baseURI = sourceFolder.toURI();
        Stack<File> fileStack = new Stack<File>();
        fileStack.push(sourceFolder);
        while (!fileStack.isEmpty()) {
            File directory = (File)fileStack.pop();
            for (File child : directory.listFiles()) {
                String name = baseURI.relativize(child.toURI()).getPath();
                if (child.isDirectory()) {
                    fileStack.push(child);
                    zos.putNextEntry(new ZipEntry(name));
                    continue;
                }
                if (name.endsWith("zip")) continue;
                ZipEntry zipEntry = new ZipEntry(name);
                zos.putNextEntry(zipEntry);
                FileInputStream in = new FileInputStream(child);
                IOUtils.copy((InputStream)in, (OutputStream)zos);
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        IOUtils.closeQuietly((OutputStream)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String outputFolderPath) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        try {
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                String fileName = outputFolderPath + File.separator + zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)new File(fileName));
                    continue;
                }
                File entryDestination = new File(fileName);
                File parent = entryDestination.getParentFile();
                if (parent != null) {
                    FileUtils.forceMkdir((File)parent);
                }
                if (entryDestination.createNewFile()) {
                    InputStream in = zipFile.getInputStream(zipEntry);
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                        IOUtils.closeQuietly((OutputStream)out);
                        continue;
                    }
                }
                throw new IOException("Cannot create file :" + entryDestination.getCanonicalPath());
            }
        }
        finally {
            zipFile.close();
        }
    }
}

