/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.management.internal.cli.GfshParser;

public class ReadWriteFile {
    public static void main(String[] args) {
        if (args.length < 6 || args.length > 6) {
            throw new IllegalArgumentException("Requires only 6  arguments : <logInputFileName> <logOutputFileName> <LogLevel> <UptoLogLevel> <StartTime> <EndTime>");
        }
        String result = ReadWriteFile.readWriteFile(args[0], args[1], args[2], args[3], args[4], args[5]);
        System.out.println(result);
    }

    public static String readWriteFile(String logFileName, String logToBeWritten, String logLevel, String onlyLogLevel, String startTime, String endTime) {
        try {
            long lineCount = 0L;
            BufferedReader input = null;
            BufferedWriter output = null;
            File logFileNameFile = new File(logFileName);
            if (!logFileNameFile.canRead()) {
                return "Cannot read logFileName=" + logFileName;
            }
            input = new BufferedReader(new FileReader(logFileName));
            String line = null;
            File logToBeWrittenToFile = new File(logToBeWritten);
            output = new BufferedWriter(new FileWriter(logToBeWrittenToFile));
            if (!logToBeWrittenToFile.exists()) {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                return logToBeWritten + " doesn not exist";
            }
            if (!logToBeWrittenToFile.isFile()) {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                return logToBeWritten + " is not a file";
            }
            if (!logToBeWrittenToFile.canWrite()) {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.flush();
                    output.close();
                }
                return "can not write file " + logToBeWritten;
            }
            ArrayList<String> logLevels = new ArrayList<String>();
            if (onlyLogLevel.toLowerCase().equals("false")) {
                int[] intLogLevels;
                for (int level : intLogLevels = LogWriterImpl.allLevels) {
                    if (level < LogWriterImpl.levelNameToCode(logLevel)) continue;
                    logLevels.add(LogWriterImpl.levelToString(level).toLowerCase());
                }
            } else {
                logLevels.add(logLevel);
            }
            boolean timeRangeCheck = false;
            boolean foundLogLevelTag = false;
            boolean validateLogLevel = true;
            while (input.ready() && (line = input.readLine()) != null) {
                if (!new File(logFileName).canRead()) {
                    return "Cannot read logFileName=" + logFileName;
                }
                ++lineCount;
                foundLogLevelTag = line.startsWith("[");
                if (line.contains("[info ") && !timeRangeCheck) {
                    String stTime = "";
                    int spaceCounter = 0;
                    for (int i = line.indexOf("[info ") + 6; i < line.length(); ++i) {
                        if (line.charAt(i) == ' ') {
                            ++spaceCounter;
                        }
                        if (spaceCounter > 2) break;
                        stTime = stTime + line.charAt(i);
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    Date d = df.parse(stTime.substring(0, stTime.length() - 4));
                    Time fileStartTime = new Time(d.getTime());
                    File inputFile = new File(logFileName);
                    Time fileEndTime = new Time(inputFile.lastModified());
                    Time longStart = new Time(Long.valueOf(startTime));
                    Time longEnd = new Time(Long.valueOf(endTime));
                    long userStartTime = longStart.getTime();
                    long userEndTime = longEnd.getTime();
                    if (!(fileStartTime.getTime() >= userStartTime && fileStartTime.getTime() <= userEndTime || fileEndTime.getTime() >= userStartTime && fileEndTime.getTime() <= userEndTime) && (fileStartTime.getTime() < userStartTime || fileStartTime.getTime() > userEndTime || fileEndTime.getTime() < userStartTime || fileEndTime.getTime() > userEndTime)) break;
                    timeRangeCheck = true;
                }
                if (foundLogLevelTag) {
                    validateLogLevel = ReadWriteFile.checkLogLevel(line, logLevel, logLevels, foundLogLevelTag);
                }
                if (!validateLogLevel) continue;
                output.append(line);
                output.newLine();
                if (lineCount % 1000L != 0L) continue;
                output.flush();
            }
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.flush();
                output.close();
            }
            return "Sucessfully written file " + logFileName;
        }
        catch (FunctionException ex) {
            return "readWriteFile FunctionException " + ex.getMessage();
        }
        catch (FileNotFoundException ex) {
            return "readWriteFile FileNotFoundException " + ex.getMessage();
        }
        catch (IOException ex) {
            return "readWriteFile FileNotFoundException " + ex.getMessage();
        }
        catch (Exception ex) {
            return "readWriteFile Exception " + ex.getMessage();
        }
    }

    static boolean checkLogLevel(String line, String logLevel, List<String> logLevels, boolean foundLogLevelTag) {
        if (line == null) {
            return false;
        }
        if (line != null && foundLogLevelTag) {
            if (logLevel.toLowerCase().equals("all")) {
                return true;
            }
            if (line.equals(GfshParser.LINE_SEPARATOR)) {
                return true;
            }
            if (logLevels.size() > 0) {
                for (String permittedLogLevel : logLevels) {
                    boolean flag;
                    int indexFrom = line.indexOf(91);
                    int indexTo = line.indexOf(32);
                    if (indexFrom <= -1 || indexTo <= -1 || indexTo <= indexFrom || !(flag = line.substring(indexFrom + 1, indexTo).toLowerCase().contains(permittedLogLevel))) continue;
                    return flag;
                }
                return false;
            }
            return true;
        }
        return true;
    }
}

