/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.geode.internal.logging.MergeLogFiles;

public class MergeLogs {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 1) {
            throw new IllegalArgumentException("Requires only 1  arguments : <targetDirName>");
        }
        try {
            String result = MergeLogs.mergeLogFile(args[0]);
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    static String mergeLogFile(String dirName) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        File dir = new File(dirName);
        String[] logsToMerge = dir.list();
        InputStream[] logFiles = new FileInputStream[logsToMerge.length];
        String[] logFileNames = new String[logFiles.length];
        for (int i = 0; i < logsToMerge.length; ++i) {
            try {
                logFiles[i] = new FileInputStream(dirName + File.separator + logsToMerge[i]);
                logFileNames[i] = dirName + File.separator + logsToMerge[i];
                continue;
            }
            catch (FileNotFoundException e) {
                throw new Exception(logsToMerge[i] + " " + "Does not exist");
            }
        }
        PrintWriter mergedLog = null;
        try {
            String mergeLog = dirName + File.separator + "merge_" + sdf.format(new Date()) + ".log";
            mergedLog = new PrintWriter(mergeLog);
            boolean bl = MergeLogFiles.mergeLogFiles(logFiles, logFileNames, mergedLog);
        }
        catch (FileNotFoundException e) {
            throw new Exception("FileNotFoundException in creating PrintWriter in MergeLogFiles" + e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("Exception in creating PrintWriter in MergeLogFiles" + e.getMessage());
        }
        return "Sucessfully merged logs";
    }
}

