/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell.unsafe;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.apache.geode.internal.process.signal.AbstractSignalNotificationHandler;
import org.apache.geode.internal.process.signal.Signal;
import org.apache.geode.internal.process.signal.SignalEvent;
import sun.misc.SignalHandler;

public class GfshSignalHandler
extends AbstractSignalNotificationHandler
implements SignalHandler {
    private final Map<Signal, SignalHandler> originalSignalHandlers = Collections.synchronizedMap(new Hashtable(Signal.values().length));

    public GfshSignalHandler() {
        for (Signal signal : Signal.values()) {
            if (!Signal.SIGINT.equals((Object)signal)) continue;
            this.originalSignalHandlers.put(signal, sun.misc.Signal.handle(new sun.misc.Signal(signal.getName()), this));
        }
    }

    @Override
    public void handle(sun.misc.Signal sig) {
        this.notifyListeners(new SignalEvent(sig, Signal.valueOfName(sig.getName())));
        this.handleDefault(sig);
    }

    protected void handleDefault(sun.misc.Signal sig) {
        Signal signal = Signal.valueOfName(sig.getName());
        switch (signal) {
            case SIGINT: {
                break;
            }
            default: {
                SignalHandler handler = this.getOriginalSignalHandler(signal);
                if (handler == null) break;
                handler.handle(sig);
            }
        }
    }

    protected SignalHandler getOriginalSignalHandler(Signal signal) {
        SignalHandler handler = this.originalSignalHandlers.get((Object)signal);
        return handler == SignalHandler.SIG_DFL || handler == SignalHandler.SIG_IGN ? null : handler;
    }
}

