/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.io.IOException;
import java.util.Map;
import org.apache.geode.cache.Cache;
import org.apache.geode.management.cli.CommandService;
import org.apache.geode.management.cli.CommandServiceException;
import org.apache.geode.management.cli.CommandStatement;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.remote.CommandProcessor;

public class MemberCommandService
extends CommandService {
    private final Object modLock = new Object();
    private Cache cache;
    private CommandProcessor commandProcessor;

    public MemberCommandService(Cache cache) throws CommandServiceException {
        this.cache = cache;
        try {
            this.commandProcessor = new CommandProcessor(cache.getDistributedSystem().getProperties());
        }
        catch (ClassNotFoundException e) {
            throw new CommandServiceException("Could not load commands.", e);
        }
        catch (IOException e) {
            throw new CommandServiceException("Could not load commands.", e);
        }
        catch (IllegalStateException e) {
            throw new CommandServiceException(e.getMessage(), e);
        }
    }

    @Override
    public Result processCommand(String commandString) {
        return this.processCommand(commandString, EMPTY_ENV);
    }

    @Override
    public Result processCommand(String commandString, Map<String, String> env) {
        return this.createCommandStatement(commandString, env).process();
    }

    @Override
    public CommandStatement createCommandStatement(String commandString) {
        return this.createCommandStatement(commandString, EMPTY_ENV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandStatement createCommandStatement(String commandString, Map<String, String> env) {
        if (!this.isUsable()) {
            throw new IllegalStateException("Cache instance is not available.");
        }
        Object object = this.modLock;
        synchronized (object) {
            return this.commandProcessor.createCommandStatement(commandString, env);
        }
    }

    @Override
    public boolean isUsable() {
        return this.cache != null && !this.cache.isClosed();
    }
}

