/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.parser;

import java.lang.reflect.Method;
import org.apache.geode.management.cli.CliMetaData;

public class AvailabilityTarget {
    private final Object target;
    private final Method method;
    private final String availabilityDescription;

    public AvailabilityTarget(Object target, Method method) {
        this.target = target;
        this.method = method;
        CliMetaData.AvailabilityMetadata availabilityMetadata = this.method.getAnnotation(CliMetaData.AvailabilityMetadata.class);
        String specifiedAvailabilityDesc = "Requires connection.";
        if (availabilityMetadata != null) {
            specifiedAvailabilityDesc = availabilityMetadata.availabilityDescription();
        }
        this.availabilityDescription = specifiedAvailabilityDesc;
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAvailabilityDescription() {
        return this.availabilityDescription;
    }

    public int hashCode() {
        int prime = 17;
        int result = 8;
        result = 17 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 17 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvailabilityTarget availabilityTarget = (AvailabilityTarget)obj;
        if (this.target == null ? availabilityTarget.getTarget() != null : !this.target.equals(availabilityTarget.getTarget())) {
            return false;
        }
        return !(this.method == null ? availabilityTarget.getMethod() != null : !this.method.equals(availabilityTarget.getMethod()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(AvailabilityTarget.class.getSimpleName());
        builder.append("[target=" + this.target);
        builder.append(",method=" + this.method);
        builder.append("]");
        return builder.toString();
    }
}

