/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.util.RegionPath;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class RegionAlterFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4846425364943216425L;

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public void execute(FunctionContext context) {
        ResultSender<CliFunctionResult> resultSender = context.getResultSender();
        Cache cache = CacheFactory.getAnyInstance();
        String memberNameOrId = CliUtil.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        RegionFunctionArgs regionAlterArgs = (RegionFunctionArgs)context.getArguments();
        try {
            Region<?, ?> alteredRegion = this.alterRegion(cache, regionAlterArgs);
            XmlEntity xmlEntity = new XmlEntity("region", "name", alteredRegion.getName());
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, xmlEntity, CliStrings.format("Region \"{0}\" altered on \"{1}\"", alteredRegion.getFullPath(), memberNameOrId)));
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, e.getMessage()));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error(th.getMessage(), th);
            String exceptionMsg = th.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = CliUtil.stackTraceAsString(th);
            }
            resultSender.lastResult(new CliFunctionResult(memberNameOrId, false, exceptionMsg));
        }
    }

    private <K, V> Region<?, ?> alterRegion(Cache cache, RegionFunctionArgs regionAlterArgs) {
        String string;
        String string2;
        Set<String> newCacheListenerNames;
        Set<String> newAsyncEventQueueIds;
        Set<String> newGatewaySenderIds;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newRegionExpirationIdleTime;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationTTL;
        RegionFunctionArgs.ExpirationAttrs newEntryExpirationIdleTime;
        String regionPathString = regionAlterArgs.getRegionPath();
        RegionPath regionPath = new RegionPath(regionPathString);
        AbstractRegion region = (AbstractRegion)cache.getRegion(regionPathString);
        if (region == null) {
            throw new IllegalArgumentException(CliStrings.format("Region doesn't exist: {0}", new Object[]{regionPath}));
        }
        AttributesMutator mutator = region.getAttributesMutator();
        if (regionAlterArgs.isCloningEnabled() != null) {
            mutator.setCloningEnabled(regionAlterArgs.isCloningEnabled());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cloning");
            }
        }
        if (regionAlterArgs.getEvictionMax() != null) {
            mutator.getEvictionAttributesMutator().setMaximum(regionAlterArgs.getEvictionMax());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - eviction attributes max");
            }
        }
        if ((newEntryExpirationIdleTime = regionAlterArgs.getEntryExpirationIdleTime()) != null) {
            mutator.setEntryIdleTimeout(this.parseExpirationAttributes(newEntryExpirationIdleTime, region.getEntryIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry idle timeout");
            }
        }
        if ((newEntryExpirationTTL = regionAlterArgs.getEntryExpirationTTL()) != null) {
            mutator.setEntryTimeToLive(this.parseExpirationAttributes(newEntryExpirationTTL, region.getEntryTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - entry TTL");
            }
        }
        if ((newRegionExpirationIdleTime = regionAlterArgs.getRegionExpirationIdleTime()) != null) {
            mutator.setRegionIdleTimeout(this.parseExpirationAttributes(newRegionExpirationIdleTime, region.getRegionIdleTimeout()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region idle timeout");
            }
        }
        if ((newRegionExpirationTTL = regionAlterArgs.getRegionExpirationTTL()) != null) {
            mutator.setRegionTimeToLive(this.parseExpirationAttributes(newRegionExpirationTTL, region.getRegionTimeToLive()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - region TTL");
            }
        }
        if ((newGatewaySenderIds = regionAlterArgs.getGatewaySenderIds()) != null) {
            Set<String> oldGatewaySenderIds = region.getGatewaySenderIds();
            if (!oldGatewaySenderIds.isEmpty()) {
                for (String string3 : oldGatewaySenderIds) {
                    if (newGatewaySenderIds.contains(string3)) continue;
                    mutator.removeGatewaySenderId(string3);
                }
            }
            for (String string4 : newGatewaySenderIds) {
                if (oldGatewaySenderIds.contains(string4)) continue;
                mutator.addGatewaySenderId(string4);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - gateway sender IDs");
            }
        }
        if ((newAsyncEventQueueIds = regionAlterArgs.getAsyncEventQueueIds()) != null) {
            Set<String> oldAsyncEventQueueIds = region.getAsyncEventQueueIds();
            if (!oldAsyncEventQueueIds.isEmpty()) {
                for (String string5 : oldAsyncEventQueueIds) {
                    if (newAsyncEventQueueIds.contains(string5)) continue;
                    mutator.removeAsyncEventQueueId(string5);
                }
            }
            for (String string6 : newAsyncEventQueueIds) {
                if (oldAsyncEventQueueIds.contains(string6)) continue;
                mutator.addAsyncEventQueueId(string6);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - async event queue IDs");
            }
        }
        if ((newCacheListenerNames = regionAlterArgs.getCacheListeners()) != null) {
            CacheListener[] cacheListenerArray;
            for (CacheListener cacheListener : cacheListenerArray = region.getCacheListeners()) {
                if (newCacheListenerNames.contains(cacheListener.getClass().getName())) continue;
                mutator.removeCacheListener(cacheListener);
            }
            for (String newCacheListenerName : newCacheListenerNames) {
                boolean nameFound = false;
                for (CacheListener oldCacheListener : cacheListenerArray) {
                    if (!oldCacheListener.getClass().getName().equals(newCacheListenerName)) continue;
                    nameFound = true;
                    break;
                }
                if (nameFound) continue;
                Class<K> clazz = RegionAlterFunction.forName(newCacheListenerName, "cache-listener");
                mutator.addCacheListener((CacheListener)RegionAlterFunction.newInstance(clazz, "cache-listener"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache listeners");
            }
        }
        if ((string2 = regionAlterArgs.getCacheLoader()) != null) {
            if (string2.isEmpty()) {
                mutator.setCacheLoader(null);
            } else {
                Class<K> clazz = RegionAlterFunction.forName(string2, "cache-loader");
                mutator.setCacheLoader((CacheLoader)RegionAlterFunction.newInstance(clazz, "cache-loader"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache loader");
            }
        }
        if ((string = regionAlterArgs.getCacheWriter()) != null) {
            if (string.isEmpty()) {
                mutator.setCacheWriter(null);
            } else {
                Class<K> cacheWriterKlass = RegionAlterFunction.forName(string, "cache-writer");
                mutator.setCacheWriter((CacheWriter)RegionAlterFunction.newInstance(cacheWriterKlass, "cache-writer"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache writer");
            }
        }
        return region;
    }

    private ExpirationAttributes parseExpirationAttributes(RegionFunctionArgs.ExpirationAttrs newExpirationAttrs, ExpirationAttributes oldExpirationAttributes) {
        ExpirationAction action = oldExpirationAttributes.getAction();
        int timeout = oldExpirationAttributes.getTimeout();
        if (newExpirationAttrs.getTime() != null) {
            timeout = newExpirationAttrs.getTime();
        }
        if (newExpirationAttrs.getAction() != null) {
            action = newExpirationAttrs.getAction();
        }
        return new ExpirationAttributes(timeout, action);
    }

    private static <K> Class<K> forName(String classToLoadName, String neededFor) {
        Class<?> loadedClass = null;
        try {
            ClassPathLoader classPathLoader = ClassPathLoader.getLatest();
            if (classToLoadName != null && !classToLoadName.isEmpty()) {
                loadedClass = classPathLoader.forName(classToLoadName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", classToLoadName, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", classToLoadName, neededFor), e);
        }
        return loadedClass;
    }

    private static <K> K newInstance(Class<K> klass, String neededFor) {
        K instance = null;
        try {
            instance = klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        return instance;
    }

    @Override
    public String getId() {
        return RegionAlterFunction.class.getName();
    }
}

