/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;

public class ListDiskStoresFunction
extends FunctionAdapter
implements InternalEntity {
    public void init(Properties props) {
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    @Override
    public void execute(FunctionContext context) {
        HashSet<DiskStoreDetails> memberDiskStores = new HashSet<DiskStoreDetails>();
        try {
            Cache cache = this.getCache();
            if (cache instanceof InternalCache) {
                InternalCache gemfireCache = (InternalCache)cache;
                DistributedMember member = gemfireCache.getMyId();
                for (DiskStore diskStore : gemfireCache.listDiskStoresIncludingRegionOwned()) {
                    memberDiskStores.add(new DiskStoreDetails(diskStore.getDiskStoreUUID(), diskStore.getName(), member.getId(), member.getName()));
                }
            }
            context.getResultSender().lastResult(memberDiskStores);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }
}

