/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.RegionDescriptionPerMember;

public class GetRegionDescriptionFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String regionPath = (String)context.getArguments();
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Region region = cache.getRegion(regionPath);
            if (region != null) {
                String memberName = cache.getDistributedSystem().getDistributedMember().getName();
                RegionDescriptionPerMember regionDescription = new RegionDescriptionPerMember(region, memberName);
                context.getResultSender().lastResult(regionDescription);
            } else {
                context.getResultSender().lastResult(null);
            }
        }
        catch (CacheClosedException e) {
            context.getResultSender().sendException(e);
        }
        catch (Exception e) {
            context.getResultSender().sendException(e);
        }
    }

    @Override
    public String getId() {
        return GetRegionDescriptionFunction.class.toString();
    }
}

