/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;

public class FetchSharedConfigurationStatusFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
        SharedConfigurationStatus status = locator.getSharedConfigurationStatus().getStatus();
        String memberId = member.getName();
        if (StringUtils.isBlank(memberId)) {
            memberId = member.getId();
        }
        CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{status.name()});
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return FetchSharedConfigurationStatusFunction.class.getName();
    }
}

