/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.SharedConfiguration;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;

public class ExportSharedConfigurationFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        InternalLocator locator = InternalLocator.getLocator();
        String memberName = locator.getDistributedSystem().getName();
        if (locator.isSharedConfigurationRunning()) {
            SharedConfiguration sc = locator.getSharedConfiguration();
            String zipFileName = CliStrings.format("cluster-config-{0}.zip", (Object)UUID.randomUUID());
            String targetFilePath = FilenameUtils.concat((String)sc.getSharedConfigurationDirPath(), (String)zipFileName);
            try {
                ZipUtils.zip(sc.getSharedConfigurationDirPath(), targetFilePath);
                File zippedSharedConfig = new File(targetFilePath);
                byte[] zippedConfigData = FileUtils.readFileToByteArray((File)zippedSharedConfig);
                FileUtils.forceDelete((File)zippedSharedConfig);
                CliFunctionResult result = new CliFunctionResult(locator.getDistributedSystem().getName(), zippedConfigData, (Serializable[])new String[]{zipFileName});
                context.getResultSender().lastResult(result);
            }
            catch (Exception e) {
                context.getResultSender().lastResult(new CliFunctionResult(memberName, e, e.getMessage()));
            }
        } else {
            CliFunctionResult result = new CliFunctionResult(memberName, false, "Cluster configuration service is enabled but has not started yet.");
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ExportSharedConfigurationFunction.class.getName();
    }
}

