/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class CreateIndexFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        IndexInfo indexInfo = (IndexInfo)context.getArguments();
        String memberId = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getIndexName();
            String indexedExpression = indexInfo.getIndexedExpression();
            String fromClause = indexInfo.getRegionPath();
            String[] regionPathTokens = fromClause.trim().split(" ");
            String regionPath = regionPathTokens[0];
            switch (indexInfo.getIndexType()) {
                case 1: {
                    queryService.createIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                case 2: {
                    queryService.createKeyIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                case 3: {
                    queryService.createHashIndex(indexName, indexedExpression, fromClause);
                    break;
                }
                default: {
                    queryService.createIndex(indexName, indexedExpression, fromClause);
                }
            }
            XmlEntity xmlEntity = new XmlEntity("region", "name", cache.getRegion(regionPath).getName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity));
        }
        catch (IndexExistsException e) {
            String message = CliStrings.format("Index \"{0}\" already exists.  Create failed due to duplicate definition.", (Object)indexInfo.getIndexName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (IndexNameConflictException e) {
            String message = CliStrings.format("Index \"{0}\" already exists.  Create failed due to duplicate name.", (Object)indexInfo.getIndexName());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (RegionNotFoundException e) {
            String message = CliStrings.format("Region not found : \"{0}\"", (Object)indexInfo.getRegionPath());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, message));
        }
        catch (IndexInvalidException e) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format("Exception : {0} , Message : {1}", e.getClass().getName(), e.getMessage());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, e, e.getMessage()));
        }
    }

    @Override
    public String getId() {
        return CreateIndexFunction.class.getName();
    }
}

