/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.Properties;
import joptsimple.internal.Strings;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.execute.FunctionAdapter;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.AsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateDiskStoreFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class CreateAsyncEventQueueFunction
extends FunctionAdapter
implements InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            String gatewaySubstitutionFilter;
            AsyncEventQueueFunctionArgs aeqArgs = (AsyncEventQueueFunctionArgs)context.getArguments();
            GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
            InternalDistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            AsyncEventQueueFactory asyncEventQueueFactory = cache.createAsyncEventQueueFactory().setParallel(aeqArgs.isParallel()).setBatchConflationEnabled(aeqArgs.isEnableBatchConflation()).setBatchSize(aeqArgs.getBatchSize()).setBatchTimeInterval(aeqArgs.getBatchTimeInterval()).setPersistent(aeqArgs.isPersistent()).setDiskStoreName(aeqArgs.getDiskStoreName()).setDiskSynchronous(aeqArgs.isDiskSynchronous()).setForwardExpirationDestroy(aeqArgs.isForwardExpirationDestroy()).setMaximumQueueMemory(aeqArgs.getMaxQueueMemory()).setDispatcherThreads(aeqArgs.getDispatcherThreads()).setOrderPolicy(GatewaySender.OrderPolicy.valueOf(aeqArgs.getOrderPolicy()));
            String[] gatewayEventFilters = aeqArgs.getGatewayEventFilters();
            if (gatewayEventFilters != null) {
                for (String gatewayEventFilter : gatewayEventFilters) {
                    Class<?> gatewayEventFilterKlass = this.forName(gatewayEventFilter, "gateway-event-filter");
                    asyncEventQueueFactory.addGatewayEventFilter((GatewayEventFilter)CreateAsyncEventQueueFunction.newInstance(gatewayEventFilterKlass, "gateway-event-filter"));
                }
            }
            if ((gatewaySubstitutionFilter = aeqArgs.getGatewaySubstitutionFilter()) != null) {
                Class<?> gatewayEventSubstitutionFilterKlass = this.forName(gatewaySubstitutionFilter, "gateway-event-substitution-filter");
                asyncEventQueueFactory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)CreateAsyncEventQueueFunction.newInstance(gatewayEventSubstitutionFilterKlass, "gateway-event-substitution-filter"));
            }
            String listenerClassName = aeqArgs.getListenerClassName();
            Class<?> listenerClass = InternalDataSerializer.getCachedClass(listenerClassName);
            Object listenerInstance = listenerClass.newInstance();
            Properties listenerProperties = aeqArgs.getListenerProperties();
            if (listenerProperties != null && !listenerProperties.isEmpty()) {
                if (!(listenerInstance instanceof Declarable)) {
                    throw new IllegalArgumentException("Listener properties were provided, but the listener specified does not implement Declarable.");
                }
                ((Declarable)listenerInstance).init(listenerProperties);
                HashMap<Declarable, Properties> declarablesMap = new HashMap<Declarable, Properties>();
                declarablesMap.put((Declarable)listenerInstance, listenerProperties);
                cache.addDeclarableProperties(declarablesMap);
            }
            asyncEventQueueFactory.create(aeqArgs.getAsyncEventQueueId(), (AsyncEventListener)listenerInstance);
            XmlEntity xmlEntity = new XmlEntity("async-event-queue", "id", aeqArgs.getAsyncEventQueueId());
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity, "Success"));
        }
        catch (CacheClosedException cce) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, null));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not create async event queue: {}", (Object)th.getMessage(), (Object)th);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, th, null));
        }
    }

    private Class<?> forName(String className, String neededFor) {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        try {
            return ClassPathLoader.getLatest().forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(CliStrings.format("Could not find class \"{0}\" specified for \"{1}\".", className, neededFor), e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(CliStrings.format("Class \"{0}\" specified for \"{1}\" is not of an expected type.", className, neededFor), e);
        }
    }

    private static Object newInstance(Class<?> klass, String neededFor) {
        try {
            return klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CliStrings.format("Could not instantiate class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CliStrings.format("Could not access class \"{0}\" specified for \"{1}\".", klass, neededFor), e);
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

