/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.AbstractCommandsSupport;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DeployFunction;
import org.apache.geode.management.internal.cli.functions.ListDeployedFunction;
import org.apache.geode.management.internal.cli.functions.UndeployFunction;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.SharedConfigurationWriter;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public final class DeployCommands
extends AbstractCommandsSupport
implements CommandMarker {
    private final DeployFunction deployFunction = new DeployFunction();
    private final UndeployFunction undeployFunction = new UndeployFunction();
    private final ListDeployedFunction listDeployedFunction = new ListDeployedFunction();

    @CliCommand(value={"deploy"}, help="Deploy JARs to a member or members.  Only one of either --jar or --dir may be specified.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.DeployCommands$Interceptor", relatedTopic={"Configuration"}, writesToSharedConfiguration=true)
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public final Result deploy(@CliOption(key={"group"}, help="Group(s) to which the specified JARs will be deployed. If not specified, deploy will occur on all members.", optionContext="converter.hint.member.groups") @CliMetaData(valueSeparator=",") String[] groups, @CliOption(key={"jar"}, help="Path of the JAR to deploy.") String jar, @CliOption(key={"dir"}, help="Directory from which to deploy the JARs.") String dir) {
        try {
            Set<DistributedMember> targetMembers;
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            byte[][] shellBytesData = CommandExecutionContext.getBytesFromShell();
            String[] jarNames = CliUtil.bytesToNames(shellBytesData);
            byte[][] jarBytes = CliUtil.bytesToData(shellBytesData);
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(groups, null);
            }
            catch (CommandResultException e) {
                return e.getResult();
            }
            ResultCollector<?, ?> resultCollector = CliUtil.executeFunction((Function)this.deployFunction, (Object)new Object[]{jarNames, jarBytes}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)resultCollector.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Deployed JAR", "");
                    tabularData.accumulate("Deployed JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Deployed JAR", strings[i]);
                    tabularData.accumulate("Deployed JAR Location", strings[i + 1]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("Unable to deploy JAR file(s)");
            }
            Result result = ResultBuilder.buildResult(tabularData);
            if (tabularData.getStatus().equals((Object)Result.Status.OK)) {
                result.setCommandPersisted(new SharedConfigurationWriter().addJars(jarNames, jarBytes, groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult(String.format("Exception while attempting to deploy: (%1$s)", DeployCommands.toString(t, this.isDebugging())));
        }
    }

    @CliCommand(value={"undeploy"}, help="Undeploy JARs from a member or members.")
    @CliMetaData(relatedTopic={"Configuration"}, writesToSharedConfiguration=true)
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public final Result undeploy(@CliOption(key={"group"}, help="Group(s) of members from which to undeploy JARs. If not specified, undeploy will occur on all members.", optionContext="converter.hint.member.groups") @CliMetaData(valueSeparator=",") String[] groups, @CliOption(key={"jar"}, help="JAR(s) to be undeployed.  If not specified, all JARs will be undeployed.", unspecifiedDefaultValue="__NULL__") @CliMetaData(valueSeparator=",") String jars) {
        try {
            Set<DistributedMember> targetMembers;
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(groups, null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.undeployFunction, (Object)new Object[]{jars}, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Un-Deployed JAR", "");
                    tabularData.accumulate("Un-Deployed JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("Un-Deployed JAR", strings[i]);
                    tabularData.accumulate("Un-Deployed From JAR Location", strings[i + 1]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No JAR Files Found");
            }
            Result result = ResultBuilder.buildResult(tabularData);
            if (tabularData.getStatus().equals((Object)Result.Status.OK)) {
                result.setCommandPersisted(new SharedConfigurationWriter().deleteJars(jars == null ? null : jars.split(","), groups));
            }
            return result;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to un-deploy: " + th.getClass().getName() + ": " + th.getMessage());
        }
    }

    @CliCommand(value={"list deployed"}, help="Display a list of JARs that were deployed to members using the \"deploy\" command.")
    @CliMetaData(relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public final Result listDeployed(@CliOption(key={"group"}, help="Group(s) of members for which deployed JARs will be displayed.  If not specified, JARs for all members will be displayed.") @CliMetaData(valueSeparator=",") String group) {
        try {
            Set<DistributedMember> targetMembers;
            TabularResultData tabularData = ResultBuilder.createTabularResultData();
            boolean accumulatedData = false;
            try {
                targetMembers = CliUtil.findAllMatchingMembers(group, null);
            }
            catch (CommandResultException crex) {
                return crex.getResult();
            }
            ResultCollector<?, ?> rc = CliUtil.executeFunction((Function)this.listDeployedFunction, null, targetMembers);
            List<CliFunctionResult> results = CliFunctionResult.cleanResults((List)rc.getResult());
            for (CliFunctionResult result : results) {
                if (result.getThrowable() != null) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("JAR", "");
                    tabularData.accumulate("JAR Location", "ERROR: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage());
                    accumulatedData = true;
                    tabularData.setStatus(Result.Status.ERROR);
                    continue;
                }
                String[] strings = (String[])result.getSerializables();
                for (int i = 0; i < strings.length; i += 2) {
                    tabularData.accumulate("Member", result.getMemberIdOrName());
                    tabularData.accumulate("JAR", strings[i]);
                    tabularData.accumulate("JAR Location", strings[i + 1]);
                    accumulatedData = true;
                }
            }
            if (!accumulatedData) {
                return ResultBuilder.createInfoResult("No JAR Files Found");
            }
            return ResultBuilder.buildResult(tabularData);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            return ResultBuilder.createGemFireErrorResult("Exception while attempting to list deployed: " + th.getClass().getName() + ": " + th.getMessage());
        }
    }

    @CliAvailabilityIndicator(value={"deploy", "undeploy", "list deployed"})
    public final boolean isConnected() {
        if (!CliUtil.isGfshVM()) {
            return true;
        }
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        private final DecimalFormat numFormatter = new DecimalFormat("###,##0.00");

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String message;
            FileResult fileResult;
            String jarOrDir;
            Map<String, String> paramValueMap = parseResult.getParamValueStrings();
            String jar = paramValueMap.get("jar");
            jar = jar == null ? null : jar.trim();
            String dir = paramValueMap.get("dir");
            dir = dir == null ? null : dir.trim();
            String group = paramValueMap.get("group");
            group = group == null ? null : group.trim();
            String string = jarOrDir = jar != null ? jar : dir;
            if (jar == null && dir == null) {
                return ResultBuilder.createUserErrorResult("Parameter \"jar\" or \"dir\" is required. Use \"help <command name>\" for assistance.");
            }
            try {
                fileResult = new FileResult(new String[]{jar != null ? jar : dir});
            }
            catch (FileNotFoundException fnfex) {
                return ResultBuilder.createGemFireErrorResult("'" + jarOrDir + "' not found.");
            }
            catch (IOException ioex) {
                return ResultBuilder.createGemFireErrorResult("I/O error when reading jar/dir: " + ioex.getClass().getName() + ": " + ioex.getMessage());
            }
            if (dir != null && this.readYesNo(message = "\nDeploying files: " + fileResult.getFormattedFileList() + "\nTotal file size is: " + this.numFormatter.format((double)fileResult.computeFileSizeTotal() / 1048576.0) + "MB\n\nContinue? ", AbstractCliAroundInterceptor.Response.YES) == AbstractCliAroundInterceptor.Response.NO) {
                return ResultBuilder.createShellClientAbortOperationResult("Aborted deploy of " + jarOrDir + ".");
            }
            return fileResult;
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult) {
            return null;
        }
    }
}

