/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.CommandResponse;
import org.apache.geode.management.internal.cli.CommandResponseWriter;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;

public class CommandResponseBuilder {
    private static final String NO_TOKEN_ACCESSOR = "__NULL__";

    public static CommandResponse prepareCommandResponse(String memberName, CommandResult result) {
        GfJsonObject content = null;
        try {
            content = result.getContent();
        }
        catch (GfJsonException e) {
            try {
                content = new GfJsonObject(e.getMessage());
            }
            catch (GfJsonException e1) {
                content = new GfJsonObject();
            }
        }
        return new CommandResponse(memberName, CommandResponseBuilder.getType(result), result.getStatus().getCode(), "1/1", NO_TOKEN_ACCESSOR, CommandResponseBuilder.getDebugInfo(result), result.getHeader(), content, result.getFooter(), result.failedToPersist());
    }

    public static CommandResponse prepareCommandResponseFromJson(String jsonString) {
        GfJsonObject jsonObject = null;
        try {
            jsonObject = new GfJsonObject(jsonString);
        }
        catch (GfJsonException e) {
            jsonObject = GfJsonObject.getGfJsonErrorObject(CliUtil.stackTraceAsString(e));
        }
        return new CommandResponse(jsonObject);
    }

    public static String getCommandResponseJson(CommandResponse commandResponse) {
        return new GfJsonObject(commandResponse).toString();
    }

    public static String createCommandResponseJson(String memberName, CommandResult result) {
        return CommandResponseBuilder.getCommandResponseJson(CommandResponseBuilder.prepareCommandResponse(memberName, result));
    }

    private static String getType(CommandResult result) {
        return result.getType();
    }

    private static String getDebugInfo(CommandResult result) {
        String debugInfo = "";
        if (CommandExecutionContext.isSetWrapperThreadLocal()) {
            CommandResponseWriter responseWriter = CommandExecutionContext.getCommandResponseWriter();
            debugInfo = responseWriter.getResponseWritten();
        }
        return debugInfo;
    }
}

