/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ClassLoadUtil;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.AsyncEventQueueMXBean;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.DiskStoreMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LocatorMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.AlertDetails;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBean;
import org.apache.geode.management.internal.beans.AsyncEventQueueMBeanBridge;
import org.apache.geode.management.internal.beans.CacheServerBridge;
import org.apache.geode.management.internal.beans.CacheServerMBean;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.geode.management.internal.beans.DiskStoreMBean;
import org.apache.geode.management.internal.beans.DiskStoreMBeanBridge;
import org.apache.geode.management.internal.beans.DistributedSystemBridge;
import org.apache.geode.management.internal.beans.GatewayReceiverMBean;
import org.apache.geode.management.internal.beans.GatewayReceiverMBeanBridge;
import org.apache.geode.management.internal.beans.GatewaySenderMBean;
import org.apache.geode.management.internal.beans.GatewaySenderMBeanBridge;
import org.apache.geode.management.internal.beans.LocatorMBean;
import org.apache.geode.management.internal.beans.LocatorMBeanBridge;
import org.apache.geode.management.internal.beans.LockServiceMBean;
import org.apache.geode.management.internal.beans.LockServiceMBeanBridge;
import org.apache.geode.management.internal.beans.MBeanAggregator;
import org.apache.geode.management.internal.beans.ManagerMBean;
import org.apache.geode.management.internal.beans.ManagerMBeanBridge;
import org.apache.geode.management.internal.beans.MemberMBean;
import org.apache.geode.management.internal.beans.MemberMBeanBridge;
import org.apache.geode.management.internal.beans.RegionMBean;
import org.apache.geode.management.internal.beans.RegionMBeanBridge;
import org.apache.geode.management.internal.beans.SequenceNumber;
import org.apache.geode.management.membership.ClientMembership;
import org.apache.geode.management.membership.ClientMembershipEvent;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.geode.management.membership.ClientMembershipListenerAdapter;
import org.apache.logging.log4j.Logger;

public class ManagementAdapter {
    private static final Logger logger = LogService.getLogger();
    private SystemManagementService service;
    private GemFireCacheImpl cacheImpl;
    private String memberSource;
    private NotificationBroadcasterSupport memberLevelNotifEmitter;
    public static final MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    private MemberMBean memberBean;
    private volatile boolean serviceInitialised = false;
    private MBeanAggregator aggregator;
    public static final List<Class> refreshOnInit = new ArrayList<Class>();
    public static final List<String> internalLocks = new ArrayList<String>();
    protected MemberMBeanBridge memberMBeanBridge;
    private final Object regionOpLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCacheCreation(GemFireCacheImpl cache) throws ManagementException {
        try {
            this.cacheImpl = cache;
            this.service = (SystemManagementService)ManagementService.getManagementService(this.cacheImpl);
            this.memberMBeanBridge = new MemberMBeanBridge(this.cacheImpl, this.service).init();
            this.memberBean = new MemberMBean(this.memberMBeanBridge);
            this.memberLevelNotifEmitter = this.memberBean;
            ObjectName memberMBeanName = MBeanJMXAdapter.getMemberMBeanName(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
            this.memberSource = MBeanJMXAdapter.getMemberNameOrId(this.cacheImpl.getDistributedSystem().getDistributedMember());
            ObjectName changedMBeanName = this.service.registerInternalMBean(this.memberBean, memberMBeanName);
            this.service.federate(changedMBeanName, MemberMXBean.class, true);
            this.serviceInitialised = true;
            if (InternalLocator.hasLocator()) {
                InternalLocator loc = InternalLocator.getLocator();
                this.handleLocatorStart(loc);
            }
            if (cache.getDistributedSystem().getConfig().getJmxManager()) {
                this.service.createManager();
                if (cache.getDistributedSystem().getConfig().getJmxManagerStart()) {
                    this.service.startManager();
                }
            }
        }
        finally {
            if (!this.serviceInitialised && this.service != null) {
                this.service.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("Management Service Could not initialise hence closing");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Management Service is initialised and Running");
            }
        }
    }

    public void handleManagerStart() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerStart")) {
            return;
        }
        MBeanJMXAdapter jmxAdapter = this.service.getJMXAdapter();
        Map<ObjectName, Object> registeredMBeans = jmxAdapter.getLocalGemFireMBean();
        DistributedSystemBridge dsBridge = new DistributedSystemBridge(this.service);
        this.aggregator = new MBeanAggregator(dsBridge);
        this.service.addProxyListener(this.aggregator);
        MemberMXBean localMember = this.service.getMemberMXBean();
        ObjectName memberObjectName = MBeanJMXAdapter.getMemberMBeanName(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        FederationComponent addedComp = this.service.getLocalManager().getFedComponents().get(memberObjectName);
        this.service.afterCreateProxy(memberObjectName, MemberMXBean.class, localMember, addedComp);
        for (ObjectName objectName : registeredMBeans.keySet()) {
            if (objectName.equals(memberObjectName)) continue;
            Object object = registeredMBeans.get(objectName);
            try {
                ObjectInstance instance = mbeanServer.getObjectInstance(objectName);
                String className = instance.getClassName();
                Class cls = ClassLoadUtil.classFromName(className);
                Type[] intfTyps = cls.getGenericInterfaces();
                FederationComponent newObj = this.service.getLocalManager().getFedComponents().get(objectName);
                for (int i = 0; i < intfTyps.length; ++i) {
                    Class intfTyp = (Class)intfTyps[i];
                    this.service.afterCreateProxy(objectName, intfTyp, object, newObj);
                }
            }
            catch (InstanceNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed in Registering distributed mbean ");
                }
                throw new ManagementException(e);
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed in Registering distributed mbean");
                }
                throw new ManagementException(e);
            }
        }
    }

    public void handleManagerStop() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerStop")) {
            return;
        }
        MBeanJMXAdapter jmxAdapter = this.service.getJMXAdapter();
        Map<ObjectName, Object> registeredMBeans = jmxAdapter.getLocalGemFireMBean();
        ObjectName aggregatemMBeanPattern = null;
        try {
            aggregatemMBeanPattern = new ObjectName("GemFire:*,type=Distributed");
        }
        catch (MalformedObjectNameException e1) {
            throw new ManagementException(e1);
        }
        catch (NullPointerException e1) {
            throw new ManagementException(e1);
        }
        MemberMXBean localMember = this.service.getMemberMXBean();
        ObjectName memberObjectName = MBeanJMXAdapter.getMemberMBeanName(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        FederationComponent removedComp = this.service.getLocalManager().getFedComponents().get(memberObjectName);
        this.service.afterRemoveProxy(memberObjectName, MemberMXBean.class, localMember, removedComp);
        for (ObjectName objectName : registeredMBeans.keySet()) {
            if (objectName.equals(memberObjectName) || aggregatemMBeanPattern.apply(objectName)) continue;
            Object object = registeredMBeans.get(objectName);
            try {
                ObjectInstance instance = mbeanServer.getObjectInstance(objectName);
                String className = instance.getClassName();
                Class cls = ClassLoadUtil.classFromName(className);
                Type[] intfTyps = cls.getGenericInterfaces();
                FederationComponent oldObj = this.service.getLocalManager().getFedComponents().get(objectName);
                for (int i = 0; i < intfTyps.length; ++i) {
                    Class intfTyp = (Class)intfTyps[i];
                    this.service.afterRemoveProxy(objectName, intfTyp, object, oldObj);
                }
            }
            catch (InstanceNotFoundException e) {
                logger.warn("Failed to invoke aggregator for {} with exception {}", (Object)objectName, (Object)e.getMessage(), (Object)e);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Failed to invoke aggregator for {} with exception {}", (Object)objectName, (Object)e.getMessage(), (Object)e);
            }
        }
        this.service.removeProxyListener(this.aggregator);
        this.aggregator = null;
    }

    public void handleManagerCreation() throws ManagementException {
        if (!this.isServiceInitialised("handleManagerCreation")) {
            return;
        }
        ObjectName managerMBeanName = MBeanJMXAdapter.getManagerName();
        ManagerMBeanBridge bridge = new ManagerMBeanBridge(this.service);
        ManagerMBean bean = new ManagerMBean(bridge);
        this.service.registerInternalMBean(bean, managerMBeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void handleRegionCreation(Region<K, V> region) throws ManagementException {
        if (!this.isServiceInitialised("handleRegionCreation")) {
            return;
        }
        Object object = this.regionOpLock;
        synchronized (object) {
            LocalRegion localRegion = (LocalRegion)region;
            if (localRegion.isDestroyed()) {
                return;
            }
            RegionMBeanBridge<K, V> bridge = RegionMBeanBridge.getInstance(region);
            RegionMBean<K, V> regionMBean = new RegionMBean<K, V>(bridge);
            ObjectName regionMBeanName = MBeanJMXAdapter.getRegionMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), region.getFullPath());
            ObjectName changedMBeanName = this.service.registerInternalMBean(regionMBean, regionMBeanName);
            this.service.federate(changedMBeanName, RegionMXBean.class, true);
            Notification notification = new Notification("gemfire.distributedsystem.cache.region.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Region Created With Name " + region.getFullPath());
            this.memberLevelNotifEmitter.sendNotification(notification);
            this.memberMBeanBridge.addRegion(region);
        }
    }

    public void handleDiskCreation(DiskStore disk) throws ManagementException {
        if (!this.isServiceInitialised("handleDiskCreation")) {
            return;
        }
        DiskStoreMBeanBridge bridge = new DiskStoreMBeanBridge(disk);
        DiskStoreMBean diskStoreMBean = new DiskStoreMBean(bridge);
        ObjectName diskStoreMBeanName = MBeanJMXAdapter.getDiskStoreMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), disk.getName());
        ObjectName changedMBeanName = this.service.registerInternalMBean(diskStoreMBean, diskStoreMBeanName);
        this.service.federate(changedMBeanName, DiskStoreMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.disk.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "DiskStore Created With Name " + disk.getName());
        this.memberLevelNotifEmitter.sendNotification(notification);
        this.memberMBeanBridge.addDiskStore(disk);
    }

    public void handleLockServiceCreation(DLockService lockService) throws ManagementException {
        if (!this.isServiceInitialised("handleLockServiceCreation")) {
            return;
        }
        if (internalLocks.contains(lockService.getName())) {
            return;
        }
        LockServiceMBeanBridge bridge = new LockServiceMBeanBridge(lockService);
        LockServiceMBean lockServiceMBean = new LockServiceMBean(bridge);
        ObjectName lockServiceMBeanName = MBeanJMXAdapter.getLockServiceMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), lockService.getName());
        ObjectName changedMBeanName = this.service.registerInternalMBean(lockServiceMBean, lockServiceMBeanName);
        this.service.federate(changedMBeanName, LockServiceMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.lockservice.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "LockService Created With Name " + lockService.getName());
        this.memberLevelNotifEmitter.sendNotification(notification);
        this.memberMBeanBridge.addLockServiceStats(lockService);
    }

    public void handleGatewaySenderCreation(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderCreation")) {
            return;
        }
        GatewaySenderMBeanBridge bridge = new GatewaySenderMBeanBridge(sender);
        GatewaySenderMBean senderMBean = new GatewaySenderMBean(bridge);
        ObjectName senderObjectName = MBeanJMXAdapter.getGatewaySenderMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), sender.getId());
        ObjectName changedMBeanName = this.service.registerInternalMBean(senderMBean, senderObjectName);
        this.service.federate(changedMBeanName, GatewaySenderMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Created in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewayReceiverCreate(GatewayReceiver recv) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverCreate")) {
            return;
        }
        if (!recv.isManualStart()) {
            return;
        }
        this.createGatewayReceiverMBean(recv);
    }

    private void createGatewayReceiverMBean(GatewayReceiver recv) {
        GatewayReceiverMBeanBridge bridge = new GatewayReceiverMBeanBridge(recv);
        GatewayReceiverMBean receiverMBean = new GatewayReceiverMBean(bridge);
        ObjectName recvObjectName = MBeanJMXAdapter.getGatewayReceiverMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember());
        ObjectName changedMBeanName = this.service.registerInternalMBean(receiverMBean, recvObjectName);
        this.service.federate(changedMBeanName, GatewayReceiverMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Created in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewayReceiverStart(GatewayReceiver recv) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverStart")) {
            return;
        }
        if (!recv.isManualStart()) {
            this.createGatewayReceiverMBean(recv);
        }
        GatewayReceiverMBean mbean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean();
        GatewayReceiverMBeanBridge bridge = mbean.getBridge();
        bridge.startServer();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Started in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewayReceiverStop(GatewayReceiver recv) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewayReceiverStop")) {
            return;
        }
        GatewayReceiverMBean mbean = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean();
        GatewayReceiverMBeanBridge bridge = mbean.getBridge();
        bridge.stopServer();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.receiver.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewayReceiver Stopped in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleAsyncEventQueueCreation(AsyncEventQueue queue) throws ManagementException {
        if (!this.isServiceInitialised("handleAsyncEventQueueCreation")) {
            return;
        }
        AsyncEventQueueMBeanBridge bridge = new AsyncEventQueueMBeanBridge(queue);
        AsyncEventQueueMBean queueMBean = new AsyncEventQueueMBean(bridge);
        ObjectName senderObjectName = MBeanJMXAdapter.getAsycnEventQueueMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), queue.getId());
        ObjectName changedMBeanName = this.service.registerInternalMBean(queueMBean, senderObjectName);
        this.service.federate(changedMBeanName, AsyncEventQueueMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.asycn.event.queue.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Async Event Queue is Created  in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleSystemNotification(AlertDetails details) {
        if (!this.isServiceInitialised("handleSystemNotification")) {
            return;
        }
        if (this.service.isManager()) {
            String systemSource = "DistributedSystem(" + this.service.getDistributedSystemMXBean().getDistributedSystemId() + ")";
            Map<String, String> userData = this.prepareUserData(details);
            Notification notification = new Notification("system.alert", systemSource, SequenceNumber.next(), details.getMsgTime().getTime(), details.getMsg());
            notification.setUserData(userData);
            this.service.handleNotification(notification);
        }
    }

    private Map<String, String> prepareUserData(AlertDetails details) {
        HashMap<String, String> userData = new HashMap<String, String>();
        userData.put("AlertLevel", AlertDetails.getAlertLevelAsString(details.getAlertLevel()));
        String source = details.getSource();
        userData.put("Thread", source);
        InternalDistributedMember sender = details.getSender();
        String nameOrId = this.memberSource;
        if (sender != null) {
            nameOrId = sender.getName();
            nameOrId = nameOrId != null && !nameOrId.trim().isEmpty() ? nameOrId : sender.getId();
        }
        userData.put("Member", nameOrId);
        return userData;
    }

    public void handleCacheServerStart(CacheServer cacheServer) {
        if (!this.isServiceInitialised("handleCacheServerStart")) {
            return;
        }
        CacheServerBridge cacheServerBridge = new CacheServerBridge(cacheServer, this.cacheImpl);
        cacheServerBridge.setMemberMBeanBridge(this.memberMBeanBridge);
        CacheServerMBean cacheServerMBean = new CacheServerMBean(cacheServerBridge);
        ObjectName cacheServerMBeanName = MBeanJMXAdapter.getClientServiceMBeanName(cacheServer.getPort(), this.cacheImpl.getDistributedSystem().getDistributedMember());
        ObjectName changedMBeanName = this.service.registerInternalMBean(cacheServerMBean, cacheServerMBeanName);
        CacheServerMembershipListenerAdapter managementClientListener = new CacheServerMembershipListenerAdapter(cacheServerMBean, this.memberLevelNotifEmitter, changedMBeanName);
        ClientMembership.registerClientMembershipListener(managementClientListener);
        cacheServerBridge.setClientMembershipListener(managementClientListener);
        this.service.federate(changedMBeanName, CacheServerMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.cache.server.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Server is Started in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
        this.memberMBeanBridge.setCacheServer(true);
    }

    public void handleCacheServerStop(CacheServer server) {
        if (!this.isServiceInitialised("handleCacheServerStop")) {
            return;
        }
        CacheServerMBean mbean = (CacheServerMBean)this.service.getLocalCacheServerMXBean(server.getPort());
        ClientMembershipListener listener = mbean.getBridge().getClientMembershipListener();
        if (listener != null) {
            ClientMembership.unregisterClientMembershipListener(listener);
        }
        mbean.stopMonitor();
        ObjectName cacheServerMBeanName = MBeanJMXAdapter.getClientServiceMBeanName(server.getPort(), this.cacheImpl.getDistributedSystem().getDistributedMember());
        this.service.unregisterMBean(cacheServerMBeanName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.server.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Server is stopped in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
        this.memberMBeanBridge.setCacheServer(false);
    }

    public void handleCacheRemoval(Cache cache) throws ManagementException {
        block8: {
            if (!this.isServiceInitialised("handleCacheRemoval")) {
                return;
            }
            this.serviceInitialised = false;
            try {
                this.cleanUpMonitors();
                this.cleanBridgeResources();
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.service.close();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cacheImpl = null;
            this.service = null;
            this.memberMBeanBridge = null;
            this.memberBean = null;
            this.memberLevelNotifEmitter = null;
        }
    }

    private void cleanUpMonitors() {
        GatewayReceiverMBean receiver;
        Set<GatewaySender> senders;
        MemberMBean bean = (MemberMBean)this.service.getMemberMXBean();
        if (bean != null) {
            bean.stopMonitor();
        }
        if ((senders = this.cacheImpl.getGatewaySenders()) != null && senders.size() > 0) {
            for (GatewaySender sender : senders) {
                GatewaySenderMBean senderMBean = (GatewaySenderMBean)this.service.getLocalGatewaySenderMXBean(sender.getId());
                if (senderMBean == null) continue;
                senderMBean.stopMonitor();
            }
        }
        if ((receiver = (GatewayReceiverMBean)this.service.getLocalGatewayReceiverMXBean()) != null) {
            receiver.stopMonitor();
        }
    }

    private void cleanBridgeResources() {
        List servers = this.cacheImpl.getCacheServers();
        if (servers != null && servers.size() > 0) {
            for (CacheServer server : servers) {
                ClientMembershipListener listener;
                CacheServerMBean mbean = (CacheServerMBean)this.service.getLocalCacheServerMXBean(server.getPort());
                if (mbean == null || (listener = mbean.getBridge().getClientMembershipListener()) == null) continue;
                ClientMembership.unregisterClientMembershipListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRegionRemoval(Region region) throws ManagementException {
        if (!this.isServiceInitialised("handleRegionRemoval")) {
            return;
        }
        Object object = this.regionOpLock;
        synchronized (object) {
            ObjectName regionMBeanName = MBeanJMXAdapter.getRegionMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), region.getFullPath());
            RegionMBean bean = null;
            try {
                bean = (RegionMBean)this.service.getLocalRegionMBean(region.getFullPath());
            }
            catch (ManagementException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                return;
            }
            if (bean != null) {
                bean.stopMonitor();
            }
            this.service.unregisterMBean(regionMBeanName);
            Notification notification = new Notification("gemfire.distributedsystem.cache.region.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Region Destroyed/Closed With Name " + region.getFullPath());
            this.memberLevelNotifEmitter.sendNotification(notification);
            this.memberMBeanBridge.removeRegion(region);
        }
    }

    public void handleDiskRemoval(DiskStore disk) throws ManagementException {
        if (!this.isServiceInitialised("handleDiskRemoval")) {
            return;
        }
        ObjectName diskStoreMBeanName = MBeanJMXAdapter.getDiskStoreMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), disk.getName());
        DiskStoreMBean bean = null;
        try {
            bean = (DiskStoreMBean)this.service.getLocalDiskStoreMBean(disk.getName());
            if (bean == null) {
                return;
            }
        }
        catch (ManagementException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return;
        }
        bean.stopMonitor();
        this.service.unregisterMBean(diskStoreMBeanName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.disk.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "DiskStore Destroyed/Closed With Name " + disk.getName());
        this.memberLevelNotifEmitter.sendNotification(notification);
        this.memberMBeanBridge.removeDiskStore(disk);
    }

    public void handleLockServiceRemoval(DLockService lockService) throws ManagementException {
        if (!this.isServiceInitialised("handleLockServiceRemoval")) {
            return;
        }
        ObjectName lockServiceMBeanName = MBeanJMXAdapter.getLockServiceMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember(), lockService.getName());
        LockServiceMXBean bean = this.service.getLocalLockServiceMBean(lockService.getName());
        this.service.unregisterMBean(lockServiceMBeanName);
        Notification notification = new Notification("gemfire.distributedsystem.cache.lockservice.closed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Lockservice closed With Name " + lockService.getName());
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleLocatorStart(Locator locator) throws ManagementException {
        if (!this.isServiceInitialised("handleLocatorCreation")) {
            return;
        }
        ObjectName locatorMBeanName = MBeanJMXAdapter.getLocatorMBeanName(this.cacheImpl.getDistributedSystem().getDistributedMember());
        LocatorMBeanBridge bridge = new LocatorMBeanBridge(locator);
        LocatorMBean locatorMBean = new LocatorMBean(bridge);
        ObjectName changedMBeanName = this.service.registerInternalMBean(locatorMBean, locatorMBeanName);
        this.service.federate(changedMBeanName, LocatorMXBean.class, true);
        Notification notification = new Notification("gemfire.distributedsystem.locator.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Locator is Started in the VM ");
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewaySenderStart(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderStart")) {
            return;
        }
        if (sender.getRemoteDSId() < 0) {
            return;
        }
        GatewaySenderMBean bean = (GatewaySenderMBean)this.service.getLocalGatewaySenderMXBean(sender.getId());
        bean.getBridge().setDispatcher();
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.started", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Started in the VM " + sender.getId());
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewaySenderStop(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderStop")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.stopped", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Stopped in the VM " + sender.getId());
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewaySenderPaused(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderPaused")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.paused", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Paused in the VM " + sender.getId());
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleGatewaySenderResumed(GatewaySender sender) throws ManagementException {
        if (!this.isServiceInitialised("handleGatewaySenderResumed")) {
            return;
        }
        Notification notification = new Notification("gemfire.distributedsystem.gateway.sender.resumed", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "GatewaySender Resumed in the VM " + sender.getId());
        this.memberLevelNotifEmitter.sendNotification(notification);
    }

    public void handleCacheServiceCreation(CacheService cacheService) throws ManagementException {
        if (!this.isServiceInitialised("handleCacheServiceCreation")) {
            return;
        }
        InternalDistributedMember member = this.cacheImpl.getDistributedSystem().getDistributedMember();
        if (member.getVmKind() == 11) {
            return;
        }
        CacheServiceMBeanBase mbean = cacheService.getMBean();
        if (mbean != null) {
            String id = mbean.getId();
            ObjectName cacheServiceObjectName = MBeanJMXAdapter.getCacheServiceMBeanName(member, id);
            ObjectName changedMBeanName = this.service.registerInternalMBean(mbean, cacheServiceObjectName);
            this.service.federate(changedMBeanName, mbean.getInterfaceClass(), true);
            Notification notification = new Notification("gemfire.distributedsystem.cache.service.created", this.memberSource, SequenceNumber.next(), System.currentTimeMillis(), "Cache Service Created With Name " + id);
            this.memberLevelNotifEmitter.sendNotification(notification);
        }
    }

    private boolean isServiceInitialised(String method) {
        if (!this.serviceInitialised) {
            if (logger.isDebugEnabled()) {
                logger.debug("Management Service is not initialised hence returning from {}", (Object)method);
            }
            return false;
        }
        return true;
    }

    static {
        refreshOnInit.add(RegionMXBean.class);
        refreshOnInit.add(MemberMXBean.class);
        internalLocks.add("DTLS");
        internalLocks.add("LTLS");
        internalLocks.add("__PRLS");
        internalLocks.add("__PDX");
    }

    private static class CacheServerMembershipListenerAdapter
    extends ClientMembershipListenerAdapter {
        private NotificationBroadcasterSupport serverLevelNotifEmitter;
        private NotificationBroadcasterSupport memberLevelNotifEmitter;
        private String serverSource;

        public CacheServerMembershipListenerAdapter(NotificationBroadcasterSupport serverLevelNotifEmitter, NotificationBroadcasterSupport memberLevelNotifEmitter, ObjectName serverSource) {
            this.serverLevelNotifEmitter = serverLevelNotifEmitter;
            this.memberLevelNotifEmitter = memberLevelNotifEmitter;
            this.serverSource = serverSource.toString();
        }

        @Override
        public void memberJoined(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.joined", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client joined with Id " + event.getMemberId());
            this.serverLevelNotifEmitter.sendNotification(notification);
            this.memberLevelNotifEmitter.sendNotification(notification);
        }

        @Override
        public void memberLeft(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.left", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client left with Id " + event.getMemberId());
            this.serverLevelNotifEmitter.sendNotification(notification);
            this.memberLevelNotifEmitter.sendNotification(notification);
        }

        @Override
        public void memberCrashed(ClientMembershipEvent event) {
            Notification notification = new Notification("gemfire.distributedsystem.cacheserver.client.crashed", this.serverSource, SequenceNumber.next(), System.currentTimeMillis(), "Client crashed with Id " + event.getMemberId());
            this.serverLevelNotifEmitter.sendNotification(notification);
            this.memberLevelNotifEmitter.sendNotification(notification);
        }
    }
}

