/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import org.apache.geode.internal.lang.StringUtils;

public class SSLUtil {
    public static String getSSLAlgo(String[] protocols) {
        String[] knownAlgorithms;
        String c = null;
        if (protocols != null && protocols.length > 0) {
            for (String protocol : protocols) {
                if (protocol.equals("any")) continue;
                try {
                    SSLContext.getInstance(protocol);
                    c = protocol;
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        if (c != null) {
            return c;
        }
        for (String algo : knownAlgorithms = new String[]{"SSL", "SSLv2", "SSLv3", "TLS", "TLSv1", "TLSv1.1", "TLSv1.2"}) {
            try {
                SSLContext.getInstance(algo);
                c = algo;
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        return c;
    }

    public static String[] readArray(String text) {
        if (StringUtils.isBlank(text)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(text);
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }
}

