/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.AgentUtil;
import org.apache.geode.management.internal.JettyHelper;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class RestAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private final DistributionConfig config;
    private Server httpServer;
    private final String GEMFIRE_VERSION = GemFireVersion.getGemFireVersion();
    private AgentUtil agentUtil = new AgentUtil(this.GEMFIRE_VERSION);

    public RestAgent(DistributionConfig config) {
        this.config = config;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private boolean isManagementRestServiceRunning(GemFireCacheImpl cache) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        return managementService.getManagementAgent() != null && managementService.getManagementAgent().isHttpServiceRunning();
    }

    public synchronized void start(GemFireCacheImpl cache) {
        if (!this.running && this.config.getHttpServicePort() != 0 && !this.isManagementRestServiceRunning(cache)) {
            try {
                this.startHttpService();
                this.running = true;
                cache.setRESTServiceRunning(true);
                RestAgent.createParameterizedQueryRegion();
            }
            catch (RuntimeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.stopHttpService();
            if (logger.isDebugEnabled()) {
                logger.debug("Gemfire Rest Http service stopped");
            }
            this.running = false;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Attempt to stop Gemfire Rest Http service which is not running");
        }
    }

    private boolean isRunningInTomcat() {
        return System.getProperty("catalina.base") != null || System.getProperty("catalina.home") != null;
    }

    public void startHttpService() {
        String httpServiceBindAddress = this.getBindAddressForHttpService();
        logger.info("Attempting to start HTTP service on port ({}) at bind-address ({})...", (Object)this.config.getHttpServicePort(), (Object)httpServiceBindAddress);
        String gemfireAPIWar = this.agentUtil.findWarLocation("geode-web-api");
        if (gemfireAPIWar == null) {
            logger.info("Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.");
        }
        try {
            if (this.isRunningInTomcat()) {
                logger.warn("Detected presence of catalina system properties. HTTP service will not be started. To enable the GemFire Developer REST API, please deploy the /geode-web-api WAR file in your application server.");
            } else if (this.agentUtil.isWebApplicationAvailable(gemfireAPIWar)) {
                int port = this.config.getHttpServicePort();
                this.httpServer = JettyHelper.initJetty(httpServiceBindAddress, port, SSLConfigurationFactory.getSSLConfigForComponent(SecurableCommunicationChannel.WEB));
                this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire-api", gemfireAPIWar);
                this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/geode", gemfireAPIWar);
                if (logger.isDebugEnabled()) {
                    logger.info("Starting HTTP embedded server on port ({}) at bind-address ({})...", (Object)((ServerConnector)this.httpServer.getConnectors()[0]).getPort(), (Object)httpServiceBindAddress);
                }
                this.httpServer = JettyHelper.startJetty(this.httpServer);
                logger.info("HTTP service started successfully...!!");
            }
        }
        catch (Exception e) {
            this.stopHttpService();
            throw new RuntimeException("HTTP service failed to start due to " + e.getMessage());
        }
    }

    private String getBindAddressForHttpService() {
        String bindAddress = this.config.getHttpServiceBindAddress();
        if (StringUtils.isBlank((String)bindAddress)) {
            if (StringUtils.isBlank((String)this.config.getServerBindAddress())) {
                if (StringUtils.isBlank((String)this.config.getBindAddress())) {
                    try {
                        bindAddress = SocketCreator.getLocalHost().getHostAddress();
                        logger.info("RestAgent.getBindAddressForHttpService.localhost: " + SocketCreator.getLocalHost().getHostAddress());
                    }
                    catch (UnknownHostException e) {
                        logger.error("LocalHost could not be found.", (Throwable)e);
                        return bindAddress;
                    }
                } else {
                    bindAddress = this.config.getBindAddress();
                }
            } else {
                bindAddress = this.config.getServerBindAddress();
            }
        }
        return bindAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopHttpService() {
        if (this.httpServer == null) return;
        logger.info("Stopping the HTTP service...");
        try {
            this.httpServer.stop();
            return;
        }
        catch (Exception e) {
            logger.warn("Failed to stop the HTTP service because: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.error("Failed to properly release resources held by the HTTP service: {}", (Object)ignore.getMessage(), (Object)ignore);
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
        }
    }

    public static void createParameterizedQueryRegion() {
        block6: {
            try {
                GemFireCacheImpl cache;
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting creation of  __ParameterizedQueries__ region");
                }
                if ((cache = (GemFireCacheImpl)CacheFactory.getAnyInstance()) != null) {
                    InternalRegionArguments regionArguments = new InternalRegionArguments();
                    regionArguments.setIsUsedForMetaRegion(true);
                    AttributesFactory<String, String> attributesFactory = new AttributesFactory<String, String>();
                    attributesFactory.setConcurrencyChecksEnabled(false);
                    attributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    attributesFactory.setKeyConstraint(String.class);
                    attributesFactory.setScope(Scope.DISTRIBUTED_ACK);
                    attributesFactory.setStatisticsEnabled(false);
                    attributesFactory.setValueConstraint(String.class);
                    RegionAttributes regionAttributes = attributesFactory.create();
                    cache.createVMRegion("__ParameterizedQueries__", regionAttributes, regionArguments);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully created __ParameterizedQueries__ region");
                    }
                } else {
                    logger.error("Cannot create ParameterizedQueries Region as no cache found!");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Error creating __ParameterizedQueries__ Region with cause {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

