/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import javax.management.openmbean.SimpleType;
import org.apache.geode.management.internal.OpenTypeConverter;

public final class EnumConverter<T extends Enum<T>>
extends OpenTypeConverter {
    private final Class<T> enumClass;

    EnumConverter(Class<T> enumClass) {
        super(enumClass, SimpleType.STRING, String.class);
        this.enumClass = enumClass;
    }

    @Override
    final Object toNonNullOpenValue(Object value) {
        return ((Enum)value).name();
    }

    @Override
    public final Object fromNonNullOpenValue(Object value) throws InvalidObjectException {
        try {
            return Enum.valueOf(this.enumClass, (String)value);
        }
        catch (Exception e) {
            throw EnumConverter.invalidObjectException("Cannot convert to enum: " + value, e);
        }
    }
}

