/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import org.apache.geode.management.internal.OpenTypeConverter;

public final class CollectionConverter
extends OpenTypeConverter {
    private final Class<? extends Collection> collectionClass;
    private final OpenTypeConverter elementConverter;

    CollectionConverter(Type targetType, ArrayType openArrayType, Class openArrayClass, OpenTypeConverter elementConverter) {
        super(targetType, openArrayType, openArrayClass);
        this.elementConverter = elementConverter;
        Type raw = ((ParameterizedType)targetType).getRawType();
        Class c = (Class)raw;
        if (c == List.class) {
            this.collectionClass = ArrayList.class;
        } else if (c == Set.class) {
            this.collectionClass = HashSet.class;
        } else if (c == SortedSet.class) {
            this.collectionClass = TreeSet.class;
        } else {
            assert (false);
            this.collectionClass = null;
        }
    }

    @Override
    final Object toNonNullOpenValue(Object value) throws OpenDataException {
        Comparator comparator;
        Collection valueCollection = (Collection)value;
        if (valueCollection instanceof SortedSet && (comparator = ((SortedSet)valueCollection).comparator()) != null) {
            String msg = "Cannot convert SortedSet with non-null comparator: " + comparator;
            throw CollectionConverter.openDataException(msg, new IllegalArgumentException(msg));
        }
        Object[] openArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), valueCollection.size());
        int i = 0;
        for (Object o : valueCollection) {
            openArray[i++] = this.elementConverter.toOpenValue(o);
        }
        return openArray;
    }

    @Override
    public final Object fromNonNullOpenValue(Object openValue) throws InvalidObjectException {
        Collection valueCollection;
        Object[] openArray = (Object[])openValue;
        try {
            valueCollection = this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw CollectionConverter.invalidObjectException("Cannot create collection", e);
        }
        for (Object o : openArray) {
            Object value = this.elementConverter.fromOpenValue(o);
            if (valueCollection.add(value)) continue;
            String msg = "Could not add " + o + " to " + this.collectionClass.getName() + " (duplicate set element?)";
            throw new InvalidObjectException(msg);
        }
        return valueCollection;
    }

    @Override
    void checkReconstructible() throws InvalidObjectException {
        this.elementConverter.checkReconstructible();
    }
}

