/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.internal.i18n.LocalizedStrings;

public final class StatisticDescriptorImpl
implements StatisticDescriptor {
    static final byte BYTE = 3;
    static final byte SHORT = 4;
    static final byte INT = 5;
    static final byte LONG = 6;
    static final byte FLOAT = 7;
    static final byte DOUBLE = 8;
    private int INVALID_OFFSET;
    private final String name;
    private final byte typeCode;
    private final String description;
    private final String unit;
    private final boolean isCounter;
    private final boolean isLargerBetter;
    private int id;

    public static final String getTypeCodeName(int code) {
        switch (code) {
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 7: {
                return "float";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 8: {
                return "double";
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.StatisticDescriptorImpl_UNKNOWN_TYPE_CODE_0.toLocalizedString(code));
    }

    public static final int getTypeCodeBits(int code) {
        switch (code) {
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 7: {
                return 32;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 8: {
                return 64;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.StatisticDescriptorImpl_UNKNOWN_TYPE_CODE_0.toLocalizedString(code));
    }

    public static final Class<?> getTypeCodeClass(byte code) {
        switch (code) {
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 7: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 6: {
                return Long.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.StatisticDescriptorImpl_UNKNOWN_TYPE_CODE_0.toLocalizedString(code));
    }

    public static StatisticDescriptor createIntCounter(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 5, description, units, true, isLargerBetter);
    }

    public static StatisticDescriptor createLongCounter(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 6, description, units, true, isLargerBetter);
    }

    public static StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 8, description, units, true, isLargerBetter);
    }

    public static StatisticDescriptor createIntGauge(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 5, description, units, false, isLargerBetter);
    }

    public static StatisticDescriptor createLongGauge(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 6, description, units, false, isLargerBetter);
    }

    public static StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean isLargerBetter) {
        return new StatisticDescriptorImpl(name, 8, description, units, false, isLargerBetter);
    }

    private StatisticDescriptorImpl(String name, byte typeCode, String description, String unit, boolean isCounter, boolean isLargerBetter) {
        this.id = this.INVALID_OFFSET = -1;
        this.name = name;
        this.typeCode = typeCode;
        this.description = description == null ? "" : description;
        this.unit = unit == null ? "" : unit;
        this.isCounter = isCounter;
        this.isLargerBetter = isLargerBetter;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final Class<?> getType() {
        return StatisticDescriptorImpl.getTypeCodeClass(this.typeCode);
    }

    public final int getStorageBits() {
        return StatisticDescriptorImpl.getTypeCodeBits(this.typeCode);
    }

    @Override
    public final boolean isCounter() {
        return this.isCounter;
    }

    @Override
    public final boolean isLargerBetter() {
        return this.isLargerBetter;
    }

    @Override
    public final String getUnit() {
        return this.unit;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    public final Number getNumberForRawBits(long bits) {
        switch (this.typeCode) {
            case 5: {
                return (int)bits;
            }
            case 6: {
                return bits;
            }
            case 8: {
                return Double.longBitsToDouble(bits);
            }
        }
        throw new RuntimeException(LocalizedStrings.StatisticsImpl_UNEXPECTED_STAT_DESCRIPTOR_TYPE_CODE_0.toLocalizedString(this.typeCode));
    }

    public final byte getTypeCode() {
        return this.typeCode;
    }

    final void setId(int id) {
        this.id = id;
    }

    @Override
    public int compareTo(StatisticDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public final int checkInt() {
        if (this.typeCode != 5) {
            throw new IllegalArgumentException(LocalizedStrings.StatisticDescriptorImpl_THE_STATISTIC_0_WITH_ID_1_IS_OF_TYPE_2_AND_IT_WAS_EXPECTED_TO_BE_AN_INT.toLocalizedString(this.getName(), this.getId(), StatisticDescriptorImpl.getTypeCodeName(this.getTypeCode())));
        }
        return this.id;
    }

    public final int checkLong() {
        if (this.typeCode != 6) {
            StringBuffer sb = new StringBuffer();
            sb.append("The statistic " + this.getName() + " with id ");
            sb.append(this.getId());
            sb.append(" is of type ");
            sb.append(StatisticDescriptorImpl.getTypeCodeName(this.getTypeCode()));
            sb.append(" and it was expected to be a long");
            throw new IllegalArgumentException(sb.toString());
        }
        return this.id;
    }

    public final int checkDouble() {
        if (this.typeCode != 8) {
            throw new IllegalArgumentException(LocalizedStrings.StatisticDescriptorImpl_THE_STATISTIC_0_WITH_ID_1_IS_OF_TYPE_2_AND_IT_WAS_EXPECTED_TO_BE_A_DOUBLE.toLocalizedString(this.getName(), this.getId(), StatisticDescriptorImpl.getTypeCodeName(this.getTypeCode())));
        }
        return this.id;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StatisticDescriptorImpl)) {
            return false;
        }
        StatisticDescriptorImpl other = (StatisticDescriptorImpl)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.isCounter() != other.isCounter()) {
            return false;
        }
        if (this.isLargerBetter() != other.isLargerBetter()) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        if (!this.getUnit().equals(other.getUnit())) {
            return false;
        }
        return this.getDescription().equals(other.getDescription());
    }
}

