/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SharedLibrary;
import org.apache.geode.internal.size.SingleObjectSizer;
import org.apache.geode.pdx.internal.unsafe.UnsafeWrapper;

public class ReflectionSingleObjectSizer
implements SingleObjectSizer {
    public static final int REFERENCE_SIZE = SharedLibrary.getReferenceSize();
    public static final int OBJECT_SIZE = SharedLibrary.getObjectHeaderSize();
    private static final UnsafeWrapper unsafe;

    @Override
    public long sizeof(Object object) {
        return this.sizeof(object, true);
    }

    public long sizeof(Object object, boolean roundResult) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            long size;
            if (unsafe != null) {
                size = unsafe.arrayBaseOffset(clazz);
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    int typeSize = unsafe.arrayScaleIndex(clazz);
                    if (typeSize == 0) {
                        typeSize = ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                    }
                    size += (long)arrayLength * (long)typeSize;
                }
            } else {
                size = OBJECT_SIZE + 4;
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    size += (long)arrayLength * (long)ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                }
            }
            if (roundResult) {
                size = ReflectionSingleObjectSizer.roundUpSize(size);
            }
            return size;
        }
        return ReflectionSingleObjectSizer.sizeof(clazz, roundResult);
    }

    public static long sizeof(Class clazz) {
        return ReflectionSingleObjectSizer.sizeof(clazz, true);
    }

    public static long sizeof(Class clazz, boolean roundResult) {
        long size;
        Assert.assertTrue(!clazz.isArray());
        if (unsafe != null) {
            Field lastField = null;
            long lastFieldOffset = 0L;
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    long offset;
                    if (Modifier.isStatic(field.getModifiers()) || (offset = unsafe.fieldOffset(field)) < lastFieldOffset) continue;
                    lastFieldOffset = offset;
                    lastField = field;
                }
            } while (lastField == null && (clazz = clazz.getSuperclass()) != null);
            size = lastField != null ? lastFieldOffset + (long)ReflectionSingleObjectSizer.sizeType(lastField.getType()) : (long)OBJECT_SIZE;
        } else {
            size = OBJECT_SIZE;
            do {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    size += (long)ReflectionSingleObjectSizer.sizeType(field.getType());
                }
            } while ((clazz = clazz.getSuperclass()) != null);
        }
        if (roundResult) {
            size = ReflectionSingleObjectSizer.roundUpSize(size);
        }
        return size;
    }

    public static long roundUpSize(long size) {
        long remainder = size % 8L;
        if (remainder != 0L) {
            size = size - remainder + 8L;
        }
        return size;
    }

    private static int sizeType(Class<?> t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return REFERENCE_SIZE;
    }

    static {
        UnsafeWrapper tmp = null;
        try {
            tmp = new UnsafeWrapper();
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Error error) {
            // empty catch block
        }
        unsafe = tmp;
    }
}

